/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.util;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeFrame {
    private Date low;
    private Date high;
    private int binCount;
    private double binWidth;
    private Type timeframe;
    private BinType timebin;
    private Calendar highDate;
    private Calendar lowDate;

    public static Calendar computeHighTimeFromNow(BinType type) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int hh = 0;
        int dd = cal.get(5);
        if (type == BinType.HOUR) {
            hh = cal.get(11) < 12 ? 12 : 24;
        } else {
            ++dd;
        }
        cal.set(5, dd);
        cal.set(11, hh);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public TimeFrame() {
        this(System.currentTimeMillis());
    }

    public TimeFrame(long highTime) {
        this.high = new Date(highTime);
        this.highDate = Calendar.getInstance();
        this.lowDate = Calendar.getInstance();
        this.binCount = 1;
        this.timeframe = Type.DAY;
    }

    public void configure() {
        Calendar cdate = Calendar.getInstance();
        cdate.setTime(this.high);
        if (this.timeframe == Type.DAY) {
            this.low = new Date(this.high.getTime() - TimeUnit.DAYS.toMillis(1L));
        } else if (this.timeframe == Type.WEEK) {
            this.low = new Date(this.high.getTime() - TimeUnit.DAYS.toMillis(7L));
        } else if (this.timeframe == Type.MONTH) {
            this.low = new Date(this.high.getTime() - TimeUnit.DAYS.toMillis(30L));
        } else if (this.timeframe == Type.YEAR) {
            this.low = new Date(this.high.getTime() - TimeUnit.DAYS.toMillis(365L));
        } else if (this.timeframe == Type.THIS_DAY) {
            cdate.set(12, 0);
            cdate.set(13, 0);
            cdate.set(11, 0);
            this.low = new Date(cdate.getTimeInMillis());
            cdate.set(12, 59);
            cdate.set(13, 59);
            cdate.set(11, 23);
            this.high = new Date(cdate.getTimeInMillis());
        } else if (this.timeframe == Type.THIS_WEEK) {
            cdate.set(7, 1);
            cdate.set(13, 0);
            cdate.set(12, 0);
            cdate.set(11, 0);
            this.low = new Date(cdate.getTimeInMillis());
            cdate.set(13, 59);
            cdate.set(12, 59);
            cdate.set(11, 23);
            cdate.set(7, 7);
            this.high = new Date(cdate.getTimeInMillis());
        } else if (this.timeframe == Type.THIS_MONTH) {
            cdate.set(5, 1);
            cdate.set(13, 0);
            cdate.set(12, 0);
            cdate.set(11, 0);
            this.low = new Date(cdate.getTimeInMillis());
            cdate.set(13, 59);
            cdate.set(12, 59);
            cdate.set(11, 23);
            cdate.set(5, cdate.getActualMaximum(5));
            this.high = new Date(cdate.getTimeInMillis());
        } else if (this.timeframe == Type.THIS_YEAR) {
            cdate.set(5, 1);
            cdate.set(2, 0);
            cdate.set(13, 0);
            cdate.set(12, 0);
            cdate.set(11, 0);
            this.low = new Date(cdate.getTimeInMillis());
            cdate.set(2, 11);
            cdate.set(13, 59);
            cdate.set(12, 59);
            cdate.set(11, 23);
            cdate.set(5, cdate.getActualMaximum(5));
            this.high = new Date(cdate.getTimeInMillis());
        }
        this.binWidth = this.timebin == BinType.TEN_MINUTE ? 600.0 : (this.timebin == BinType.HOUR ? 3600.0 : (this.timebin == BinType.DAY ? 86400.0 : (this.timebin == BinType.WEEK ? 604800.0 : (this.timebin == BinType.MONTH ? 2592000.0 : 3600.0))));
        this.binCount = (int)((this.getHighTime().doubleValue() / 1000.0 - this.getLowTime().doubleValue() / 1000.0) / this.binWidth);
    }

    public Long getLowTime() {
        return this.low.getTime();
    }

    public Long getHighTime() {
        return this.high.getTime();
    }

    public Date getLow() {
        return this.low;
    }

    public Date getHigh() {
        return this.high;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public Calendar getHighDate() {
        return this.highDate;
    }

    public Calendar getLowDate() {
        return this.lowDate;
    }

    public Type getTimeframe() {
        return this.timeframe;
    }

    public void setTimeframe(Type timeframe) {
        this.timeframe = timeframe;
    }

    public BinType getTimebin() {
        return this.timebin;
    }

    public void setTimebin(BinType timebin) {
        this.timebin = timebin;
    }

    public static enum BinType {
        TEN_MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH;

    }

    public static enum Type {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        THIS_DAY,
        THIS_WEEK,
        THIS_MONTH,
        THIS_YEAR;

    }
}

