/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dcache.services.billing.plots.util.ITimeFrameHistogram;
import org.dcache.services.billing.plots.util.ITimeFramePlot;
import org.dcache.services.billing.plots.util.PlotGridPosition;

public abstract class AbstractTimeFramePlot
implements ITimeFramePlot {
    protected final Properties properties;
    protected int rows;
    protected int cols;
    protected String name;
    protected File exportSubdir;
    protected String extension;
    protected String imageType;
    protected final Map<String, List<ITimeFrameHistogram>> histograms;

    protected AbstractTimeFramePlot(Properties properties) {
        this.properties = properties;
        this.rows = Integer.parseInt(properties.getProperty("plot.grid.rows"));
        this.cols = Integer.parseInt(properties.getProperty("plot.grid.cols"));
        String d = properties.getProperty("export.subdir");
        if (d != null) {
            this.exportSubdir = new File(d);
            this.imageType = properties.getProperty("export.imagetype");
            this.extension = properties.getProperty("export.extension");
        }
        this.histograms = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void addHistogram(PlotGridPosition position, ITimeFrameHistogram histogram) {
        List<ITimeFrameHistogram> current = this.getHistogramsForPosition(position);
        current.add(histogram);
    }

    @Override
    public List<ITimeFrameHistogram> getHistogramsForPosition(PlotGridPosition position) {
        this.checkPosition(position);
        List<ITimeFrameHistogram> current = this.histograms.get(position.getKey());
        if (current == null) {
            current = new ArrayList<ITimeFrameHistogram>();
            this.histograms.put(position.getKey(), current);
        }
        return current;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void checkPosition(PlotGridPosition position) throws IllegalArgumentException {
        if (position == null) {
            throw new IllegalArgumentException("no grid position defined");
        }
        int row = position.getRow();
        int col = position.getCol();
        if (row < 0 || row >= this.rows || col < 0 || col >= this.cols) {
            throw new IllegalArgumentException("position " + position.getKey() + " not on defined grid " + this.rows + " X " + this.cols);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

