/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.util;

import java.util.ArrayList;
import java.util.Collection;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.data.IPlotData;
import org.dcache.services.billing.db.exceptions.BillingQueryException;
import org.dcache.services.billing.plots.exceptions.TimeFrameFactoryInitializationException;
import org.dcache.services.billing.plots.util.ITimeFrameHistogramFactory;
import org.dcache.services.billing.plots.util.TimeFrame;

public abstract class AbstractTimeFrameHistogramFactory
implements ITimeFrameHistogramFactory {
    protected IBillingInfoAccess access;

    @Override
    public void initialize(IBillingInfoAccess access) throws TimeFrameFactoryInitializationException {
        this.access = access;
    }

    protected <T extends IPlotData> Collection<IPlotData> getFineGrainedPlotData(Class<T> clzz, TimeFrame timeFrame, String field, String type, Object value) throws BillingQueryException {
        return this.getPlotData(clzz, field + " == value && dateStamp >= date1 && dateStamp < date2 && errorCode == 0", type + " value, java.util.Date date1, java.util.Date date2", value, timeFrame.getLow(), timeFrame.getHigh());
    }

    protected <T extends IPlotData> Collection<IPlotData> getFineGrainedPlotData(Class<T> clzz, TimeFrame timeFrame) throws BillingQueryException {
        return this.getPlotData(clzz, "dateStamp >= date1 && dateStamp < date2 && errorCode == 0", "java.util.Date date1, java.util.Date date2", timeFrame.getLow(), timeFrame.getHigh());
    }

    protected <T extends IPlotData> Collection<IPlotData> getCoarseGrainedPlotData(Class<T> clzz, TimeFrame timeFrame) throws BillingQueryException {
        return this.getPlotData(clzz, "date >= date1 && date <= date2", "java.util.Date date1, java.util.Date date2", timeFrame.getLow(), timeFrame.getHigh());
    }

    private <T extends IPlotData> Collection<IPlotData> getPlotData(Class<T> clzz, String filter, String params, Object ... values) throws BillingQueryException {
        Collection<T> c = this.access.get(clzz, filter, params, values);
        ArrayList<IPlotData> plotData = new ArrayList<IPlotData>();
        plotData.addAll(c);
        return plotData;
    }
}

