/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ITree;
import hep.aida.ref.plotter.PlotterUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.dcache.services.billing.plots.jaida.JaidaTimeFrameHistogram;
import org.dcache.services.billing.plots.util.AbstractTimeFramePlot;
import org.dcache.services.billing.plots.util.ITimeFrameHistogram;
import org.dcache.services.billing.plots.util.PlotGridPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaidaTimeFramePlot
extends AbstractTimeFramePlot {
    private static final Logger _log = LoggerFactory.getLogger(JaidaTimeFramePlot.class);
    private final IPlotterFactory factory;
    private final IPlotter plotter;
    private List<IPlotterStyle> styles;
    private String[] titles;

    public JaidaTimeFramePlot(IAnalysisFactory af, ITree tree, String plotName, String[] titles, Properties properties) {
        super(properties);
        this.name = plotName;
        this.factory = af.createPlotterFactory();
        this.plotter = this.factory.create(plotName);
        this.titles = titles;
        if (this.titles == null) {
            this.titles = new String[0];
        }
    }

    @Override
    public void plot() {
        this.setHistogramStyles();
        this.plotter.createRegions(this.rows, this.cols);
        int region = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                PlotGridPosition p = new PlotGridPosition(row, col);
                List<ITimeFrameHistogram> histograms = this.getHistogramsForPosition(p);
                for (ITimeFrameHistogram h : histograms) {
                    IPlotterStyle style = this.factory.createPlotterStyle();
                    this.normalizeTitleStyle(style);
                    this.normalizeDataStyleForConnected(style, h);
                    this.normalizeXAxisStyle(style, h);
                    this.normalizeYAxisStyle(style, h);
                    if (region < this.titles.length) {
                        this.plotter.region(region).setTitle(this.titles[region]);
                    }
                    this.plotter.region(region).plot((IBaseHistogram)((JaidaTimeFrameHistogram)h).getHistogram(), style);
                }
                ++region;
            }
        }
        if (this.exportSubdir != null) {
            this.exportPlot();
        } else {
            this.plotter.show();
        }
    }

    private void exportPlot() {
        File path = new File(this.exportSubdir, this.name + this.extension);
        try {
            PlotterUtilities.writeToFile((IPlotter)this.plotter, (String)path.getAbsolutePath(), (String)this.imageType, (Properties)this.properties);
        }
        catch (IOException e) {
            _log.error("Cannot write billing plot: " + e.getMessage());
        }
    }

    private void setHistogramStyles() {
        this.styles = new ArrayList<IPlotterStyle>();
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                PlotGridPosition p = new PlotGridPosition(row, col);
                List<ITimeFrameHistogram> histograms = this.getHistogramsForPosition(p);
                for (ITimeFrameHistogram h : histograms) {
                    IPlotterStyle style = this.factory.createPlotterStyle();
                    this.normalizeTitleStyle(style);
                    this.normalizeDataStyleForConnected(style, h);
                    this.normalizeXAxisStyle(style, h);
                    this.normalizeYAxisStyle(style, h);
                    this.styles.add(style);
                }
            }
        }
    }

    private void normalizeTitleStyle(IPlotterStyle style) {
        style.titleStyle().textStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("plot.title.size")));
        style.titleStyle().textStyle().setBold(true);
        style.titleStyle().textStyle().setColor(this.properties.getProperty("plot.title.color"));
        style.titleStyle().textStyle().setVisible(true);
    }

    private void normalizeDataStyleForConnected(IPlotterStyle histogramStyle, ITimeFrameHistogram histogram) {
        histogramStyle.dataStyle().errorBarStyle().setVisible(false);
        histogramStyle.dataStyle().fillStyle().setVisible(false);
        histogramStyle.dataStyle().lineStyle().setVisible(false);
        histogramStyle.dataStyle().showInStatisticsBox(false);
        histogramStyle.dataStyle().outlineStyle().setVisible(true);
        histogramStyle.dataStyle().outlineStyle().setColor(histogram.getColor());
        histogramStyle.dataStyle().outlineStyle().setThickness(Integer.parseInt(this.properties.getProperty("curve.thickness")));
        histogramStyle.dataStyle().markerStyle().setShape(this.properties.getProperty("marker.shape"));
        histogramStyle.dataStyle().markerStyle().setSize(Integer.parseInt(this.properties.getProperty("marker.size")));
        histogramStyle.dataStyle().markerStyle().setColor(histogram.getColor());
        histogramStyle.dataStyle().markerStyle().setVisible(true);
    }

    private void normalizeXAxisStyle(IPlotterStyle histogramStyle, ITimeFrameHistogram histogram) {
        histogramStyle.xAxisStyle().setParameter("type", this.properties.getProperty("x.axis.type"));
        histogramStyle.xAxisStyle().setLabel(histogram.getXLabel());
        histogramStyle.xAxisStyle().labelStyle().setBold(true);
        histogramStyle.xAxisStyle().labelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("x.axis.size")));
        histogramStyle.xAxisStyle().labelStyle().setItalic(true);
        histogramStyle.xAxisStyle().labelStyle().setColor(this.properties.getProperty("x.axis.label.color"));
        histogramStyle.xAxisStyle().tickLabelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("x.axis.tick.size")));
        histogramStyle.xAxisStyle().tickLabelStyle().setBold(true);
        histogramStyle.xAxisStyle().tickLabelStyle().setColor(this.properties.getProperty("x.axis.tick.label.color"));
    }

    private void normalizeYAxisStyle(IPlotterStyle histogramStyle, ITimeFrameHistogram histogram) {
        histogramStyle.yAxisStyle().setLabel(histogram.getYLabel());
        histogramStyle.yAxisStyle().labelStyle().setBold(true);
        histogramStyle.yAxisStyle().labelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("y.axis.size")));
        histogramStyle.yAxisStyle().labelStyle().setItalic(true);
        histogramStyle.yAxisStyle().labelStyle().setColor(this.properties.getProperty("y.axis.label.color"));
        histogramStyle.yAxisStyle().tickLabelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("y.axis.tick.size")));
        histogramStyle.yAxisStyle().tickLabelStyle().setBold(true);
        histogramStyle.yAxisStyle().tickLabelStyle().setColor(this.properties.getProperty("y.axis.tick.label.color"));
        histogramStyle.yAxisStyle().setScaling(histogram.getScaling());
        histogramStyle.yAxisStyle().setParameter("allowZeroSuppression", this.properties.getProperty("y.axis.allow.zero.suppression"));
    }
}

