/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.data.BaseDaily;
import org.dcache.services.billing.db.data.CostDaily;
import org.dcache.services.billing.db.data.DcacheReadsDaily;
import org.dcache.services.billing.db.data.DcacheTimeDaily;
import org.dcache.services.billing.db.data.DcacheWritesDaily;
import org.dcache.services.billing.db.data.HSMReadsDaily;
import org.dcache.services.billing.db.data.HSMWritesDaily;
import org.dcache.services.billing.db.data.HitsDaily;
import org.dcache.services.billing.db.data.IPlotData;
import org.dcache.services.billing.db.data.MoverData;
import org.dcache.services.billing.db.data.PoolCostData;
import org.dcache.services.billing.db.data.PoolHitData;
import org.dcache.services.billing.db.data.StorageData;
import org.dcache.services.billing.db.exceptions.BillingQueryException;
import org.dcache.services.billing.plots.exceptions.TimeFrameFactoryInitializationException;
import org.dcache.services.billing.plots.jaida.JaidaTimeFrameHistogram;
import org.dcache.services.billing.plots.jaida.JaidaTimeFramePlot;
import org.dcache.services.billing.plots.util.AbstractTimeFrameHistogramFactory;
import org.dcache.services.billing.plots.util.ITimeFrameHistogram;
import org.dcache.services.billing.plots.util.ITimeFramePlot;
import org.dcache.services.billing.plots.util.TimeFrame;

public final class JaidaTimeFrameHistogramFactory
extends AbstractTimeFrameHistogramFactory {
    private IAnalysisFactory af;
    private IHistogramFactory factory;
    private ITree tree;
    private Properties properties;

    @Override
    public void initialize(IBillingInfoAccess access) throws TimeFrameFactoryInitializationException {
        this.initialize(access, (String)null);
    }

    @Override
    public void initialize(IBillingInfoAccess access, String propertiesPath) throws TimeFrameFactoryInitializationException {
        super.initialize(access);
        this.af = IAnalysisFactory.create();
        this.tree = this.af.createTreeFactory().create();
        this.factory = this.af.createHistogramFactory(this.tree);
        this.properties = new Properties();
        try {
            this.setDefaults();
            if (propertiesPath != null) {
                this.properties.load(new FileInputStream(new File(propertiesPath)));
            }
        }
        catch (Throwable t) {
            throw new TimeFrameFactoryInitializationException(t);
        }
    }

    @Override
    public void initialize(IBillingInfoAccess access, Properties properties) throws TimeFrameFactoryInitializationException {
        super.initialize(access);
        this.af = IAnalysisFactory.create();
        this.tree = this.af.createTreeFactory().create();
        this.factory = this.af.createHistogramFactory(this.tree);
        this.properties = properties;
    }

    @Override
    public ITimeFramePlot createPlot(String plotName, String[] subtitles) {
        return new JaidaTimeFramePlot(this.af, this.tree, plotName, subtitles, this.properties);
    }

    @Override
    public ITimeFrameHistogram createDcBytesHistogram(TimeFrame timeFrame, boolean write) {
        String title = write ? this.getProperty("label.dcache.writes") : this.getProperty("label.dcache.reads");
        JaidaTimeFrameHistogram histogram = new JaidaTimeFrameHistogram(this.factory, timeFrame, title);
        histogram.setXLabel(this.getProperty("label.x.axis"));
        histogram.setScaling(this.getProperty("scaling.bytes"));
        histogram.setColor(this.getProperty("color.dcache"));
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            histogram.setYLabel(this.getProperty("label.y.axis.gbytes.hourly"));
            try {
                plotData = this.getFineGrainedPlotData(MoverData.class, timeFrame, "isNew", "java.lang.Boolean", write);
                histogram.setData(plotData, "transferSize", 1.073741824E9);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            histogram.setYLabel(this.getProperty("label.y.axis.gbytes.daily"));
            try {
                if (write) {
                    plotData = this.getCoarseGrainedPlotData(DcacheWritesDaily.class, timeFrame);
                    histogram.setData(plotData, "size", 1.073741824E9);
                } else {
                    plotData = this.getCoarseGrainedPlotData(DcacheReadsDaily.class, timeFrame);
                    histogram.setData(plotData, "size", 1.073741824E9);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram createDcTransfersHistogram(TimeFrame timeFrame, boolean write) throws Throwable {
        String title = write ? this.getProperty("label.dcache.writes") : this.getProperty("label.dcache.reads");
        JaidaTimeFrameHistogram histogram = new JaidaTimeFrameHistogram(this.factory, timeFrame, title);
        histogram.setXLabel(this.getProperty("label.x.axis"));
        histogram.setScaling(this.getProperty("scaling.count"));
        histogram.setColor(this.getProperty("color.dcache"));
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            histogram.setYLabel(this.getProperty("label.y.axis.transfers.hourly"));
            try {
                plotData = this.getFineGrainedPlotData(MoverData.class, timeFrame, "isNew", "java.lang.Boolean", write);
                histogram.setData(plotData, null, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                histogram.setYLabel(this.getProperty("label.y.axis.transfers.daily"));
                if (write) {
                    plotData = this.getCoarseGrainedPlotData(DcacheWritesDaily.class, timeFrame);
                    histogram.setData(plotData, "count", null);
                } else {
                    plotData = this.getCoarseGrainedPlotData(DcacheReadsDaily.class, timeFrame);
                    histogram.setData(plotData, "count", null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram createHsmBytesHistogram(TimeFrame timeFrame, boolean write) {
        String title = write ? this.getProperty("label.hsm.writes") : this.getProperty("label.hsm.reads");
        JaidaTimeFrameHistogram histogram = new JaidaTimeFrameHistogram(this.factory, timeFrame, title);
        histogram.setXLabel(this.getProperty("label.x.axis"));
        histogram.setScaling(this.getProperty("scaling.bytes"));
        histogram.setColor(this.getProperty("color.hsm"));
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            histogram.setYLabel(this.getProperty("label.y.axis.gbytes.hourly"));
            try {
                plotData = this.getFineGrainedPlotData(StorageData.class, timeFrame, "action", "java.lang.String", write ? "store" : "restore");
                histogram.setData(plotData, "fullSize", 1.073741824E9);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            histogram.setYLabel(this.getProperty("label.y.axis.gbytes.daily"));
            try {
                if (write) {
                    plotData = this.getCoarseGrainedPlotData(HSMWritesDaily.class, timeFrame);
                    histogram.setData(plotData, "size", 1.073741824E9);
                } else {
                    plotData = this.getCoarseGrainedPlotData(HSMReadsDaily.class, timeFrame);
                    histogram.setData(plotData, "size", 1.073741824E9);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram createHsmTransfersHistogram(TimeFrame timeFrame, boolean write) throws Throwable {
        String title = write ? this.getProperty("label.hsm.writes") : this.getProperty("label.hsm.reads");
        JaidaTimeFrameHistogram histogram = new JaidaTimeFrameHistogram(this.factory, timeFrame, title);
        histogram.setXLabel(this.getProperty("label.x.axis"));
        histogram.setScaling(this.getProperty("scaling.count"));
        histogram.setColor(this.getProperty("color.hsm"));
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            histogram.setYLabel(this.getProperty("label.y.axis.transfers.hourly"));
            try {
                plotData = this.getFineGrainedPlotData(StorageData.class, timeFrame, "action", "java.lang.String", write ? "store" : "restore");
                histogram.setData(plotData, null, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            histogram.setYLabel(this.getProperty("label.y.axis.transfers.daily"));
            try {
                if (write) {
                    plotData = this.getCoarseGrainedPlotData(HSMWritesDaily.class, timeFrame);
                    histogram.setData(plotData, "count", null);
                } else {
                    plotData = this.getCoarseGrainedPlotData(HSMReadsDaily.class, timeFrame);
                    histogram.setData(plotData, "count", null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram[] createDcConnectTimeHistograms(TimeFrame timeFrame) throws Throwable {
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            try {
                plotData = this.getHourlyAggregateForTime(timeFrame);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                plotData = this.getCoarseGrainedPlotData(DcacheTimeDaily.class, timeFrame);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        String[] title = new String[]{this.getProperty("label.minimum"), this.getProperty("label.maximum"), this.getProperty("label.average")};
        String[] field = new String[]{"minimum", "maximum", "average"};
        String[] color = new String[]{this.getProperty("color.min"), this.getProperty("color.max"), this.getProperty("color.avg")};
        ITimeFrameHistogram[] histogram = new ITimeFrameHistogram[3];
        for (int h = 0; h < histogram.length; ++h) {
            histogram[h] = new JaidaTimeFrameHistogram(this.factory, timeFrame, title[h]);
            histogram[h].setXLabel(this.getProperty("label.x.axis"));
            histogram[h].setYLabel(this.getProperty("label.y.axis.connection.time"));
            histogram[h].setColor(color[h]);
            histogram[h].setScaling(this.getProperty("scaling.time"));
            histogram[h].setData(plotData, field[h], 1.0 * (double)TimeUnit.MINUTES.toMillis(1L));
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram createCostHistogram(TimeFrame timeFrame) {
        JaidaTimeFrameHistogram histogram = new JaidaTimeFrameHistogram(this.factory, timeFrame, this.getProperty("label.cost"));
        histogram.setXLabel(this.getProperty("label.x.axis"));
        histogram.setColor(this.getProperty("color.dcache"));
        String scaling = this.getProperty("scaling.cost");
        if (scaling != null) {
            histogram.setScaling(scaling);
        }
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            histogram.setYLabel(this.getProperty("label.y.axis.cost.hourly"));
            try {
                plotData = this.getFineGrainedPlotData(PoolCostData.class, timeFrame);
                histogram.setData(plotData, "cost", null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            histogram.setYLabel(this.getProperty("label.y.axis.cost.daily"));
            try {
                plotData = this.getCoarseGrainedPlotData(CostDaily.class, timeFrame);
                histogram.setData(plotData, "totalCost", null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return histogram;
    }

    @Override
    public ITimeFrameHistogram[] createHitHistograms(TimeFrame timeFrame) throws Throwable {
        Collection<IPlotData> plotData = null;
        if (TimeFrame.BinType.HOUR == timeFrame.getTimebin()) {
            try {
                plotData = this.getHourlyAggregateForHits(timeFrame);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                plotData = this.getCoarseGrainedPlotData(HitsDaily.class, timeFrame);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ITimeFrameHistogram[] histogram = new ITimeFrameHistogram[2];
        histogram[0] = new JaidaTimeFrameHistogram(this.factory, timeFrame, this.getProperty("label.cached"));
        histogram[0].setXLabel(this.getProperty("label.x.axis"));
        histogram[0].setYLabel(this.getProperty("label.y.axis.hits.hourly"));
        histogram[0].setScaling(this.getProperty("scaling.count"));
        histogram[0].setColor(this.getProperty("color.cached"));
        histogram[0].setData(plotData, "cached", null);
        histogram[1] = new JaidaTimeFrameHistogram(this.factory, timeFrame, this.getProperty("label.ncached"));
        histogram[1].setXLabel(this.getProperty("label.x.axis"));
        histogram[1].setYLabel(this.getProperty("label.y.axis.hits.daily"));
        histogram[1].setScaling(this.getProperty("scaling.count"));
        histogram[1].setColor(this.getProperty("color.ncached"));
        histogram[1].setData(plotData, "notcached", null);
        return histogram;
    }

    private void setDefaults() {
        this.properties.setProperty("plot.title.color", "black");
        this.properties.setProperty("plot.title.size", "16");
        this.properties.setProperty("plot.grid.rows", "1");
        this.properties.setProperty("plot.grid.cols", "1");
        this.properties.setProperty("plotWidth", "1000");
        this.properties.setProperty("plotHeight", "500");
        this.properties.setProperty("curve.thickness", "3");
        this.properties.setProperty("marker.shape", "box");
        this.properties.setProperty("marker.shape", "9");
        this.properties.setProperty("x.axis.type", "date");
        this.properties.setProperty("x.axis.size", "14");
        this.properties.setProperty("x.axis.label.color", "black");
        this.properties.setProperty("x.axis.tick.size", "10");
        this.properties.setProperty("x.axis.tick.label.color", "black");
        this.properties.setProperty("y.axis.size", "14");
        this.properties.setProperty("y.axis.label.color", "black");
        this.properties.setProperty("y.axis.tick.size", "10");
        this.properties.setProperty("y.axis.tick.label.color", "black");
        this.properties.setProperty("y.axis.allow.zero.suppression", "false");
    }

    private Collection<IPlotData> getHourlyAggregateForTime(TimeFrame timeFrame) throws BillingQueryException {
        Collection<IPlotData> plotData = this.getFineGrainedPlotData(MoverData.class, timeFrame);
        TreeMap<String, DcacheTimeDaily> hourlyAggregate = new TreeMap<String, DcacheTimeDaily>();
        for (IPlotData d : plotData) {
            Date date = this.normalizeForHour(d.timestamp());
            String key = date.toString();
            DcacheTimeDaily hourlyData = (DcacheTimeDaily)hourlyAggregate.get(key);
            if (hourlyData == null) {
                hourlyData = new DcacheTimeDaily();
                hourlyData.setDate(date);
                hourlyAggregate.put(key, hourlyData);
            }
            long time = d.data().get("connectionTime").longValue();
            hourlyData.setCount(hourlyData.getCount() + 1L);
            hourlyData.setTotalTime(hourlyData.getTotalTime() + time);
            long min = hourlyData.getMinimum();
            if (0L != min) {
                hourlyData.setMinimum(Math.min(hourlyData.getMinimum(), time));
            }
            hourlyData.setMaximum(Math.max(hourlyData.getMaximum(), time));
        }
        plotData = new ArrayList<IPlotData>();
        plotData.addAll(hourlyAggregate.values());
        return plotData;
    }

    private Collection<IPlotData> getHourlyAggregateForHits(TimeFrame timeFrame) throws BillingQueryException {
        Collection<IPlotData> plotData = this.getFineGrainedPlotData(PoolHitData.class, timeFrame);
        TreeMap<String, HourlyHitData> hourlyAggregate = new TreeMap<String, HourlyHitData>();
        for (IPlotData d : plotData) {
            Long l;
            Long l2;
            HourlyHitData hourlyHitData;
            boolean cached = ((PoolHitData)d).getFileCached();
            Date date = this.normalizeForHour(d.timestamp());
            String key = date.toString();
            HourlyHitData hourlyData = (HourlyHitData)hourlyAggregate.get(key);
            if (hourlyData == null) {
                hourlyData = new HourlyHitData();
                hourlyData.setDate(date);
                hourlyAggregate.put(key, hourlyData);
            }
            if (cached) {
                hourlyHitData = hourlyData;
                l2 = hourlyHitData.cached;
                l = hourlyHitData.cached = hourlyHitData.cached + 1L;
                continue;
            }
            hourlyHitData = hourlyData;
            l2 = hourlyHitData.notcached;
            l = hourlyHitData.notcached = hourlyHitData.notcached + 1L;
        }
        plotData = new ArrayList<IPlotData>();
        plotData.addAll(hourlyAggregate.values());
        return plotData;
    }

    private Date normalizeForHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name, null);
    }

    private static class HourlyHitData
    extends BaseDaily {
        private Long cached = 0L;
        private Long notcached = 0L;

        private HourlyHitData() {
        }

        @Override
        public Map<String, Double> data() {
            Map<String, Double> dataMap = super.data();
            dataMap.put("cached", this.cached.doubleValue());
            dataMap.put("notcached", this.notcached.doubleValue());
            return dataMap;
        }

        public String toString() {
            return "(" + this.dateString() + "," + this.cached + "," + this.notcached + ")";
        }
    }
}

