/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots;

import dmg.util.Args;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.exceptions.BillingInitializationException;
import org.dcache.services.billing.plots.util.ITimeFrameHistogram;
import org.dcache.services.billing.plots.util.ITimeFrameHistogramFactory;
import org.dcache.services.billing.plots.util.ITimeFramePlot;
import org.dcache.services.billing.plots.util.PlotGridPosition;
import org.dcache.services.billing.plots.util.TimeFrame;
import org.dcache.services.billing.plots.util.TimeFramePlotFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class BillingHistory
implements Runnable {
    public static final String[] TYPE = new String[]{"bytes_rd", "bytes_wr", "transfers_rd", "transfers_wr", "time", "hits", "cost"};
    public static final String[] EXT = new String[]{"_dy", "_wk", "_mo", "_yr"};
    protected static final String DEFAULT_SLEEP = "30";
    protected static final String DEFAULT_PROPERTIES = "org/dcache/services/billing/plot/plot.properties";
    protected static final String ACCESS_BEAN = "jdbc-billing-info-access";
    protected static final String CONTEXT_LOCATION = "dbAccessContext";
    protected static final String PLOT_PROPERTIES_OPT = "plotsProperties";
    protected static final String PLOT_DIR_OPT = "plotsDir";
    protected static final String SUB_DIR_OPT = "subDir";
    protected static final String EXPORT_TYPE_OPT = "exportType";
    protected static final String EXPORT_EXT_OPT = "exportExt";
    protected static final String TIMEOUT_OPT = "plotsTimeout";
    public static String[] TITLE;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TimeFrame[] timeFrame;
    protected final Properties properties;
    protected final Args args;
    protected String[] TIME_DESC;
    protected String plotDir;
    protected String subDir;
    protected String imgExt;
    protected String imgType;
    protected Long timeout;
    protected IBillingInfoAccess access;
    protected ITimeFrameHistogramFactory factory;
    protected boolean running;
    protected File plotDirF;

    public BillingHistory(Args args) {
        this.args = args;
        this.properties = new Properties();
        this.timeFrame = new TimeFrame[4];
    }

    @Override
    public void run() {
        this.logger.debug("starting run ...");
        try {
            this.initialize();
        }
        catch (Throwable t) {
            this.logger.error("error intializing billing history thread; quitting ...", t);
            return;
        }
        if (this.plotDirF.exists() && !this.plotDirF.isDirectory()) {
            this.plotDirF.delete();
        }
        this.setRunning(true);
        while (this.isRunning()) {
            try {
                if (!this.plotDirF.exists()) {
                    this.plotDirF.mkdirs();
                }
                this.logger.debug("generating time frames ...");
                this.generateTimeFrames();
                this.logger.debug("generating plots ...");
                for (int t = 0; t < this.timeFrame.length; ++t) {
                    Date d = this.timeFrame[t].getLow();
                    this.generateReadWritePlot(TYPE[0] + EXT[t], TITLE[0] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t], false, true);
                    this.generateReadWritePlot(TYPE[1] + EXT[t], TITLE[1] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t], true, true);
                    this.generateReadWritePlot(TYPE[2] + EXT[t], TITLE[2] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t], false, false);
                    this.generateReadWritePlot(TYPE[3] + EXT[t], TITLE[3] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t], true, false);
                    this.generateConnectionTimePlot(TYPE[4] + EXT[t], TITLE[4] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t]);
                    this.generateHitsPlot(TYPE[5] + EXT[t], TITLE[5] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t]);
                    this.generateCostPlot(TYPE[6] + EXT[t], TITLE[6] + " (" + this.TIME_DESC[t] + d + ")", this.timeFrame[t]);
                }
            }
            catch (Throwable t) {
                this.logger.error("error generating billing history plots; quitting ...", t);
                return;
            }
            try {
                this.logger.debug("sleeping ...");
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void initialize() throws Throwable {
        this.logger.debug("initializing ...");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.initializeProperties(classLoader);
        this.synchronizeProperties();
        this.initializeAccess(classLoader);
        TimeFramePlotFactory plotFactory = TimeFramePlotFactory.getInstance(this.access);
        String impl = this.properties.getProperty("histogram.factory");
        this.factory = plotFactory.create(impl, this.properties);
    }

    private void initializeProperties(ClassLoader classLoader) throws IOException {
        this.logger.debug("initializeProperties ...");
        String path = null;
        Args args = this.getArgs();
        if (args != null) {
            path = args.getOpt(PLOT_PROPERTIES_OPT);
        }
        if (path != null && !"".equals(path.trim())) {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot run BillingHistory thread for properties file: " + file);
            }
            this.properties.load(new FileInputStream(file));
        } else {
            URL resource = classLoader.getResource(DEFAULT_PROPERTIES);
            if (resource == null) {
                throw new FileNotFoundException("Cannot run BillingHistory thread for properties resource: " + resource);
            }
            this.properties.load(resource.openStream());
        }
        TITLE = new String[7];
        BillingHistory.TITLE[0] = this.properties.getProperty("title.bytes.read");
        BillingHistory.TITLE[1] = this.properties.getProperty("title.bytes.written");
        BillingHistory.TITLE[2] = this.properties.getProperty("title.transfers.read");
        BillingHistory.TITLE[3] = this.properties.getProperty("title.transfers.write");
        BillingHistory.TITLE[4] = this.properties.getProperty("title.connection.time");
        BillingHistory.TITLE[5] = this.properties.getProperty("title.cache.hits");
        BillingHistory.TITLE[6] = this.properties.getProperty("title.pool.cost");
        this.TIME_DESC = new String[4];
        this.TIME_DESC[0] = this.properties.getProperty("desc.daily");
        this.TIME_DESC[1] = this.properties.getProperty("desc.weekly");
        this.TIME_DESC[2] = this.properties.getProperty("desc.monthly");
        this.TIME_DESC[3] = this.properties.getProperty("desc.yearly");
    }

    private void synchronizeProperties() {
        this.logger.debug("synchronizeProperties ...");
        String plotsTimeout = null;
        Args args = this.getArgs();
        if (args != null) {
            this.plotDir = args.getOpt(PLOT_DIR_OPT);
            this.subDir = args.getOpt(SUB_DIR_OPT);
            this.imgType = args.getOpt(EXPORT_TYPE_OPT);
            this.imgExt = args.getOpt(EXPORT_EXT_OPT);
            plotsTimeout = args.getOpt(TIMEOUT_OPT);
        }
        if (this.plotDir != null) {
            this.properties.setProperty("export.subdir", this.plotDir);
        } else {
            this.plotDir = this.properties.getProperty("export.subdir");
        }
        if (this.plotDir == null) {
            throw new IllegalArgumentException("Cannot run BillingStatistics thread in interactive mode");
        }
        this.plotDirF = new File(this.plotDir);
        if (this.imgType != null) {
            this.properties.setProperty("export.imagetype", this.imgType);
        }
        if (this.imgExt != null) {
            this.properties.setProperty("export.extension", this.imgExt);
        } else {
            this.imgExt = this.properties.getProperty("export.extension");
        }
        if (plotsTimeout == null) {
            plotsTimeout = this.properties.getProperty("thread.timeout.in.minutes", DEFAULT_SLEEP);
        }
        this.timeout = 60000L * Long.parseLong(plotsTimeout);
    }

    private void initializeAccess(ClassLoader classLoader) throws NoSuchBeanDefinitionException, BillingInitializationException {
        this.logger.debug("initializeAccess ...");
        BillingHistoryApplicationContext context = new BillingHistoryApplicationContext();
        if (context != null && context.isSingleton(ACCESS_BEAN)) {
            this.access = (IBillingInfoAccess)context.getBean(ACCESS_BEAN);
        }
        this.access.initialize();
        this.logger.debug("initializeAccess successful");
    }

    private void generateTimeFrames() {
        Calendar high = TimeFrame.computeHighTimeFromNow(TimeFrame.BinType.HOUR);
        this.timeFrame[0] = this.getConfiguredTimeFrame(high, TimeFrame.BinType.HOUR, TimeFrame.Type.DAY);
        high = TimeFrame.computeHighTimeFromNow(TimeFrame.BinType.DAY);
        this.timeFrame[1] = this.getConfiguredTimeFrame(high, TimeFrame.BinType.DAY, TimeFrame.Type.WEEK);
        this.timeFrame[2] = this.getConfiguredTimeFrame(high, TimeFrame.BinType.DAY, TimeFrame.Type.MONTH);
        this.timeFrame[3] = this.getConfiguredTimeFrame(high, TimeFrame.BinType.DAY, TimeFrame.Type.YEAR);
    }

    private TimeFrame getConfiguredTimeFrame(Calendar high, TimeFrame.BinType bin, TimeFrame.Type type) {
        TimeFrame timeFrame = new TimeFrame(high.getTimeInMillis());
        timeFrame.setTimebin(bin);
        timeFrame.setTimeframe(type);
        timeFrame.configure();
        return timeFrame;
    }

    private void generateReadWritePlot(String fileName, String title, TimeFrame timeFrame, boolean write, boolean size) {
        try {
            ITimeFramePlot plot = this.factory.createPlot(fileName, new String[]{title});
            this.logger.debug("generateReadWritePlot created ITimeFramePlot for " + fileName);
            ITimeFrameHistogram[] histogram = this.createReadWriteHistograms(timeFrame, write, size);
            this.logger.debug("generateReadWritePlot created histogram set for " + fileName);
            PlotGridPosition pos = new PlotGridPosition(0, 0);
            for (ITimeFrameHistogram h : histogram) {
                plot.addHistogram(pos, h);
            }
            plot.plot();
            this.logger.debug("generateReadWritePlot completed for " + fileName);
        }
        catch (Throwable t) {
            this.logger.error("could not generate " + fileName + " for " + timeFrame.getHigh(), t);
        }
    }

    private void generateConnectionTimePlot(String fileName, String title, TimeFrame timeFrame) {
        try {
            ITimeFramePlot plot = this.factory.createPlot(fileName, new String[]{title});
            ITimeFrameHistogram[] histogram = this.factory.createDcConnectTimeHistograms(timeFrame);
            PlotGridPosition pos = new PlotGridPosition(0, 0);
            for (ITimeFrameHistogram h : histogram) {
                plot.addHistogram(pos, h);
            }
            plot.plot();
            this.logger.debug("generateConnectionTimePlot completed for " + fileName);
        }
        catch (Throwable t) {
            this.logger.error("could not generate " + fileName + " for " + timeFrame.getHigh(), t);
        }
    }

    private void generateHitsPlot(String fileName, String title, TimeFrame timeFrame) {
        try {
            ITimeFramePlot plot = this.factory.createPlot(fileName, new String[]{title});
            ITimeFrameHistogram[] histogram = this.factory.createHitHistograms(timeFrame);
            PlotGridPosition pos = new PlotGridPosition(0, 0);
            for (ITimeFrameHistogram h : histogram) {
                plot.addHistogram(pos, h);
            }
            plot.plot();
            this.logger.debug("generateHitsPlot completed for " + fileName);
        }
        catch (Throwable t) {
            this.logger.error("could not generate " + fileName + " for " + timeFrame.getHigh(), t);
        }
    }

    private void generateCostPlot(String fileName, String title, TimeFrame timeFrame) {
        try {
            ITimeFramePlot plot = this.factory.createPlot(fileName, new String[]{title});
            ITimeFrameHistogram h = this.factory.createCostHistogram(timeFrame);
            PlotGridPosition pos = new PlotGridPosition(0, 0);
            plot.addHistogram(pos, h);
            plot.plot();
            this.logger.debug("generateCostPlot completed for " + fileName);
        }
        catch (Throwable t) {
            this.logger.error("could not generate " + fileName + " for " + timeFrame.getHigh(), t);
        }
    }

    private ITimeFrameHistogram[] createReadWriteHistograms(TimeFrame timeFrame, boolean write, boolean size) throws Throwable {
        if (size) {
            return new ITimeFrameHistogram[]{this.factory.createDcBytesHistogram(timeFrame, write), this.factory.createHsmBytesHistogram(timeFrame, write)};
        }
        return new ITimeFrameHistogram[]{this.factory.createDcTransfersHistogram(timeFrame, write), this.factory.createHsmTransfersHistogram(timeFrame, write)};
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public void close() {
        this.access.close();
    }

    public Args getArgs() {
        return this.args;
    }

    private class BillingHistoryApplicationContext
    extends ClassPathXmlApplicationContext {
        private BillingHistoryApplicationContext() {
            super(BillingHistory.this.args.getOption(BillingHistory.CONTEXT_LOCATION));
        }

        private ByteArrayResource getArgumentsResource() {
            Args args = new Args(BillingHistory.this.getArgs());
            args.shift();
            Properties contextProperties = new Properties();
            String arguments = args.toString().replaceAll("-\\$\\{[0-9]+\\}", "");
            contextProperties.setProperty("arguments", arguments);
            for (Map.Entry e : args.optionsAsMap().entrySet()) {
                String key = (String)e.getKey();
                Object value = e.getValue();
                contextProperties.setProperty(key, value.toString());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                contextProperties.store(out, "");
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            byte[] _domainContext = out.toByteArray();
            return new ByteArrayResource(_domainContext){

                public String getFilename() {
                    return "arguments.properties";
                }
            };
        }

        public Resource getResource(String location) {
            if (location.startsWith("arguments:")) {
                return this.getArgumentsResource();
            }
            return super.getResource(location);
        }
    }
}

