/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.html;

import diskCacheV111.util.HTMLWriter;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.Args;
import dmg.util.HttpException;
import dmg.util.HttpRequest;
import dmg.util.HttpResponseEngine;
import java.util.Map;
import org.dcache.services.billing.plots.BillingHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpBillingHistoryEngine
extends BillingHistory
implements HttpResponseEngine {
    private static final Logger _log = LoggerFactory.getLogger(HttpBillingHistoryEngine.class);
    private static final String fileSep = System.getProperty("file.separator");
    private static final String THUMBNAIL_W = "120";
    private static final String THUMBNAIL_H = "60";
    private CellNucleus nucleus;
    private final Thread _billingHistory;

    public HttpBillingHistoryEngine(CellNucleus nucleus, String[] args) {
        super(new Args(args));
        this.nucleus = nucleus;
        this._billingHistory = nucleus.newThread((Runnable)this, "billing-history");
    }

    public void startup() {
        this._billingHistory.start();
    }

    public void shutdown() {
        this.setRunning(false);
        this._billingHistory.interrupt();
        try {
            this._billingHistory.join();
        }
        catch (InterruptedException e) {
            _log.warn("Interrupted while waiting for BillingHistory thread to terminate");
        }
        this.close();
    }

    public void queryUrl(HttpRequest request) throws HttpException {
        request.printHttpHeader(0);
        this.emit(new HTMLWriter(request.getOutputStream(), (Map<String, Object>)this.nucleus.getDomainContext()));
    }

    public void emit(HTMLWriter contents) {
        contents.addHeader("/styles/common.css", "Billing History Plots");
        contents.println("<table align='center'>");
        contents.println("<tr>");
        contents.println("<th>Plot Type</th>");
        contents.println("<th>24-Hour</th>");
        contents.println("<th>Weekly</th>");
        contents.println("<th>Monthly</th>");
        contents.println("<th>Yearly</th>");
        contents.println("</tr>");
        for (int t = 0; t < BillingHistory.TYPE.length; ++t) {
            this.printRow(contents, BillingHistory.TITLE[t], BillingHistory.TYPE[t]);
        }
        contents.println("</table>");
        contents.addFooter(this.getClass().getName());
        contents.flush();
    }

    private void printRow(HTMLWriter contents, String title, String type) {
        contents.println("<tr>");
        contents.println("<td align='right'><i>" + title + "</i></td>");
        String prefix = this.subDir + fileSep + type;
        for (String tag : BillingHistory.EXT) {
            String file = prefix + tag + this.imgExt;
            contents.println("<td><a href='" + file + "'> <img src='" + file + "' width=" + THUMBNAIL_W + " height=" + THUMBNAIL_H + "> </a></td>");
        }
        contents.println("</tr>");
    }
}

