/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl.datanucleus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.dcache.services.billing.db.exceptions.BillingInitializationException;
import org.dcache.services.billing.db.exceptions.BillingQueryException;
import org.dcache.services.billing.db.exceptions.BillingStorageException;
import org.dcache.services.billing.db.impl.BaseBillingInfoAccess;

public class DataNucleusBillingInfo
extends BaseBillingInfoAccess {
    public static final String DEFAULT_PROPERTIES = "org/dcache/services/billing/db/datanucleus.properties";
    private PersistenceManagerFactory pmf;
    private PersistenceManager insertManager;

    @Override
    public void initializeInternal() throws BillingInitializationException {
        this.addJdbcDNProperties();
        try {
            if (this.propertiesPath != null && !"".equals(this.propertiesPath.trim())) {
                File file = new File(this.propertiesPath);
                if (!file.exists()) {
                    throw new FileNotFoundException("Cannot run BillingInfoCell for properties file: " + file);
                }
                this.properties.load(new FileInputStream(file));
            } else {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL resource = classLoader.getResource(DEFAULT_PROPERTIES);
                if (resource == null) {
                    throw new FileNotFoundException("Cannot run BillingInfoCell for properties resource: " + resource);
                }
                this.properties.load(resource.openStream());
            }
            this.pmf = JDOHelper.getPersistenceManagerFactory((Map)this.properties);
        }
        catch (Throwable t) {
            throw new BillingInitializationException(t);
        }
    }

    private void addJdbcDNProperties() {
        if (this.jdbcDriver != null && !"".equals(this.jdbcDriver)) {
            this.properties.setProperty("datanucleus.ConnectionDriverName", this.jdbcDriver);
        }
        if (this.jdbcUrl != null && !"".equals(this.jdbcUrl)) {
            this.properties.setProperty("datanucleus.ConnectionURL", this.jdbcUrl);
        }
        if (this.jdbcUser != null && !"".equals(this.jdbcUser)) {
            this.properties.setProperty("datanucleus.ConnectionUserName", this.jdbcUser);
        }
        if (this.jdbcPassword != null && !"".equals(this.jdbcPassword)) {
            this.properties.setProperty("datanucleus.ConnectionPassword", this.jdbcPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(T data) throws BillingStorageException {
        if (!this.isRunning()) {
            return;
        }
        DataNucleusBillingInfo dataNucleusBillingInfo = this;
        synchronized (dataNucleusBillingInfo) {
            Transaction tx = null;
            try {
                if (this.insertManager == null) {
                    this.logger.debug("put, new write manager ...");
                    this.insertManager = this.pmf.getPersistenceManager();
                }
                if (!(tx = this.insertManager.currentTransaction()).isActive()) {
                    tx.begin();
                }
                this.insertManager.makePersistent(data);
                ++this.insertCount;
            }
            catch (Throwable e) {
                this.printSQLException("put " + data, e);
                DataNucleusBillingInfo.rollbackIfActive(tx);
            }
        }
        this.doCommitIfNeeded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommitIfNeeded(boolean force) {
        DataNucleusBillingInfo dataNucleusBillingInfo = this;
        synchronized (dataNucleusBillingInfo) {
            this.logger.debug("doCommitIfNeeded, count={}", (Object)this.insertCount);
            if (force || this.insertCount >= this.maxInsertsBeforeCommit) {
                Transaction tx = null;
                try {
                    if (this.insertManager != null) {
                        this.logger.debug("committing {} cached objects", (Object)this.insertCount);
                        tx = this.insertManager.currentTransaction();
                        tx.commit();
                    }
                }
                catch (Throwable t) {
                    this.printSQLException("committing  " + this.insertCount + " cached objects", t);
                    DataNucleusBillingInfo.rollbackIfActive(tx);
                }
                finally {
                    if (this.insertManager != null) {
                        this.insertManager.close();
                        this.insertManager = null;
                    }
                    this.insertCount = 0;
                }
            }
        }
    }

    @Override
    public <T> Collection<T> get(Class<T> type, String filter, String parameters, Object ... values) throws BillingQueryException {
        if (!this.isRunning()) {
            return null;
        }
        PersistenceManager readManager = this.pmf.getPersistenceManager();
        Transaction tx = readManager.currentTransaction();
        try {
            tx.begin();
            Query query = DataNucleusBillingInfo.createQuery(readManager, type, filter, parameters);
            this.logger.debug("created query {}", (Object)query);
            Collection c = values == null ? (Collection)query.execute() : (Collection)query.executeWithArray(values);
            this.logger.debug("got collection {}", (Object)c);
            Collection detached = readManager.detachCopyAll(c);
            this.logger.debug("got detatched collection {}", (Object)detached);
            tx.commit();
            this.logger.debug("successfully executed {}", (Object)"get: {}, {}. {}. {}", (Object)new Object[]{type, filter, parameters, Arrays.asList(values)});
            Collection collection = detached;
            return collection;
        }
        catch (Throwable t) {
            String message = "get: " + type + ", " + filter + ", " + parameters + ", " + Arrays.asList(values);
            this.printSQLException(message, t);
            throw new BillingQueryException(message, t);
        }
        finally {
            DataNucleusBillingInfo.rollbackIfActive(tx);
            readManager.close();
        }
    }

    @Override
    public <T> Collection<T> get(Class<T> type) throws BillingQueryException {
        return this.get(type, null, null, new Object[]{null});
    }

    @Override
    public <T> Collection<T> get(Class<T> type, String filter, Object ... values) throws BillingQueryException {
        return this.get(type, filter, null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        if (this.pmf != null) {
            DataNucleusBillingInfo dataNucleusBillingInfo = this;
            synchronized (dataNucleusBillingInfo) {
                if (this.insertManager != null) {
                    this.insertManager.close();
                }
            }
            this.pmf.close();
        }
    }

    @Override
    public <T> long remove(Class<T> type) throws BillingQueryException {
        if (!this.isRunning()) {
            return 0L;
        }
        PersistenceManager deleteManager = this.pmf.getPersistenceManager();
        Transaction tx = deleteManager.currentTransaction();
        this.logger.debug("remove all instances of {}", type);
        long removed = 0L;
        try {
            tx.begin();
            Query query = deleteManager.newQuery("DELETE FROM " + type.getName());
            removed = (Long)query.execute();
            tx.commit();
            this.logger.debug("successfully removed " + removed + " entries of type " + type);
            long l = removed;
            return l;
        }
        catch (Throwable t) {
            String message = "remove all instances of " + type;
            this.printSQLException(message, t);
            throw new BillingQueryException(message, t);
        }
        finally {
            DataNucleusBillingInfo.rollbackIfActive(tx);
            deleteManager.close();
        }
    }

    @Override
    public <T> long remove(Class<T> type, String filter, Object ... values) throws BillingQueryException {
        return this.remove(type, filter, null, values);
    }

    @Override
    public <T> long remove(Class<T> type, String filter, String parameters, Object ... values) throws BillingQueryException {
        if (!this.isRunning()) {
            return 0L;
        }
        PersistenceManager deleteManager = this.pmf.getPersistenceManager();
        Transaction tx = deleteManager.currentTransaction();
        long removed = 0L;
        try {
            tx.begin();
            Query query = DataNucleusBillingInfo.createQuery(deleteManager, type, filter, parameters);
            removed = values == null ? query.deletePersistentAll() : query.deletePersistentAll(values);
            tx.commit();
            this.logger.debug("successfully removed {} entries of type {}", (Object)removed, type);
            long l = removed;
            return l;
        }
        catch (Throwable t) {
            String message = "remove: " + type + ", " + filter + ", " + parameters + ", " + Arrays.asList(values);
            this.printSQLException(message, t);
            throw new BillingQueryException(message, t);
        }
        finally {
            DataNucleusBillingInfo.rollbackIfActive(tx);
            deleteManager.close();
        }
    }

    private void printSQLException(String message, Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof SQLException) {
            SQLException e = (SQLException)t;
            this.logger.error(e.getMessage());
            this.logger.error("Error code: {}", (Object)e.getErrorCode());
            this.logger.error("SQL state: {}", (Object)e.getSQLState());
        } else {
            this.logger.error(message, t);
        }
        this.printSQLException(message, t.getCause());
    }

    private static Query createQuery(PersistenceManager pm, Class type, String filter, String parameters) {
        if (parameters == null) {
            if (filter == null) {
                return pm.newQuery(type);
            }
            return pm.newQuery(type, filter);
        }
        Query query = pm.newQuery(type);
        query.setFilter(filter);
        query.declareParameters(parameters);
        query.addExtension("datanucleus.rdbms.query.resultSetType", (Object)"scroll-insensitive");
        query.addExtension("datanucleus.query.resultCacheType", (Object)"none");
        query.getFetchPlan().setFetchSize(0);
        return query;
    }

    private static void rollbackIfActive(Transaction tx) {
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
    }

    @Override
    public void setPropertiesPath(String propetiesPath) {
        this.propertiesPath = propetiesPath;
    }
}

