/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl;

import java.util.Properties;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.exceptions.BillingInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBillingInfoAccess
implements IBillingInfoAccess {
    protected static final String MAX_INSERTS_PROPERTY = "dbAccessMaxInsertsBeforeCommit";
    protected static final String MAX_TIMEOUT_PROPERTY = "dbAccessMaxTimeBeforeCommit";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Properties properties;
    protected String propertiesPath;
    protected String jdbcDriver;
    protected String jdbcUrl;
    protected String jdbcUser;
    protected String jdbcPassword;
    protected int insertCount = 0;
    protected int maxInsertsBeforeCommit = 1;
    protected int maxTimeBeforeCommit = 0;
    private Thread flushD;
    private boolean running;

    @Override
    public final void initialize() throws BillingInitializationException {
        this.properties = new Properties();
        this.initializeInternal();
        this.logger.debug("maxInsertsBeforeCommit {}", (Object)this.maxInsertsBeforeCommit);
        this.logger.debug("maxTimeBeforeCommit {}", (Object)this.maxTimeBeforeCommit);
        if (this.maxTimeBeforeCommit > 0) {
            this.flushD = new TimedCommitter();
            this.setRunning(true);
            this.flushD.start();
        }
    }

    @Override
    public void close() {
        this.setRunning(false);
        if (this.flushD != null) {
            try {
                this.logger.debug("interrupting flush daemon");
                this.flushD.interrupt();
                this.logger.debug("waiting for flush daemon to exit");
                this.flushD.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.logger.debug("{} close exiting", (Object)this);
    }

    protected abstract void initializeInternal() throws BillingInitializationException;

    protected synchronized boolean isRunning() {
        return this.running;
    }

    protected synchronized void setRunning(boolean running) {
        this.running = running;
    }

    protected abstract void doCommitIfNeeded(boolean var1);

    public Properties getProperties() {
        return this.properties;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setMaxInsertsBeforeCommit(int maxInsertsBeforeCommit) {
        this.maxInsertsBeforeCommit = maxInsertsBeforeCommit;
    }

    public void setMaxTimeBeforeCommit(int maxTimeBeforeCommit) {
        this.maxTimeBeforeCommit = maxTimeBeforeCommit;
    }

    public void setPropertiesPath(String propetiesPath) {
        this.propertiesPath = propetiesPath;
    }

    protected class TimedCommitter
    extends Thread {
        protected TimedCommitter() {
        }

        @Override
        public void run() {
            while (BaseBillingInfoAccess.this.isRunning()) {
                try {
                    BaseBillingInfoAccess.this.logger.debug("{} sleeping", (Object)this);
                    Thread.sleep((long)BaseBillingInfoAccess.this.maxTimeBeforeCommit * 1000L);
                    BaseBillingInfoAccess.this.logger.debug("{} calling doCommitIfNeeded", (Object)this);
                    BaseBillingInfoAccess.this.doCommitIfNeeded(true);
                }
                catch (InterruptedException interruptedException) {}
            }
            BaseBillingInfoAccess.this.logger.debug("{} calling doCommitIfNeeded", (Object)this);
            BaseBillingInfoAccess.this.doCommitIfNeeded(true);
            BaseBillingInfoAccess.this.logger.debug("{} exiting", (Object)this);
        }
    }
}

