/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CostException;
import diskCacheV111.util.DestinationCostException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.SourceCostException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dcache.poolmanager.ClassicPartition;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public class WassPartition
extends ClassicPartition {
    private static final double SECONDS_IN_WEEK = TimeUnit.DAYS.toSeconds(7L);
    private static final double LOG2 = Math.log(2.0);
    static final String TYPE = "wass";
    protected static final SecureRandom _random = new SecureRandom();
    protected transient Function<PoolInfo, String> _getHost;
    protected transient Function<PoolInfo, String> _getName;

    public WassPartition(Map<String, String> inherited) {
        this(inherited, NO_PROPERTIES);
    }

    protected WassPartition(Map<String, String> inherited, Map<String, String> properties) {
        super(inherited, properties);
        this.initTransientFields();
    }

    @Override
    protected Partition create(Map<String, String> inherited, Map<String, String> properties) {
        return new WassPartition(inherited, properties);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected double random() {
        return _random.nextDouble();
    }

    protected double getAvailableRemovable(PoolCostInfo.PoolSpaceInfo space) {
        double halflife;
        double removable = space.getRemovableSpace();
        double breakeven = space.getBreakEven();
        double lru = space.getLRUSeconds();
        if (breakeven >= 1.0) {
            halflife = SECONDS_IN_WEEK * 2.0;
        } else if (breakeven > 0.0) {
            halflife = SECONDS_IN_WEEK * -LOG2 / Math.log(breakeven);
        } else {
            return removable;
        }
        double undecayed = lru > 0.0 ? removable * halflife * (1.0 - Math.pow(2.0, -lru / halflife)) / (lru * LOG2) : removable;
        return removable - undecayed;
    }

    protected double getAvailable(PoolCostInfo.PoolSpaceInfo space, long filesize) {
        long free = space.getFreeSpace();
        long gap = space.getGap();
        double removable = this.getAvailableRemovable(space);
        double available = (double)free + removable;
        return available - (double)filesize > (double)gap ? available : 0.0;
    }

    protected double getWeightedAvailable(PoolCostInfo info, long filesize) {
        double available = this.getAvailable(info.getSpaceInfo(), filesize);
        double load = this._performanceCostFactor * info.getMoverCostFactor() * (double)info.getWriters();
        return Math.pow(available, this._spaceCostFactor) / Math.pow(2.0, load);
    }

    protected PoolInfo selectByAvailableSpace(List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        long filesize = attributes.getSize();
        double[] available = new double[pools.size()];
        double sum = 0.0;
        for (int i = 0; i < available.length; ++i) {
            available[i] = sum += this.getWeightedAvailable(pools.get(i).getCostInfo(), filesize);
        }
        double threshold = this.random() * sum;
        for (int i = 0; i < available.length; ++i) {
            if (!(threshold < available[i])) continue;
            return pools.get(i);
        }
        return null;
    }

    @Override
    public PoolInfo selectWritePool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        PoolInfo pool = this.selectByAvailableSpace(pools, attributes);
        if (pool == null) {
            throw new CacheException(21, "All pools are full");
        }
        return pool;
    }

    @Override
    public Partition.P2pPair selectPool2Pool(CostModule cm, List<PoolInfo> src, List<PoolInfo> dst, FileAttributes attributes, boolean force) throws CacheException {
        PoolInfo destination;
        double maxTargetCost;
        Preconditions.checkState((!src.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!dst.isEmpty() ? 1 : 0) != 0);
        if ((long)src.size() >= this._maxPnfsFileCopies) {
            throw new PermissionDeniedCacheException("P2P denied: already too many copies (" + src.size() + ")");
        }
        Collections.shuffle(src);
        List sources = this._byPerformanceCost.sortedCopy(Iterables.transform(src, this.toPoolCost(0L)));
        if (!force && this.isAlertCostExceeded(((ClassicPartition.PoolCost)sources.get((int)0)).performanceCost)) {
            throw new SourceCostException("P2P denied: All source pools are too busy (performance cost > " + this._alertCostCut + ")");
        }
        double d = maxTargetCost = this._slope > 0.01 ? this._slope * ((ClassicPartition.PoolCost)sources.get((int)0)).performanceCost : this.getCurrentCostCut(cm);
        if (!force && maxTargetCost > 0.0) {
            Predicate condition = Predicates.compose(this.performanceCostIsBelow(maxTargetCost), this.toPoolCost(attributes.getSize()));
            dst = Lists.newArrayList((Iterable)Iterables.filter(dst, (Predicate)condition));
        }
        if (dst.isEmpty()) {
            throw new DestinationCostException("P2P denied: All destination pools are too busy (performance cost > " + maxTargetCost + ")");
        }
        if (this._allowSameHostCopy != ClassicPartition.SameHost.NOTCHECKED) {
            for (ClassicPartition.PoolCost source : sources) {
                PoolInfo destination2;
                ArrayList destinations;
                if (source.host == null) {
                    destinations = dst;
                } else {
                    Predicate notSameHost = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)source.host)), this._getHost);
                    destinations = Lists.newArrayList((Iterable)Iterables.filter((Iterable)dst, (Predicate)notSameHost));
                }
                if ((destination2 = this.selectByAvailableSpace(destinations, attributes)) == null) continue;
                return new Partition.P2pPair(source.pool, destination2);
            }
            if (this._allowSameHostCopy == ClassicPartition.SameHost.NEVER) {
                throw new PermissionDeniedCacheException("P2P denied: sameHostCopy is 'never' and no matching pool found");
            }
        }
        if ((destination = this.selectByAvailableSpace(dst, attributes)) == null) {
            throw new DestinationCostException("All pools are full");
        }
        return new Partition.P2pPair(((ClassicPartition.PoolCost)sources.get((int)0)).pool, destination);
    }

    private PoolInfo selectByPrevious(List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        ArrayList filteredPools;
        PoolInfo pool;
        Predicate notSamePool = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)previousPool)), this._getName);
        if (previousHost != null && this._allowSameHostRetry != ClassicPartition.SameHost.NOTCHECKED) {
            Predicate notSameHost = Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)previousHost)), this._getHost);
            ArrayList filteredPools2 = Lists.newArrayList((Iterable)Iterables.filter(pools, (Predicate)Predicates.and((Predicate)notSamePool, (Predicate)notSameHost)));
            PoolInfo pool2 = this.selectByAvailableSpace(filteredPools2, attributes);
            if (pool2 != null) {
                return pool2;
            }
            if (this._allowSameHostRetry == ClassicPartition.SameHost.NEVER) {
                return null;
            }
        }
        if (previousPool != null && (pool = this.selectByAvailableSpace(filteredPools = Lists.newArrayList((Iterable)Iterables.filter(pools, (Predicate)notSamePool)), attributes)) != null) {
            return pool;
        }
        return this.selectByAvailableSpace(pools, attributes);
    }

    @Override
    public PoolInfo selectStagePool(CostModule cm, List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        boolean fallback = false;
        if (this._fallbackCostCut > 0.0) {
            Predicate belowFallback = Predicates.compose(this.performanceCostIsBelow(this._fallbackCostCut), this.toPoolCost(attributes.getSize()));
            ArrayList filtered = Lists.newArrayList((Iterable)Iterables.filter(pools, (Predicate)belowFallback));
            PoolInfo pool = this.selectByPrevious(filtered, previousPool, previousHost, attributes);
            if (pool != null) {
                return pool;
            }
            pool = this.selectByPrevious(pools, previousPool, previousHost, attributes);
            if (pool == null) {
                throw new CostException("All pools full", null, true, false);
            }
            throw new CostException("Fallback cost exceeded", pool, true, false);
        }
        PoolInfo pool = this.selectByPrevious(pools, previousPool, previousHost, attributes);
        if (pool == null) {
            throw new CostException("All pools full", null, true, false);
        }
        return pool;
    }

    private void initTransientFields() {
        this._getHost = new Function<PoolInfo, String>(){

            public String apply(PoolInfo pool) {
                return pool.getHostName();
            }
        };
        this._getName = new Function<PoolInfo, String>(){

            public String apply(PoolInfo pool) {
                return pool.getName();
            }
        };
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initTransientFields();
    }
}

