/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.util.CacheException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public class WRandomPartition
extends Partition {
    public static final String TYPE = "wrandom";
    private final Random _random = new SecureRandom();

    public WRandomPartition(Map<String, String> inherited) {
        super(NO_PROPERTIES, inherited, NO_PROPERTIES);
    }

    @Override
    protected Partition create(Map<String, String> inherited, Map<String, String> properties) {
        return new WRandomPartition(inherited);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Partition.P2pPair selectPool2Pool(CostModule cm, List<PoolInfo> src, List<PoolInfo> dst, FileAttributes attributes, boolean force) throws CacheException {
        Collections.shuffle(src);
        for (PoolInfo srcPoolInfo : src) {
            ArrayList tryList = Lists.newArrayList((Iterable)Iterables.filter(dst, (Predicate)new DifferentHost(srcPoolInfo.getHostName())));
            if (tryList.isEmpty()) continue;
            PoolInfo destPoolInfo = this.selectWritePool(cm, tryList, attributes);
            return new Partition.P2pPair(srcPoolInfo, destPoolInfo);
        }
        return null;
    }

    @Override
    public PoolInfo selectReadPool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        return pools.get(this._random.nextInt(pools.size()));
    }

    @Override
    public PoolInfo selectStagePool(CostModule cm, List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        return this.selectWritePool(cm, pools, attributes);
    }

    @Override
    public PoolInfo selectWritePool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        WeightedPool[] weightedPools = this.toWeightedWritePoolsArray(pools);
        int index = this.selectWrandomIndex(weightedPools);
        return weightedPools[index].getCostInfo();
    }

    private WeightedPool[] toWeightedWritePoolsArray(Collection<PoolInfo> costInfos) {
        long totalFree = 0L;
        for (PoolInfo costInfo : costInfos) {
            long spaceToUse = costInfo.getCostInfo().getSpaceInfo().getFreeSpace() + costInfo.getCostInfo().getSpaceInfo().getRemovableSpace();
            totalFree += spaceToUse;
        }
        WeightedPool[] weghtedPools = new WeightedPool[costInfos.size()];
        int i = 0;
        for (PoolInfo costInfo : costInfos) {
            long spaceToUse = costInfo.getCostInfo().getSpaceInfo().getFreeSpace() + costInfo.getCostInfo().getSpaceInfo().getRemovableSpace();
            weghtedPools[i] = new WeightedPool(costInfo, (double)spaceToUse / (double)totalFree);
            ++i;
        }
        Arrays.sort(weghtedPools, new CostComparator());
        return weghtedPools;
    }

    private int selectWrandomIndex(WeightedPool[] weightedPools) {
        double selection = this._random.nextDouble();
        double total = 0.0;
        int i = 0;
        for (i = 0; i < weightedPools.length && total <= selection; total += weightedPools[i].getWeight(), ++i) {
        }
        return i - 1;
    }

    private class DifferentHost
    implements Predicate<PoolInfo> {
        private final String _host;

        DifferentHost(String host) {
            this._host = host;
        }

        public boolean apply(PoolInfo t) {
            String hostname = t.getHostName();
            return !this._host.equals(hostname);
        }
    }

    private static class WeightedPool {
        private final PoolInfo _costInfo;
        private final double _weight;

        public WeightedPool(PoolInfo costInfo, double weight) {
            this._costInfo = costInfo;
            this._weight = weight;
        }

        public PoolInfo getCostInfo() {
            return this._costInfo;
        }

        public double getWeight() {
            return this._weight;
        }
    }

    private static class CostComparator
    implements Comparator<WeightedPool> {
        private CostComparator() {
        }

        @Override
        public int compare(WeightedPool o1, WeightedPool o2) {
            return Double.compare(o1.getWeight(), o2.getWeight());
        }
    }
}

