/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.vehicles.PoolLinkGroupInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Utils {
    private Utils() {
    }

    public static Map<String, PoolLinkGroupInfo> linkGroupInfos(PoolSelectionUnit selectionUnit, CostModule costModule) {
        String[] linkGroups = selectionUnit.getLinkGroups();
        HashMap<String, PoolLinkGroupInfo> linkGroupInfos = new HashMap<String, PoolLinkGroupInfo>(linkGroups.length);
        for (int i_goup = 0; i_goup < linkGroups.length; ++i_goup) {
            String[] links = selectionUnit.getLinksByGroupName(linkGroups[i_goup]);
            long linkAvailableSpace = 0L;
            long linkTotalSpace = 0L;
            HashSet<String> referencedPools = new HashSet<String>();
            for (int i_link = 0; i_link < links.length; ++i_link) {
                PoolSelectionUnit.SelectionLink selectionLink = selectionUnit.getLinkByName(links[i_link]);
                for (PoolSelectionUnit.SelectionPool pool : selectionLink.pools()) {
                    String poolName;
                    if (!pool.isEnabled() || referencedPools.contains(poolName = pool.getName())) continue;
                    referencedPools.add(poolName);
                    PoolCostInfo poolCostInfo = costModule.getPoolCostInfo(poolName);
                    if (poolCostInfo == null) continue;
                    linkAvailableSpace += poolCostInfo.getSpaceInfo().getFreeSpace() + poolCostInfo.getSpaceInfo().getRemovableSpace();
                    linkTotalSpace += poolCostInfo.getSpaceInfo().getTotalSpace();
                }
            }
            PoolSelectionUnit.SelectionLinkGroup linkGroup = selectionUnit.getLinkGroupByName(linkGroups[i_goup]);
            PoolLinkGroupInfo linkGroupInfo = new PoolLinkGroupInfo(linkGroup, linkTotalSpace, linkAvailableSpace);
            linkGroupInfos.put(linkGroups[i_goup], linkGroupInfo);
        }
        return linkGroupInfos;
    }
}

