/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Joiner;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.poolManager.PoolSelectionUnit;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.CacheException;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellStub;
import org.dcache.pool.migration.PoolMigrationJobCancelMessage;

public class Rebalancer
implements CellCommandListener {
    private static final String JOB_NAME = "rebalance";
    private static final String METRIC_RELATIVE = "relative";
    private static final String METRIC_SPACE_COST = "sc";
    private PoolSelectionUnit _psu;
    private CostModule _cm;
    private CellStub _poolStub;
    public static final String hh_rebalance_pgroup = "[-metric=relative|sc] [-refresh=<period>] <pgroup>";
    public static final String fh_rebalance_pgroup = "Moves files between pools of a pool group to balance space usage.\n\nA migration job will be submitted to each pool in the pool group.\nThe combined effect of these migration jobs is to move files until\neither the relative space usage (used space relative to the total\nsize of the pool) is the same or the space cost is the same; which\ndepends on the metric used. The default is balance relative space\nusage.\n\nA pool can only  be the source of  one rebalance  run at a time.\nPrevious  rebalancing jobs  will be cancelled.  The PoolManager\nmaintains no state for the rebalancing job, however migration jobs\ncreated by the rebalancer have a well known name (rebalance).\n\nMigration jobs periodically query PoolManager about how much space\nis used on each pool and about the space cost. There will thus be\na delay between  files being moved between pools  and the metric\nbeing updated. It is expected that rebalancing jobs will overshoot\nthe target slightly. For very small pools on test instances this\neffect will be more profound than on large pools. The effect can\nbe reduced by reducing the refresh period. The default period is\n30 seconds.\n\nThe migration jobs created by the rebalancer will not survive a\npool restart. If the lots of files are written, deleted or moved\nwhile the rebalancing job runs, then the pool group may not be\ncompletely balanced when the jobs terminate. Run the rebalancer\na second time to improve the balance further.\n\nThis feature is EXPERIMENTAL. Please monitor the system while\nrebalancing is in progress.";
    public static final String hh_rebalance_cancel_pgroup = "<pgroup>";
    public static final String fh_rebalance_cancel_pgroup = "Cancels migration jobs created by the rebalancer.";

    public void setPoolSelectionUnit(PoolSelectionUnit psu) {
        this._psu = psu;
    }

    public void setCostModule(CostModule cm) {
        this._cm = cm;
    }

    public void setPoolStub(CellStub poolStub) {
        this._poolStub = poolStub;
    }

    private void cancelAll(Collection<PoolSelectionUnit.SelectionPool> pools) throws CacheException, InterruptedException {
        for (PoolSelectionUnit.SelectionPool pool : pools) {
            this._poolStub.sendAndWait(new CellPath(pool.getName()), new PoolMigrationJobCancelMessage(JOB_NAME, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_rebalance_pgroup_$_1(Args args) throws CacheException, InterruptedException {
        String command;
        int period;
        String metric = args.getOpt("metric");
        String refresh = args.getOpt("refresh");
        String poolGroup = args.argv(0);
        int n = period = refresh == null ? 30 : Integer.parseInt(refresh);
        if (metric == null) {
            metric = METRIC_RELATIVE;
        }
        long used = 0L;
        long total = 0L;
        ArrayList<PoolSelectionUnit.SelectionPool> pools = new ArrayList<PoolSelectionUnit.SelectionPool>();
        ArrayList<String> names = new ArrayList<String>();
        for (PoolSelectionUnit.SelectionPool pool : this._psu.getPoolsByPoolGroup(poolGroup)) {
            PoolCostInfo cost = this._cm.getPoolCostInfo(pool.getName());
            if (!pool.getPoolMode().isEnabled() || cost == null) continue;
            PoolCostInfo.PoolSpaceInfo spaceInfo = cost.getSpaceInfo();
            used += spaceInfo.getUsedSpace();
            total += spaceInfo.getTotalSpace();
            pools.add(pool);
            names.add(pool.getName());
        }
        if (metric.equals(METRIC_RELATIVE)) {
            double factor = (double)used / (double)total;
            command = String.format("migration move -id=%s -include-when='target.used < %2$f * target.total' -stop-when='targets == 0 or source.used <= %2$f * source.total' -refresh=%3$d %4$s", JOB_NAME, factor, period, Joiner.on((String)" ").join(names));
        } else if (metric.equals(METRIC_SPACE_COST)) {
            command = String.format("migration move -id=%s -include-when='target.spaceCost < source.spaceCost' -stop-when='targets == 0' -refresh=%d %s", JOB_NAME, period, Joiner.on((String)" ").join(names));
        } else {
            throw new IllegalArgumentException("Unsupported value for -metric: " + metric);
        }
        this.cancelAll(pools);
        boolean success = false;
        try {
            for (PoolSelectionUnit.SelectionPool pool : pools) {
                this._poolStub.sendAndWait(new CellPath(pool.getName()), (Serializable)((Object)command), String.class);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.cancelAll(pools);
            }
        }
        return "Rebalancing jobs have been submitted to " + Joiner.on((String)", ").join(names) + ".";
    }

    public String ac_rebalance_cancel_pgroup_$_1(Args args) throws CacheException, InterruptedException {
        this.cancelAll(this._psu.getPoolsByPoolGroup(args.argv(0)));
        return "";
    }
}

