/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.CacheException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public class LruPartition
extends Partition {
    static final long serialVersionUID = 2982471048144479008L;
    static final String TYPE = "lru";
    private static final AtomicLong _counter = new AtomicLong();
    private static final Random random = new Random();
    private static final ConcurrentMap<String, Long> _lastWrite = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, Long> _lastRead = Maps.newConcurrentMap();

    public LruPartition(Map<String, String> inherited) {
        this(inherited, NO_PROPERTIES);
    }

    public LruPartition(Map<String, String> inherited, Map<String, String> properties) {
        super(NO_PROPERTIES, inherited, properties);
    }

    @Override
    protected Partition create(Map<String, String> inherited, Map<String, String> properties) {
        return new LruPartition(inherited, properties);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Predicate<PoolInfo> canHoldFile(FileAttributes attributes) {
        final long filesize = attributes.getSize();
        return new Predicate<PoolInfo>(){

            public boolean apply(PoolInfo pool) {
                PoolCostInfo.PoolSpaceInfo space = pool.getCostInfo().getSpaceInfo();
                long available = space.getFreeSpace() + space.getRemovableSpace();
                return available - filesize > space.getGap();
            }
        };
    }

    private long next() {
        return _counter.getAndIncrement();
    }

    private PoolInfo select(List<PoolInfo> pools, ConcurrentMap<String, Long> lastAccessed) {
        long current;
        PoolInfo oldest;
        Preconditions.checkState((!pools.isEmpty() ? 1 : 0) != 0);
        do {
            oldest = null;
            current = Long.MAX_VALUE;
            for (PoolInfo pool : pools) {
                Long value = (Long)lastAccessed.get(pool.getName());
                if (value == null) {
                    value = -random.nextLong();
                }
                if (value >= current) continue;
                current = value;
                oldest = pool;
            }
        } while (!lastAccessed.replace(oldest.getName(), current, this.next()));
        return oldest;
    }

    @Override
    public PoolInfo selectWritePool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        ArrayList freePools = Lists.newArrayList((Iterable)Iterables.filter(pools, this.canHoldFile(attributes)));
        if (freePools.isEmpty()) {
            throw new CacheException(21, "All pools are full");
        }
        return this.select(freePools, _lastWrite);
    }

    @Override
    public PoolInfo selectReadPool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        return this.select(pools, _lastRead);
    }

    @Override
    public Partition.P2pPair selectPool2Pool(CostModule cm, List<PoolInfo> src, List<PoolInfo> dst, FileAttributes attributes, boolean force) throws CacheException {
        return new Partition.P2pPair(this.select(src, _lastRead), this.selectWritePool(cm, dst, attributes));
    }

    @Override
    public PoolInfo selectStagePool(CostModule cm, List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        return this.selectWritePool(cm, pools, attributes);
    }
}

