/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.pools.CostCalculatable;
import diskCacheV111.pools.CostCalculationV5;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CostException;
import diskCacheV111.util.DestinationCostException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.SourceCostException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public class ClassicPartition
extends Partition {
    static final long serialVersionUID = 8239030345609342048L;
    static final String TYPE = "classic";
    private static final double MAX_WRITE_COST = 1000000.0;
    private static final Map<String, String> DEFAULTS = ImmutableMap.builder().put((Object)"max-copies", (Object)"500").put((Object)"p2p", (Object)"0.0").put((Object)"alert", (Object)"0.0").put((Object)"halt", (Object)"0.0").put((Object)"fallback", (Object)"0.0").put((Object)"spacecostfactor", (Object)"1.0").put((Object)"cpucostfactor", (Object)"1.0").put((Object)"sameHostCopy", (Object)"besteffort").put((Object)"sameHostRetry", (Object)"besteffort").put((Object)"slope", (Object)"0.0").put((Object)"idle", (Object)"0.0").build();
    public final SameHost _allowSameHostCopy;
    public final SameHost _allowSameHostRetry;
    public final long _maxPnfsFileCopies;
    public final double _costCut;
    public final boolean _costCutIsPercentile;
    public final double _alertCostCut;
    public final double _panicCostCut;
    public final double _fallbackCostCut;
    public final double _spaceCostFactor;
    public final double _performanceCostFactor;
    public final double _slope;
    public final double _minCostCut;
    protected transient Ordering<PoolCost> _byPerformanceCost;
    protected transient Ordering<PoolCost> _byFullCost;

    public ClassicPartition() {
        this(NO_PROPERTIES);
    }

    public ClassicPartition(Map<String, String> inherited) {
        this(inherited, NO_PROPERTIES);
    }

    protected ClassicPartition(Map<String, String> inherited, Map<String, String> properties) {
        this(DEFAULTS, inherited, properties);
    }

    protected ClassicPartition(Map<String, String> defaults, Map<String, String> inherited, Map<String, String> properties) {
        super(defaults, inherited, properties);
        this.initTransientFields();
        this._allowSameHostCopy = SameHost.valueOf(this.getProperty("sameHostCopy").toUpperCase());
        this._allowSameHostRetry = SameHost.valueOf(this.getProperty("sameHostRetry").toUpperCase());
        this._maxPnfsFileCopies = this.getLong("max-copies");
        this._alertCostCut = this.getDouble("alert");
        this._panicCostCut = this.getDouble("halt");
        this._fallbackCostCut = this.getDouble("fallback");
        this._spaceCostFactor = this.getDouble("spacecostfactor");
        this._performanceCostFactor = this.getDouble("cpucostfactor");
        this._slope = this.getDouble("slope");
        this._minCostCut = this.getDouble("idle");
        String costCut = this.getProperty("p2p");
        if (costCut.endsWith("%")) {
            String numberPart = costCut.substring(0, costCut.length() - 1);
            this._costCut = Double.parseDouble(numberPart) / 100.0;
            this._costCutIsPercentile = true;
            if (this._costCut <= 0.0) {
                throw new IllegalArgumentException("Number " + this._costCut + " is too small; must be > 0%");
            }
            if (this._costCut >= 1.0) {
                throw new IllegalArgumentException("Number " + this._costCut + " is too large; must be < 100%");
            }
        } else {
            this._costCut = Double.parseDouble(costCut);
            this._costCutIsPercentile = false;
        }
    }

    @Override
    protected Partition create(Map<String, String> inherited, Map<String, String> properties) {
        return new ClassicPartition(inherited, properties);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public PoolInfo selectWritePool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        Preconditions.checkState((!pools.isEmpty() ? 1 : 0) != 0);
        Collections.shuffle(pools);
        PoolCost best = (PoolCost)this._byFullCost.min(Iterables.transform(pools, this.toPoolCost(attributes.getSize())));
        double cost = this.getWeightedFullCost(best);
        if (!(cost <= 1000000.0)) {
            throw new CacheException(21, "Best pool <" + best.pool.getName() + "> too high : " + cost);
        }
        return best.pool;
    }

    @Override
    public PoolInfo selectReadPool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        Preconditions.checkState((!pools.isEmpty() ? 1 : 0) != 0);
        Collections.shuffle(pools);
        PnfsId pnfsId = attributes.getPnfsId();
        double bestCost = Double.POSITIVE_INFINITY;
        PoolInfo bestPool = null;
        for (PoolInfo pool : pools) {
            CostCalculationV5 calculatable = new CostCalculationV5(pool.getCostInfo());
            calculatable.recalculate(0L);
            double cost = Math.abs(this._performanceCostFactor * calculatable.getPerformanceCost());
            if (bestCost >= this._minCostCut && cost <= bestCost) {
                bestCost = cost;
                bestPool = pool;
                continue;
            }
            if (!(cost < this._minCostCut) || !(bestCost < this._minCostCut) || this.minCostCutPosition(pnfsId, pool) >= this.minCostCutPosition(pnfsId, bestPool)) continue;
            bestCost = cost;
            bestPool = pool;
        }
        CostCalculationV5 calculatable = new CostCalculationV5(bestPool.getCostInfo());
        calculatable.recalculate(0L);
        double cost = calculatable.getPerformanceCost();
        boolean isPanicCostExceeded = this.isPanicCostExceeded(cost);
        boolean isFallbackCostExceeded = this.isFallbackCostExceeded(cost);
        boolean isCostCutExceeded = this.isCostCutExceeded(cm, cost);
        if (isPanicCostExceeded) {
            throw new CostException("Cost limit exceeded", null, isFallbackCostExceeded, isCostCutExceeded);
        }
        if (isFallbackCostExceeded || isCostCutExceeded) {
            throw new CostException("Cost limit exceeded", bestPool, isFallbackCostExceeded, isCostCutExceeded);
        }
        return bestPool;
    }

    @Override
    public Partition.P2pPair selectPool2Pool(CostModule cm, List<PoolInfo> src, List<PoolInfo> dst, FileAttributes attributes, boolean force) throws CacheException {
        List destinations;
        Preconditions.checkState((!src.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((!dst.isEmpty() ? 1 : 0) != 0);
        if ((long)src.size() >= this._maxPnfsFileCopies) {
            throw new PermissionDeniedCacheException("P2P denied: already too many copies (" + src.size() + ")");
        }
        Collections.shuffle(src);
        Collections.shuffle(dst);
        List sources = this._byPerformanceCost.sortedCopy(Iterables.transform(src, this.toPoolCost(0L)));
        if (!force && this.isAlertCostExceeded(((PoolCost)sources.get((int)0)).performanceCost)) {
            throw new SourceCostException("P2P denied: All source pools are too busy (performance cost > " + this._alertCostCut + ")");
        }
        double maxTargetCost = this._slope > 0.01 ? this._slope * ((PoolCost)sources.get((int)0)).performanceCost : this.getCurrentCostCut(cm);
        Iterable unsortedDestinations = Iterables.transform(dst, this.toPoolCost(attributes.getSize()));
        if (!force && maxTargetCost > 0.0) {
            unsortedDestinations = Iterables.filter((Iterable)unsortedDestinations, this.performanceCostIsBelow(maxTargetCost));
        }
        if ((destinations = this._byFullCost.sortedCopy(unsortedDestinations)).isEmpty()) {
            throw new DestinationCostException("P2P denied: All destination pools are too busy (performance cost > " + maxTargetCost + ")");
        }
        PoolCost sourcePool = null;
        PoolCost destinationPool = null;
        PoolCost bestEffortSourcePool = null;
        PoolCost bestEffortDestinationPool = null;
        block4: for (PoolCost source : sources) {
            for (PoolCost destination : destinations) {
                if (this._allowSameHostCopy == SameHost.NOTCHECKED) {
                    sourcePool = source;
                    destinationPool = destination;
                    break block4;
                }
                if (bestEffortSourcePool == null) {
                    bestEffortSourcePool = source;
                }
                if (bestEffortDestinationPool == null) {
                    bestEffortDestinationPool = destination;
                }
                if (source.host == null || source.host.equals(destination.host)) continue;
                sourcePool = source;
                destinationPool = destination;
                break block4;
            }
        }
        if (sourcePool == null || destinationPool == null) {
            switch (this._allowSameHostCopy) {
                case BESTEFFORT: {
                    sourcePool = bestEffortSourcePool;
                    destinationPool = bestEffortDestinationPool;
                    break;
                }
                case NEVER: {
                    throw new PermissionDeniedCacheException("P2P denied: sameHostCopy is 'never' and no matching pool found");
                }
                default: {
                    throw new RuntimeException("P2P denied: coding error, bad state");
                }
            }
        }
        return new Partition.P2pPair(sourcePool.pool, destinationPool.pool);
    }

    @Override
    public PoolInfo selectStagePool(CostModule cm, List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        Preconditions.checkState((!pools.isEmpty() ? 1 : 0) != 0);
        Collections.shuffle(pools);
        ArrayList order = Lists.newArrayListWithCapacity((int)3);
        if (previousPool != null) {
            order.add(this.thisPoolLast(previousPool));
        }
        if (previousHost != null && this._allowSameHostRetry != SameHost.NOTCHECKED) {
            order.add(this.thisHostLast(previousHost));
        }
        order.add(this._byFullCost);
        long size = attributes.getSize();
        PoolCost best = (PoolCost)Ordering.compound((Iterable)order).min(Iterables.transform(pools, this.toPoolCost(size)));
        if (this._allowSameHostRetry == SameHost.NEVER && previousHost != null && previousHost.equals(best.host)) {
            throw new CacheException(150, "No cheap candidates available for stage");
        }
        if (this.isFallbackCostExceeded(best.performanceCost)) {
            throw new CostException("Cost limit exceeded", null, true, false);
        }
        return best.pool;
    }

    protected int minCostCutPosition(PnfsId pnfsId, PoolInfo pool) {
        return (pnfsId.toString() + pool.getName()).hashCode();
    }

    protected double getCurrentCostCut(CostModule cm) {
        return this._costCutIsPercentile ? cm.getPoolsPercentilePerformanceCost(this._costCut) : this._costCut;
    }

    protected boolean isPanicCostExceeded(double cost) {
        return this._panicCostCut > 0.0 && cost > this._panicCostCut;
    }

    protected boolean isFallbackCostExceeded(double cost) {
        return this._fallbackCostCut > 0.0 && cost > this._fallbackCostCut;
    }

    protected boolean isCostCutExceeded(CostModule cm, double cost) {
        return this._costCut > 0.0 && cost >= this.getCurrentCostCut(cm);
    }

    protected boolean isAlertCostExceeded(double cost) {
        return this._alertCostCut > 0.0 && cost > this._alertCostCut;
    }

    protected double getWeightedFullCost(PoolCost cost) {
        return Math.abs(cost.spaceCost) * this._spaceCostFactor + Math.abs(cost.performanceCost) * this._performanceCostFactor;
    }

    protected double getWeightedPerformanceCost(PoolCost cost) {
        return Math.abs(cost.performanceCost) * this._performanceCostFactor;
    }

    protected Function<PoolInfo, PoolCost> toPoolCost(final long filesize) {
        return new Function<PoolInfo, PoolCost>(){

            public PoolCost apply(PoolInfo pool) {
                CostCalculationV5 calculatable = new CostCalculationV5(pool.getCostInfo());
                calculatable.recalculate(filesize);
                return new PoolCost(pool, calculatable);
            }
        };
    }

    protected Predicate<PoolCost> performanceCostIsBelow(final double max) {
        return new Predicate<PoolCost>(){

            public boolean apply(PoolCost cost) {
                return cost.performanceCost < max;
            }
        };
    }

    protected Ordering<PoolCost> thisPoolLast(final String name) {
        return new Ordering<PoolCost>(){

            public int compare(PoolCost a, PoolCost b) {
                if (!a.pool.getName().equals(b.pool.getName())) {
                    if (a.pool.getName().equals(name)) {
                        return 1;
                    }
                    if (b.pool.getName().equals(name)) {
                        return -1;
                    }
                }
                return 0;
            }
        };
    }

    protected Ordering<PoolCost> thisHostLast(final String host) {
        return new Ordering<PoolCost>(){

            public int compare(PoolCost a, PoolCost b) {
                if (!Objects.equal((Object)a.host, (Object)b.host)) {
                    if (Objects.equal((Object)a.host, (Object)host)) {
                        return 1;
                    }
                    if (Objects.equal((Object)b.host, (Object)host)) {
                        return -1;
                    }
                }
                return 0;
            }
        };
    }

    private void initTransientFields() {
        this._byPerformanceCost = new Ordering<PoolCost>(){

            public int compare(PoolCost cost1, PoolCost cost2) {
                return Double.compare(ClassicPartition.this.getWeightedPerformanceCost(cost1), ClassicPartition.this.getWeightedPerformanceCost(cost2));
            }
        };
        this._byFullCost = new Ordering<PoolCost>(){

            public int compare(PoolCost cost1, PoolCost cost2) {
                return Double.compare(ClassicPartition.this.getWeightedFullCost(cost1), ClassicPartition.this.getWeightedFullCost(cost2));
            }
        };
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initTransientFields();
    }

    protected static class PoolCost {
        final PoolInfo pool;
        final double performanceCost;
        final double spaceCost;
        final String host;

        public PoolCost(PoolInfo pool, CostCalculatable cost) {
            this(pool, cost.getPerformanceCost(), cost.getSpaceCost());
        }

        public PoolCost(PoolInfo pool, double performanceCost, double spaceCost) {
            this.pool = pool;
            this.performanceCost = performanceCost;
            this.spaceCost = spaceCost;
            this.host = pool.getHostName();
        }
    }

    public static enum SameHost {
        NEVER,
        BESTEFFORT,
        NOTCHECKED;

    }
}

