/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v5.CacheEntryImpl;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteHandleImpl
implements ReplicaDescriptor {
    private static Logger _log = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private static long HOLD_TIME = 300000L;
    private final CacheRepositoryV5 _repository;
    private final Allocator _allocator;
    private final MetaDataRecord _entry;
    private final PnfsHandler _pnfs;
    private final List<StickyRecord> _stickyRecords;
    private final EntryState _initialState;
    private EntryState _targetState;
    private HandleState _state;
    private long _allocated;
    private Thread _allocationThread;

    WriteHandleImpl(CacheRepositoryV5 repository, Allocator allocator, PnfsHandler pnfs, MetaDataRecord entry, EntryState targetState, List<StickyRecord> stickyRecords) {
        this._repository = repository;
        this._allocator = allocator;
        this._pnfs = pnfs;
        this._entry = entry;
        this._initialState = entry.getState();
        this._targetState = targetState;
        this._stickyRecords = stickyRecords;
        this._state = HandleState.OPEN;
        this._allocated = 0L;
    }

    private synchronized void setState(HandleState state) {
        this._state = state;
        if (state != HandleState.OPEN && this._allocationThread != null) {
            this._allocationThread.interrupt();
        }
    }

    private synchronized boolean isOpen() {
        return this._state == HandleState.OPEN;
    }

    private synchronized void setAllocationThread() throws InterruptedException, IllegalStateException {
        while (this._allocationThread != null) {
            this.wait();
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Handle is closed");
        }
        this._allocationThread = Thread.currentThread();
    }

    private synchronized void clearAllocationThread() {
        this._allocationThread = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate(long size) throws IllegalStateException, IllegalArgumentException, InterruptedException {
        if (size < 0L) {
            throw new IllegalArgumentException("Size is negative");
        }
        this.setAllocationThread();
        try {
            this._allocator.allocate(size);
        }
        catch (InterruptedException e) {
            if (!this.isOpen()) {
                throw new IllegalStateException("Handle is closed");
            }
            throw e;
        }
        finally {
            this.clearAllocationThread();
        }
        WriteHandleImpl writeHandleImpl = this;
        synchronized (writeHandleImpl) {
            this._allocated += size;
            this._entry.setSize(this._allocated);
        }
    }

    @Override
    public void free(long size) throws IllegalStateException {
        throw new IllegalStateException("Space cannot be freed through a write handle");
    }

    private synchronized void adjustReservation(long length) throws InterruptedException {
        try {
            if (this._allocated < length) {
                _log.error("Under allocation detected. This is a bug. Please report it.");
                this._allocator.allocate(length - this._allocated);
            } else if (this._allocated > length) {
                this._allocator.free(this._allocated - length);
            }
            this._allocated = length;
            this._entry.setSize(length);
        }
        catch (InterruptedException e) {
            _log.warn("Failed to adjust space reservation because the operation was interrupted. The pool is now over allocated.");
            throw e;
        }
    }

    private void setChecksum(StorageInfo info, Checksum checksum) throws CacheException {
        String flags = info.getKey("flag-c");
        if (flags == null) {
            info.setKey("flag-c", checksum.toString());
            this._entry.setStorageInfo(info);
        } else if (!checksum.equals((Object)Checksum.parseChecksum((String)flags))) {
            throw new CacheException(String.format("Checksum error: file=%s, expected=%s", checksum, flags));
        }
    }

    private void setFileSize(StorageInfo info, long length) throws CacheException {
        if (this._initialState == EntryState.FROM_CLIENT && info.getFileSize() == 0L) {
            info.setFileSize(length);
            this._entry.setStorageInfo(info);
        } else if (info.getFileSize() != length) {
            throw new CacheException("File does not have expected length");
        }
    }

    private void registerCacheLocation() throws CacheException {
        this._pnfs.addCacheLocation(this._entry.getPnfsId());
    }

    private void setFileAttributes(FileAttributes attr) throws CacheException {
        this._pnfs.setFileAttributes(this._entry.getPnfsId(), attr);
    }

    private void setToTargetState() throws CacheException {
        if (this._targetState == EntryState.CACHED && this._stickyRecords.isEmpty()) {
            long now = System.currentTimeMillis();
            this._repository.setSticky(this._entry, "self", now + HOLD_TIME, false);
        }
        for (StickyRecord record : this._stickyRecords) {
            this._repository.setSticky(this._entry, record.owner(), record.expire(), false);
        }
        this._repository.setState(this._entry, this._targetState);
    }

    @Override
    public synchronized void commit(Checksum checksum) throws IllegalStateException, InterruptedException, CacheException {
        if (this._state != HandleState.OPEN) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            this._entry.touch();
            long length = this.getFile().length();
            this.adjustReservation(length);
            StorageInfo info = this._entry.getStorageInfo();
            this.setFileSize(info, length);
            if (checksum != null) {
                this.setChecksum(info, checksum);
            }
            FileAttributes fileAttributes = new FileAttributes();
            if (this._initialState == EntryState.FROM_CLIENT) {
                fileAttributes.setAccessLatency(info.getAccessLatency());
                fileAttributes.setRetentionPolicy(info.getRetentionPolicy());
                fileAttributes.setSize(length);
            }
            fileAttributes.setLocations(Collections.singleton(this._repository.getPoolName()));
            this.setFileAttributes(fileAttributes);
            this.setToTargetState();
            this.setState(HandleState.COMMITTED);
        }
        catch (CacheException e) {
            if (e.getRc() == 10001) {
                this._targetState = EntryState.REMOVED;
            }
            throw e;
        }
    }

    private synchronized void fail() {
        block8: {
            long length = this.getFile().length();
            try {
                this.adjustReservation(length);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this._initialState == EntryState.FROM_POOL || this._initialState == EntryState.FROM_STORE) {
                this._targetState = EntryState.REMOVED;
            }
            if (this._targetState != EntryState.REMOVED) {
                try {
                    this.registerCacheLocation();
                }
                catch (CacheException e) {
                    if (e.getRc() != 10001) break block8;
                    this._targetState = EntryState.REMOVED;
                }
            }
        }
        if (this._targetState == EntryState.REMOVED) {
            this._repository.setState(this._entry, EntryState.REMOVED);
        } else {
            _log.warn("Marking pool entry as BROKEN");
            this._repository.setState(this._entry, EntryState.BROKEN);
        }
    }

    @Override
    public synchronized void close() throws IllegalStateException {
        switch (this._state) {
            case CLOSED: {
                throw new IllegalStateException("Handle is closed");
            }
            case OPEN: {
                this.fail();
                this.setState(HandleState.CLOSED);
                break;
            }
            case COMMITTED: {
                this.setState(HandleState.CLOSED);
            }
        }
        this._repository.destroyWhenRemovedAndUnused(this._entry);
    }

    @Override
    public synchronized File getFile() throws IllegalStateException {
        if (this._state == HandleState.CLOSED) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            return this._entry.getDataFile();
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    @Override
    public synchronized CacheEntry getEntry() throws IllegalStateException {
        if (this._state == HandleState.CLOSED) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            return new CacheEntryImpl(this._entry);
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    static enum HandleState {
        OPEN,
        COMMITTED,
        CLOSED;

    }
}

