/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dcache.pool.repository.EntryChangeEvent;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StateChangeListener;
import org.dcache.pool.repository.StickyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateChangeListeners {
    private static final Logger _log = LoggerFactory.getLogger(StateChangeListeners.class);
    private final List<StateChangeListener> _listeners = new CopyOnWriteArrayList<StateChangeListener>();
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private Executor _executor = this._executorService;

    public void setSynchronousNotification(boolean value) {
        this._executor = value ? new DirectExecutor() : this._executorService;
    }

    public void add(StateChangeListener listener) {
        this._listeners.add(listener);
    }

    public void remove(StateChangeListener listener) {
        this._listeners.remove(listener);
    }

    public void stateChanged(final StateChangeEvent event) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                    try {
                        listener.stateChanged(event);
                    }
                    catch (RuntimeException e) {
                        _log.error("Unexpected failure during state change notification", (Throwable)e);
                    }
                }
            }
        });
    }

    public void accessTimeChanged(final EntryChangeEvent event) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                    try {
                        listener.accessTimeChanged(event);
                    }
                    catch (RuntimeException e) {
                        _log.error("Unexpected failure during state change notification", (Throwable)e);
                    }
                }
            }
        });
    }

    public void stickyChanged(final StickyChangeEvent event) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                    try {
                        listener.stickyChanged(event);
                    }
                    catch (RuntimeException e) {
                        _log.error("Unexpected failure during state change notification", (Throwable)e);
                    }
                }
            }
        });
    }

    public void stop() throws InterruptedException {
        this._executorService.shutdown();
    }

    private static class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }
}

