/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import diskCacheV111.util.CacheException;
import java.io.File;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.v5.CacheEntryImpl;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.dcache.util.Checksum;

class ReadHandleImpl
implements ReplicaDescriptor {
    private final CacheRepositoryV5 _repository;
    private final MetaDataRecord _entry;
    private boolean _open;

    ReadHandleImpl(CacheRepositoryV5 repository, MetaDataRecord entry) {
        try {
            this._repository = repository;
            this._entry = entry;
            this._open = true;
            this._entry.incrementLinkCount();
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    @Override
    public synchronized void close() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            this._entry.decrementLinkCount();
            this._open = false;
            this._repository.destroyWhenRemovedAndUnused(this._entry);
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    @Override
    public synchronized File getFile() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            return this._entry.getDataFile();
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    @Override
    public synchronized CacheEntry getEntry() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            return new CacheEntryImpl(this._entry);
        }
        catch (CacheException e) {
            throw new RuntimeException("Internal repository error: " + e.getMessage());
        }
    }

    @Override
    public void commit(Checksum checksum) throws IllegalStateException, InterruptedException, CacheException {
    }

    @Override
    public void allocate(long size) throws IllegalStateException, IllegalArgumentException, InterruptedException {
        throw new IllegalStateException("Read-Only Handle");
    }

    @Override
    public void free(long size) throws IllegalStateException, IllegalArgumentException {
        throw new IllegalStateException("Read-Only Handle");
    }
}

