/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import org.dcache.pool.FaultAction;
import org.dcache.pool.repository.Account;
import org.dcache.pool.repository.MetaDataStore;
import org.dcache.pool.repository.SpaceRecord;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckHealthTask
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(CheckHealthTask.class);
    private final CacheRepositoryV5 _repository;
    private Account _account;
    private MetaDataStore _metaDataStore;

    CheckHealthTask(CacheRepositoryV5 repository) {
        this._repository = repository;
    }

    public void setAccount(Account account) {
        this._account = account;
    }

    public void setMetaDataStore(MetaDataStore store) {
        this._metaDataStore = store;
    }

    @Override
    public void run() {
        if (!this._metaDataStore.isOk()) {
            this._repository.fail(FaultAction.DISABLED, "I/O test failed");
        }
        if (!this.checkSpaceAccounting()) {
            _log.error("Marking pool read-only due to accounting errors. This is a bug. Please report it to support@dcache.org.");
            this._repository.fail(FaultAction.READONLY, "Accounting errors detected");
        }
        this.adjustFreeSpace();
    }

    private boolean checkSpaceAccounting() {
        SpaceRecord record = this._account.getSpaceRecord();
        long removable = record.getRemovableSpace();
        long total = record.getTotalSpace();
        long free = record.getFreeSpace();
        long precious = record.getPreciousSpace();
        long used = total - free;
        if (removable < 0L) {
            _log.error("Removable space is negative.");
            return false;
        }
        if (total < 0L) {
            _log.error("Repository size is negative.");
            return false;
        }
        if (free < 0L) {
            _log.error("Free space is negative.");
            return false;
        }
        if (precious < 0L) {
            _log.error("Precious space is negative.");
            return false;
        }
        if (used < 0L) {
            _log.error("Used space is negative.");
            return false;
        }
        if (precious + removable > used) {
            _log.warn("Used space is less than the sum of precious and removable space (this may be a temporary problem - if it persists then please report it to support@dcache.org).");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustFreeSpace() {
        Account account;
        Account account2 = account = this._account;
        synchronized (account2) {
            long free = this._metaDataStore.getFreeSpace();
            long total = this._metaDataStore.getTotalSpace();
            if (total == 0L) {
                _log.debug("Java reported file system size as 0. Skipping file system size check.");
                return;
            }
            if (total < account.getTotal()) {
                _log.warn(String.format("The file system containing the data files appears to be smaller (%,d bytes) than the configured pool size (%,d bytes).", total, this._account.getTotal()));
            }
            if (free < account.getFree()) {
                long newSize = account.getTotal() - (account.getFree() - free);
                _log.warn(String.format("The file system containing the data files appears to have less free space (%,d bytes) than expected (%,d bytes); reducing the pool size to %,d bytes to compensate. Notice that this does not leave any space for the meta data. If such data is stored on the same file system, then it is paramount that the pool size is reconfigured to leave enough space for the meta data.", free, this._account.getFree(), newSize));
                account.setTotal(newSize);
            }
        }
    }
}

