/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.file;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.PnfsId;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.dcache.pool.repository.DuplicateEntryException;
import org.dcache.pool.repository.FileStore;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;
import org.dcache.pool.repository.meta.file.CacheRepositoryEntryImpl;
import org.dcache.pool.repository.v3.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetaDataRepository
implements MetaDataStore {
    private static Logger _log = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private static final String DIRECTORY_NAME = "control";
    private FileStore _fileStore;
    private File _metadir;

    public FileMetaDataRepository(FileStore fileStore, File baseDir) throws FileNotFoundException {
        this(fileStore, baseDir, false);
    }

    public FileMetaDataRepository(FileStore fileStore, File baseDir, boolean readOnly) throws FileNotFoundException {
        this._fileStore = fileStore;
        this._metadir = new File(baseDir, DIRECTORY_NAME);
        if (!this._metadir.exists()) {
            if (readOnly) {
                throw new FileNotFoundException("No such directory and not allowed to create it: " + this._metadir);
            }
            if (!this._metadir.mkdir()) {
                throw new FileNotFoundException("Failed to create directory: " + this._metadir);
            }
        } else if (!this._metadir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + this._metadir);
        }
    }

    @Override
    public Collection<PnfsId> list() {
        String[] files = this._metadir.list();
        HashSet<PnfsId> ids = new HashSet<PnfsId>(files.length);
        for (String name : files) {
            try {
                if (name.startsWith("SI-")) {
                    name = name.substring(3);
                }
                ids.add(new PnfsId(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return ids;
    }

    @Override
    public MetaDataRecord create(PnfsId id) throws DuplicateEntryException, CacheException {
        try {
            File controlFile = new File(this._metadir, id.toString());
            File siFile = new File(this._metadir, "SI-" + id.toString());
            File dataFile = this._fileStore.get(id);
            if (this.get(id) != null) {
                throw new DuplicateEntryException(id);
            }
            if (controlFile.exists()) {
                controlFile.delete();
            }
            return new CacheRepositoryEntryImpl(id, controlFile, dataFile, siFile);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to create new entry: " + e.getMessage());
        }
    }

    @Override
    public MetaDataRecord create(MetaDataRecord entry) throws DuplicateEntryException, CacheException {
        try {
            PnfsId id = entry.getPnfsId();
            File controlFile = new File(this._metadir, id.toString());
            File siFile = new File(this._metadir, "SI-" + id.toString());
            File dataFile = this._fileStore.get(id);
            if (this.get(id) != null) {
                throw new DuplicateEntryException(id);
            }
            if (controlFile.exists()) {
                controlFile.delete();
            }
            return new CacheRepositoryEntryImpl(id, controlFile, dataFile, siFile, entry);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to create new entry: " + e.getMessage());
        }
    }

    @Override
    public MetaDataRecord get(PnfsId id) throws CacheException {
        try {
            File siFile = new File(this._metadir, "SI-" + id.toString());
            if (siFile.exists()) {
                File controlFile = new File(this._metadir, id.toString());
                File dataFile = this._fileStore.get(id);
                return new CacheRepositoryEntryImpl(id, controlFile, dataFile, siFile);
            }
        }
        catch (IOException e) {
            throw new DiskErrorCacheException("Failed to read meta data for " + id);
        }
        return null;
    }

    @Override
    public void remove(PnfsId id) {
        File controlFile = new File(this._metadir, id.toString());
        File siFile = new File(this._metadir, "SI-" + id.toString());
        controlFile.delete();
        siFile.delete();
    }

    @Override
    public synchronized boolean isOk() {
        File tmp = new File(this._metadir, ".repository_is_ok");
        try {
            tmp.delete();
            tmp.deleteOnExit();
            if (!tmp.createNewFile() || !tmp.exists()) {
                _log.error("Could not create " + tmp);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            _log.error("Failed to touch " + tmp + ": " + e.getMessage());
            return false;
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this._metadir.toString();
    }

    @Override
    public long getFreeSpace() {
        return this._fileStore.getFreeSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._fileStore.getTotalSpace();
    }
}

