/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.file;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.List;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v3.RepositoryException;
import org.dcache.pool.repository.v3.entry.CacheRepositoryEntryState;

public class CacheRepositoryEntryImpl
implements MetaDataRecord {
    private final CacheRepositoryEntryState _state;
    private final PnfsId _pnfsId;
    private int _linkCount = 0;
    private StorageInfo _storageInfo = null;
    private long _creationTime = System.currentTimeMillis();
    private long _lastAccess;
    private long _size;
    private final File _controlFile;
    private final File _siFile;
    private final File _dataFile;

    public CacheRepositoryEntryImpl(PnfsId pnfsId, File controlFile, File dataFile, File siFile) throws IOException, RepositoryException {
        this._pnfsId = pnfsId;
        this._controlFile = controlFile;
        this._siFile = siFile;
        this._dataFile = dataFile;
        this._state = new CacheRepositoryEntryState(this._controlFile);
        try {
            this._storageInfo = CacheRepositoryEntryImpl.readStorageInfo(siFile);
            this._creationTime = this._siFile.lastModified();
        }
        catch (FileNotFoundException fnf) {
            // empty catch block
        }
        this._lastAccess = this._dataFile.lastModified();
        this._size = this._dataFile.length();
        if (this._lastAccess == 0L) {
            this._lastAccess = this._creationTime;
        }
    }

    public CacheRepositoryEntryImpl(PnfsId pnfsId, File controlFile, File dataFile, File siFile, MetaDataRecord entry) throws IOException, RepositoryException, CacheException {
        this._pnfsId = pnfsId;
        this._controlFile = controlFile;
        this._siFile = siFile;
        this._dataFile = dataFile;
        this._lastAccess = entry.getLastAccessTime();
        this._linkCount = entry.getLinkCount();
        this._creationTime = entry.getCreationTime();
        this._size = entry.getSize();
        this._state = new CacheRepositoryEntryState(this._controlFile, entry);
        this.setStorageInfo(entry.getStorageInfo());
    }

    @Override
    public synchronized void incrementLinkCount() throws CacheException {
        ++this._linkCount;
    }

    @Override
    public synchronized void decrementLinkCount() throws CacheException {
        if (this._linkCount <= 0) {
            throw new IllegalStateException("Link count is already  zero");
        }
        --this._linkCount;
    }

    @Override
    public synchronized int getLinkCount() {
        return this._linkCount;
    }

    @Override
    public synchronized long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public synchronized File getDataFile() throws CacheException {
        return this._dataFile;
    }

    @Override
    public synchronized long getLastAccessTime() {
        return this._lastAccess;
    }

    @Override
    public synchronized PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public synchronized void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative entry size is not allowed");
        }
        this._size = size;
    }

    @Override
    public synchronized long getSize() {
        return this._size;
    }

    @Override
    public synchronized StorageInfo getStorageInfo() throws CacheException {
        return this._storageInfo;
    }

    @Override
    public synchronized boolean isSticky() {
        return this._state.isSticky();
    }

    @Override
    public synchronized EntryState getState() {
        return this._state.getState();
    }

    @Override
    public synchronized void setState(EntryState state) throws CacheException {
        try {
            this._state.setState(state);
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }

    @Override
    public synchronized List<StickyRecord> removeExpiredStickyFlags() {
        return this._state.removeExpiredStickyFlags();
    }

    @Override
    public synchronized boolean setSticky(String owner, long expire, boolean overwrite) throws CacheException {
        try {
            return this._state.setSticky(owner, expire, overwrite);
        }
        catch (IllegalStateException e) {
            throw new CacheException(e.getMessage());
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }

    @Override
    public synchronized void setStorageInfo(StorageInfo storageInfo) throws CacheException {
        ObjectOutputStream objectOut = null;
        File siFileTemp = null;
        try {
            siFileTemp = File.createTempFile(this._siFile.getName(), null, this._siFile.getParentFile());
            objectOut = new ObjectOutputStream(new FileOutputStream(siFileTemp));
            objectOut.writeObject(storageInfo);
        }
        catch (IOException ioe) {
            if (siFileTemp != null && siFileTemp.exists()) {
                siFileTemp.delete();
            }
            throw new CacheException(10, this._pnfsId + " " + ioe.getMessage());
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (IOException ignore) {}
            }
        }
        if (!siFileTemp.renameTo(this._siFile)) {
            throw new CacheException(10, this._pnfsId + " rename failed");
        }
        this._storageInfo = storageInfo;
    }

    @Override
    public synchronized void touch() throws CacheException {
        try {
            if (!this._dataFile.exists()) {
                this._dataFile.createNewFile();
            }
        }
        catch (IOException ee) {
            throw new CacheException("Io Error creating : " + this._dataFile);
        }
        this._lastAccess = System.currentTimeMillis();
        this._dataFile.setLastModified(this._lastAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StorageInfo readStorageInfo(File objIn) throws IOException {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(objIn)));
            try {
                StorageInfo storageInfo = (StorageInfo)in.readObject();
                return storageInfo;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ClassNotFoundException cnf) {
            return null;
        }
        catch (InvalidClassException ife) {
            return null;
        }
        catch (StreamCorruptedException sce) {
            return null;
        }
        catch (OptionalDataException ode) {
            return null;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized List<StickyRecord> stickyRecords() {
        return this._state.stickyRecords();
    }

    public synchronized String toString() {
        return this._pnfsId.toString() + " <" + this._state.toString() + "-" + "(0)" + "[" + this._linkCount + "]> " + this.getSize() + " si={" + (this._storageInfo == null ? "<unknown>" : this._storageInfo.getStorageClass()) + "}";
    }
}

