/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.db;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.StoredMap;
import diskCacheV111.vehicles.StorageInfo;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.meta.db.CacheRepositoryEntryState;
import org.dcache.pool.repository.meta.db.MetaDataRepositoryDatabase;

class MetaDataRepositoryViews {
    private StoredMap storageInfoMap;
    private StoredMap stateMap;

    public MetaDataRepositoryViews(MetaDataRepositoryDatabase db) {
        StoredClassCatalog catalog = db.getClassCatalog();
        SerialBinding stringBinding = new SerialBinding((ClassCatalog)catalog, String.class);
        SerialBinding storageInfoBinding = new SerialBinding((ClassCatalog)catalog, StorageInfo.class);
        SerialBinding stateBinding = new SerialBinding((ClassCatalog)catalog, CacheRepositoryEntryState.class);
        this.storageInfoMap = new StoredMap(db.getStorageInfoDatabase(), (EntryBinding)stringBinding, (EntryBinding)storageInfoBinding, true);
        this.stateMap = new StoredMap(db.getStateDatabase(), (EntryBinding)stringBinding, (EntryBinding)stateBinding, true);
    }

    public final StoredMap getStorageInfoMap() {
        return this.storageInfoMap;
    }

    public final StoredMap getStateMap() {
        return this.stateMap;
    }

    public void toYaml(PrintWriter out, PrintWriter error) {
        for (Object id : this.getStateMap().keySet()) {
            try {
                CacheRepositoryEntryState state = (CacheRepositoryEntryState)this.getStateMap().get(id);
                StorageInfo info = (StorageInfo)this.getStorageInfoMap().get(id);
                out.format("%s:\n", id);
                out.format("  state: %s\n", state.toString());
                out.format("  sticky:\n", new Object[0]);
                for (StickyRecord stickyRecord : state.stickyRecords()) {
                    out.format("    %s: %d\n", stickyRecord.owner(), stickyRecord.expire());
                }
                if (info == null) continue;
                out.format("  storageclass: %s\n", info.getStorageClass());
                out.format("  cacheclass: %s\n", info.getCacheClass());
                out.format("  bitfileid: %s\n", info.getBitfileId());
                out.format("  locations:\n", new Object[0]);
                for (URI uRI : info.locations()) {
                    out.format("    - %s\n", uRI);
                }
                out.format("  hsm: %s\n", info.getHsm());
                out.format("  filesize: %s\n", info.getFileSize());
                out.format("  map:\n", new Object[0]);
                for (Map.Entry entry : info.getMap().entrySet()) {
                    out.format("    %s: %s\n", entry.getKey(), entry.getValue());
                }
                out.format("  retentionpolicy: %s\n", info.getRetentionPolicy());
                out.format("  accesslatency: %s\n", info.getAccessLatency());
            }
            catch (Throwable e) {
                error.println("Failed to read " + id + ": " + e.getMessage());
            }
        }
        out.flush();
        error.flush();
    }
}

