/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.db;

import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.DatabaseException;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.dcache.pool.repository.DuplicateEntryException;
import org.dcache.pool.repository.FileStore;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;
import org.dcache.pool.repository.meta.db.CacheRepositoryEntryImpl;
import org.dcache.pool.repository.meta.db.MetaDataRepositoryDatabase;
import org.dcache.pool.repository.meta.db.MetaDataRepositoryViews;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyDBMetaDataRepository
implements MetaDataStore {
    private static Logger _log = LoggerFactory.getLogger(BerkeleyDBMetaDataRepository.class);
    private static final String DIRECTORY_NAME = "meta";
    private final FileStore _fileStore;
    private final MetaDataRepositoryDatabase _database;
    private final MetaDataRepositoryViews _views;
    private final File _dir;

    public BerkeleyDBMetaDataRepository(FileStore fileStore, File directory) throws FileNotFoundException, DatabaseException {
        this(fileStore, directory, false);
    }

    public BerkeleyDBMetaDataRepository(FileStore fileStore, File directory, boolean readOnly) throws FileNotFoundException, DatabaseException {
        this._fileStore = fileStore;
        this._dir = new File(directory, DIRECTORY_NAME);
        if (!this._dir.exists()) {
            if (!this._dir.mkdir()) {
                throw new FileNotFoundException("Failed to create directory: " + this._dir);
            }
        } else if (!this._dir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + this._dir);
        }
        this._database = new MetaDataRepositoryDatabase(this._dir, readOnly);
        this._views = new MetaDataRepositoryViews(this._database);
    }

    @Override
    public Collection<PnfsId> list() {
        HashSet<PnfsId> ids = new HashSet<PnfsId>();
        for (Object id : this._views.getStorageInfoMap().keySet()) {
            ids.add(new PnfsId((String)id));
        }
        for (Object id : this._views.getStateMap().keySet()) {
            ids.add(new PnfsId((String)id));
        }
        return ids;
    }

    @Override
    public MetaDataRecord get(PnfsId id) {
        return CacheRepositoryEntryImpl.load(this, id);
    }

    @Override
    public MetaDataRecord create(PnfsId id) throws DuplicateEntryException {
        if (this.get(id) != null) {
            throw new DuplicateEntryException(id);
        }
        return new CacheRepositoryEntryImpl(this, id);
    }

    @Override
    public MetaDataRecord create(MetaDataRecord entry) throws DuplicateEntryException, CacheException {
        PnfsId id = entry.getPnfsId();
        if (this.get(id) != null) {
            throw new DuplicateEntryException(id);
        }
        return new CacheRepositoryEntryImpl(this, entry);
    }

    @Override
    public void remove(PnfsId id) {
        this._views.getStorageInfoMap().remove((Object)id.toString());
        this._views.getStateMap().remove((Object)id.toString());
    }

    @Override
    public synchronized boolean isOk() {
        File tmp = new File(this._dir, ".repository_is_ok");
        try {
            tmp.delete();
            tmp.deleteOnExit();
            if (!tmp.createNewFile() || !tmp.exists()) {
                _log.error("Could not create " + tmp);
                return false;
            }
            return !this._database.isFailed();
        }
        catch (IOException e) {
            _log.error("Failed to touch " + tmp + ": " + e.getMessage());
            return false;
        }
    }

    File getDataFile(PnfsId id) {
        return this._fileStore.get(id);
    }

    StoredMap getStorageInfoMap() {
        return this._views.getStorageInfoMap();
    }

    StoredMap getStateMap() {
        return this._views.getStateMap();
    }

    @Override
    public void close() {
        try {
            this._database.close();
        }
        catch (DatabaseException e) {
            _log.error("Ignored: Could not close database: " + e.getMessage());
        }
    }

    public String toString() {
        return this._dir.toString();
    }

    @Override
    public long getFreeSpace() {
        return this._fileStore.getFreeSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._fileStore.getTotalSpace();
    }
}

