/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import java.io.Serializable;
import java.text.DateFormat;

public class StickyRecord
implements Serializable {
    static final long serialVersionUID = 8235126040387514086L;
    private static final DateFormat df = DateFormat.getInstance();
    public static final long NON_EXPIRING = -1L;
    private final String _owner;
    private final long _expire;

    public StickyRecord(String owner, long expire) {
        this._owner = owner;
        this._expire = expire;
    }

    public boolean isValid() {
        return this.isValidAt(System.currentTimeMillis());
    }

    public boolean isValidAt(long time) {
        return this.isNonExpiring() || this._expire > time;
    }

    private boolean isNonExpiring() {
        return this._expire == -1L;
    }

    public long expire() {
        return this._expire;
    }

    public String owner() {
        return this._owner;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StickyRecord)) {
            return false;
        }
        StickyRecord other = (StickyRecord)obj;
        return other.owner().equals(this._owner) && other.expire() == this._expire;
    }

    public int hashCode() {
        return this._owner.hashCode();
    }

    public synchronized String toString() {
        String expiryLabel = this.isNonExpiring() ? "never expires" : "expires " + df.format(this._expire);
        return this._owner + " : " + expiryLabel;
    }
}

