/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import org.dcache.pool.repository.FileStore;
import org.dcache.pool.repository.FlatFileStore;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;
import org.dcache.pool.repository.StickyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataStoreYamlTool {
    private static final Logger _log = LoggerFactory.getLogger(MetaDataStoreYamlTool.class);

    static MetaDataStore createStore(Class<?> clazz, FileStore fileStore, File poolDir) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(FileStore.class, File.class, Boolean.TYPE);
        return (MetaDataStore)constructor.newInstance(fileStore, poolDir, true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Synopsis: MetaDataStoreCopyTool DIR TYPE");
            System.err.println();
            System.err.println("Where DIR is the pool directory and TYPE is the meta");
            System.err.println("data store class.");
            System.exit(1);
        }
        File poolDir = new File(args[0]);
        FlatFileStore fileStore = new FlatFileStore(poolDir);
        MetaDataStore metaStore = MetaDataStoreYamlTool.createStore(Class.forName(args[1]), fileStore, poolDir);
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter error = new PrintWriter(System.err);
        for (PnfsId id : metaStore.list()) {
            try {
                MetaDataRecord record = metaStore.get(id);
                StorageInfo info = record.getStorageInfo();
                out.format("%s:\n", id);
                out.format("  state: %s\n", new Object[]{record.getState()});
                out.format("  sticky:\n", new Object[0]);
                for (StickyRecord stickyRecord : record.stickyRecords()) {
                    out.format("    %s: %d\n", stickyRecord.owner(), stickyRecord.expire());
                }
                if (info == null) continue;
                out.format("  storageclass: %s\n", info.getStorageClass());
                out.format("  cacheclass: %s\n", info.getCacheClass());
                out.format("  bitfileid: %s\n", info.getBitfileId());
                out.format("  locations:\n", new Object[0]);
                for (URI uRI : info.locations()) {
                    out.format("    - %s\n", uRI);
                }
                out.format("  hsm: %s\n", info.getHsm());
                out.format("  filesize: %s\n", info.getFileSize());
                out.format("  map:\n", new Object[0]);
                for (Map.Entry entry : info.getMap().entrySet()) {
                    out.format("    %s: %s\n", entry.getKey(), entry.getValue());
                }
                out.format("  retentionpolicy: %s\n", info.getRetentionPolicy());
                out.format("  accesslatency: %s\n", info.getAccessLatency());
            }
            catch (Exception e) {
                error.println("Failed to read " + id + ": " + e.getMessage());
            }
        }
        out.flush();
        error.flush();
    }
}

