/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dcache.pool.repository.DuplicateEntryException;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;

public class MetaDataCache
implements MetaDataStore {
    private final Map<PnfsId, MetaDataRecord> _entries = new ConcurrentHashMap<PnfsId, MetaDataRecord>();
    private final Set<PnfsId> _unread;
    private final Set<PnfsId> _reading = new HashSet<PnfsId>();
    private final MetaDataStore _inner;

    public MetaDataCache(MetaDataStore inner) {
        this._inner = inner;
        this._unread = new HashSet<PnfsId>(inner.list());
    }

    @Override
    public synchronized Collection<PnfsId> list() {
        if (this._unread.size() == 0) {
            return Collections.unmodifiableCollection(this._entries.keySet());
        }
        HashSet<PnfsId> ids = new HashSet<PnfsId>(this._unread);
        ids.addAll(this._entries.keySet());
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaDataRecord get(PnfsId id) throws CacheException, InterruptedException {
        MetaDataCache metaDataCache = this;
        synchronized (metaDataCache) {
            while (this._reading.contains(id)) {
                this.wait();
            }
            if (!this._unread.contains(id)) {
                return this._entries.get(id);
            }
            this._reading.add(id);
        }
        try {
            MetaDataRecord entry = this._inner.get(id);
            Object object = this;
            synchronized (object) {
                if (entry != null) {
                    this._entries.put(id, entry);
                }
                this._unread.remove(id);
            }
            object = entry;
            return object;
        }
        finally {
            MetaDataCache metaDataCache2 = this;
            synchronized (metaDataCache2) {
                this._reading.remove(id);
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized MetaDataRecord create(PnfsId id) throws DuplicateEntryException, CacheException {
        if (this._entries.containsKey(id) || this._unread.contains(id)) {
            throw new DuplicateEntryException(id);
        }
        MetaDataRecord entry = this._inner.create(id);
        this._entries.put(id, entry);
        return entry;
    }

    @Override
    public synchronized MetaDataRecord create(MetaDataRecord entry) throws DuplicateEntryException, CacheException {
        PnfsId id = entry.getPnfsId();
        if (this._entries.containsKey(id) || this._unread.contains(id)) {
            throw new DuplicateEntryException(id);
        }
        entry = this._inner.create(entry);
        this._entries.put(id, entry);
        return entry;
    }

    @Override
    public synchronized void remove(PnfsId id) {
        boolean interrupted = false;
        while (this._reading.contains(id)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this._unread.remove(id);
        this._inner.remove(id);
        this._entries.remove(id);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isOk() {
        return this._inner.isOk();
    }

    @Override
    public synchronized void close() {
        boolean interrupted = false;
        while (!this._reading.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this._unread.clear();
        this._inner.close();
        this._entries.clear();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public long getFreeSpace() {
        return this._inner.getFreeSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._inner.getTotalSpace();
    }
}

