/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.p2p;

import com.google.common.base.Preconditions;
import diskCacheV111.util.Adler32;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.pool.classic.ChecksumModuleV1;
import org.dcache.pool.p2p.CompanionContext;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.FireAndForgetTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Companion {
    private static final Logger _log = LoggerFactory.getLogger(Companion.class);
    private static final long PING_PERIOD = TimeUnit.MINUTES.toMillis(5L);
    private static final int BUFFER_SIZE = 65536;
    private static final String PROTOCOL_INFO_NAME = "Http";
    private static final int PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int PROTOCOL_INFO_MINOR_VERSION = 1;
    private static final AtomicInteger _nextId = new AtomicInteger(100);
    private final InetAddress _address;
    private final Repository _repository;
    private final ChecksumModuleV1 _checksumModule;
    private final PnfsId _pnfsId;
    private final String _sourcePoolName;
    private final String _destinationPoolCellname;
    private final String _destinationPoolCellDomainName;
    private final EntryState _targetState;
    private final List<StickyRecord> _stickyRecords;
    private final CacheFileAvailable _callback;
    private final ScheduledExecutorService _executor;
    private final CellStub _pnfs;
    private final CellStub _pool;
    private final CompanionContext _fsm = new CompanionContext(this);
    private final int _id;
    private StorageInfo _storageInfo;
    private Object _error;
    private Thread _thread;
    private ScheduledFuture _timerTask;
    private int _moverId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Companion(ScheduledExecutorService executor, InetAddress address, Repository repository, ChecksumModuleV1 checksumModule, CellStub pnfs, CellStub pool, PnfsId pnfsId, StorageInfo storageInfo, String sourcePoolName, String destinationPoolCellname, String destinationPoolCellDomainName, EntryState targetState, List<StickyRecord> stickyRecords, CacheFileAvailable callback) throws IOException {
        this._executor = executor;
        this._address = address;
        this._repository = repository;
        this._checksumModule = checksumModule;
        this._pnfs = pnfs;
        this._pool = pool;
        this._pnfsId = pnfsId;
        this._sourcePoolName = sourcePoolName;
        Preconditions.checkArgument((destinationPoolCellname != null ? 1 : 0) != 0, (Object)"Destination pool name is unknown. Aborting the request.");
        Preconditions.checkArgument((destinationPoolCellDomainName != null ? 1 : 0) != 0, (Object)"Destination domain name is unknown. Aborting the request");
        this._destinationPoolCellname = destinationPoolCellname;
        this._destinationPoolCellDomainName = destinationPoolCellDomainName;
        this._callback = callback;
        this._targetState = targetState;
        this._stickyRecords = new ArrayList<StickyRecord>(stickyRecords);
        if (storageInfo != null) {
            this.setStorageInfo(storageInfo);
        }
        this._id = _nextId.getAndIncrement();
        Companion companion = this;
        synchronized (companion) {
            this._fsm.start();
        }
    }

    public synchronized int getId() {
        return this._id;
    }

    public synchronized PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public synchronized long getPingPeriod() {
        return PING_PERIOD;
    }

    public synchronized boolean cancel(Object cause) {
        this._fsm.cancel(cause);
        return this._fsm.getState() != CompanionContext.FSM.Done;
    }

    public synchronized String toString() {
        return "" + this._id + " " + this._pnfsId + " " + (Object)((Object)this._fsm.getState());
    }

    public synchronized void messageArrived(DoorTransferFinishedMessage message) {
        this._fsm.messageArrived(message);
    }

    public synchronized void messageArrived(HttpDoorUrlInfoMessage message) {
        this._fsm.messageArrived(message);
    }

    private synchronized void setThread(Thread thread) {
        this._thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(String uri) {
        Object file;
        ReplicaDescriptor handle;
        Companion companion = this;
        synchronized (companion) {
            try {
                handle = this.createReplicaEntry();
            }
            catch (FileInCacheException e) {
                this._fsm.createEntryFailed();
                return;
            }
            this.setThread(Thread.currentThread());
        }
        Throwable error = null;
        try {
            try {
                file = handle.getFile();
                CacheEntry entry = handle.getEntry();
                long size = entry.getStorageInfo().getFileSize();
                handle.allocate(size);
                MessageDigest digest = this.createDigest();
                HttpURLConnection connection = this.createConnection(uri);
                try {
                    InputStream input = connection.getInputStream();
                    try {
                        long total = this.copy(input, (File)file, digest);
                        if (total != size) {
                            throw new IOException("Amount of received data does not match expected file size");
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                finally {
                    connection.disconnect();
                }
                this.setChecksum((File)file, digest);
            }
            finally {
                this.setThread(null);
                Thread.interrupted();
            }
            handle.commit(null);
        }
        catch (Throwable e) {
            error = e;
        }
        finally {
            handle.close();
            file = this;
            synchronized (file) {
                this._fsm.transferEnded(error);
            }
        }
    }

    private ReplicaDescriptor createReplicaEntry() throws FileInCacheException {
        return this._repository.createEntry(this._pnfsId, this._storageInfo, EntryState.FROM_POOL, this._targetState, this._stickyRecords);
    }

    private MessageDigest createDigest() {
        return this._checksumModule.checkOnTransfer() ? new Adler32() : null;
    }

    private HttpURLConnection createConnection(String uri) throws MalformedURLException, IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Connection", "close");
        connection.connect();
        return connection;
    }

    private void setChecksum(File file, MessageDigest digest) throws CacheException, InterruptedException, IOException {
        Checksum checksum = null;
        if (digest != null) {
            checksum = new Checksum(ChecksumType.ADLER32, digest.digest());
        }
        this._checksumModule.setMoverChecksums(this._pnfsId, file, this._checksumModule.getDefaultChecksumFactory(), null, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copy(InputStream input, File file, MessageDigest digest) throws IOException {
        long total = 0L;
        RandomAccessFile dataFile = new RandomAccessFile(file, "rw");
        try {
            int read;
            byte[] buffer = new byte[65536];
            while ((read = input.read(buffer)) > -1) {
                dataFile.write(buffer, 0, read);
                total += (long)read;
                if (digest == null) continue;
                digest.update(buffer, 0, read);
            }
        }
        finally {
            try {
                dataFile.getFD().sync();
            }
            catch (SyncFailedException e) {
                _log.warn("Failed to synchronize file with storage device: " + e.getMessage());
            }
            dataFile.close();
        }
        return total;
    }

    synchronized void setError(Object error) {
        if (this._error == null) {
            this._error = error;
        }
    }

    synchronized void clearError() {
        this._error = null;
    }

    synchronized boolean hasStorageInfo() {
        return this._storageInfo != null;
    }

    synchronized void getStorageInfo() {
        this._pnfs.send(new PnfsGetStorageInfoMessage(this._pnfsId), PnfsGetStorageInfoMessage.class, new Callback<PnfsGetStorageInfoMessage>(){

            @Override
            public void success(PnfsGetStorageInfoMessage message) {
                Companion.this.setStorageInfo(message.getStorageInfo());
                super.success(message);
            }
        });
    }

    synchronized void setStorageInfo(StorageInfo info) {
        this._storageInfo = info;
    }

    synchronized void startTimer(long delay) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Companion companion = Companion.this;
                synchronized (companion) {
                    if (Companion.this._timerTask != null) {
                        Companion.this._fsm.timer();
                        Companion.this._timerTask = null;
                    }
                }
            }
        };
        this._timerTask = this._executor.schedule(new FireAndForgetTask(task), delay, TimeUnit.MILLISECONDS);
    }

    synchronized void stopTimer() {
        if (this._timerTask != null) {
            this._timerTask.cancel(false);
            this._timerTask = null;
        }
    }

    synchronized void sendDeliveryRequest() {
        HttpProtocolInfo protocolInfo = new HttpProtocolInfo(PROTOCOL_INFO_NAME, 1, 1, new InetSocketAddress(this._address, 0), this._destinationPoolCellname, this._destinationPoolCellDomainName, "/" + this._pnfsId.toIdString());
        protocolInfo.setSessionId(this._id);
        PoolDeliverFileMessage request = new PoolDeliverFileMessage(this._sourcePoolName, this._pnfsId, protocolInfo, this._storageInfo);
        request.setPool2Pool();
        request.setInitiator(this.getInitiator());
        request.setId(this._id);
        this._pool.send(new CellPath(this._sourcePoolName), request, PoolDeliverFileMessage.class, new Callback<PoolDeliverFileMessage>(){

            @Override
            public void success(PoolDeliverFileMessage message) {
                Companion.this.setMoverId(message.getMoverId());
                super.success(message);
            }
        });
    }

    private String getInitiator() {
        return this._destinationPoolCellname + "@" + this._destinationPoolCellDomainName;
    }

    synchronized void setMoverId(int moverId) {
        this._moverId = moverId;
    }

    synchronized void ping() {
        this._pool.send(new CellPath(this._sourcePoolName), (Serializable)((Object)("p2p ls -binary " + this._moverId)), IoJobInfo.class, new Callback());
    }

    synchronized void beginTransfer(final String uri) {
        new Thread("P2P Transfer - " + this._pnfsId){

            @Override
            public void run() {
                Companion.this.transfer(uri);
            }
        }.start();
    }

    synchronized void done() {
        if (this._thread != null) {
            throw new IllegalStateException("Cannot close a companion while the transfer is in progress");
        }
        if (this._error != null) {
            if (this._error instanceof RuntimeException) {
                _log.error(String.format("P2P for %s failed: %s", this._pnfsId, this._error), (Throwable)((Exception)this._error));
            } else {
                _log.error(String.format("P2P for %s failed: %s", this._pnfsId, this._error));
            }
        } else {
            _log.info(String.format("P2P for %s completed", this._pnfsId));
        }
        if (this._callback != null) {
            final Object error = this._error;
            this._executor.execute(new FireAndForgetTask(new Runnable(){

                @Override
                public void run() {
                    Throwable t = error == null ? null : (error instanceof Throwable ? (Throwable)error : new CacheException(error.toString()));
                    Companion.this._callback.cacheFileAvailable(Companion.this._pnfsId, t);
                }
            }));
        }
    }

    synchronized void interrupt() {
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }

    class Callback<T>
    extends AbstractMessageCallback<T> {
        Callback() {
        }

        @Override
        public void success(T message) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.success();
                    }
                }
            }));
        }

        @Override
        public void failure(final int rc, final Object cause) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.failure(rc, cause);
                    }
                }
            }));
        }

        @Override
        public void timeout(CellPath path) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.timeout();
                    }
                }
            }));
        }

        @Override
        public void noroute(CellPath path) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.noroute();
                    }
                }
            }));
        }
    }
}

