/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.Base64;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.RemoteHttpDataTransferProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHttpDataTransferProtocol_1
implements MoverProtocol {
    private static final Logger _log = LoggerFactory.getLogger(RemoteHttpDataTransferProtocol_1.class);
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + RemoteHttpDataTransferProtocol_1.class.getName()));
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final long SERVER_LIFE_SPAN = 300000L;
    private static final int INC_SPACE = 0x3200000;
    private long allocated_space = 0L;
    private long last_transfer_time = System.currentTimeMillis();
    private final CellEndpoint cell;
    private RemoteHttpDataTransferProtocolInfo remoteHttpProtocolInfo;
    private long starttime;
    private URL remoteURL;
    private volatile long transfered = 0L;
    private boolean changed;

    public RemoteHttpDataTransferProtocol_1(CellEndpoint cell) {
        this.cell = cell;
        this.say("RemoteHTTPDataTransferAgent_1 created");
    }

    private void say(String str) {
        _log.info(str);
    }

    @Override
    public void runIO(RepositoryChannel fileChannel, ProtocolInfo protocol, StorageInfo storage, PnfsId pnfsId, Allocator allocator, IoMode access) throws Exception {
        this.say("runIO()\n\tprotocol=" + protocol + ",\n\tStorageInfo=" + storage + ",\n\tPnfsId=" + pnfsId + ",\n\taccess =" + (Object)((Object)access));
        if (!(protocol instanceof RemoteHttpDataTransferProtocolInfo)) {
            throw new CacheException("protocol info is not RemoteHttpDataTransferProtocolInfo");
        }
        this.starttime = System.currentTimeMillis();
        this.remoteHttpProtocolInfo = (RemoteHttpDataTransferProtocolInfo)protocol;
        this.remoteURL = new URL(this.remoteHttpProtocolInfo.getSourceHttpUrl());
        URLConnection connection = this.remoteURL.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new CacheException("wrong URL connection type");
        }
        HttpURLConnection httpconnection = (HttpURLConnection)connection;
        String userInfo = this.remoteURL.getUserInfo();
        if (userInfo != null) {
            String userPassEncoding = Base64.byteArrayToBase64(userInfo.getBytes());
            httpconnection.setRequestProperty("Authorization", "Basic " + userPassEncoding);
        }
        if (access == IoMode.WRITE) {
            httpconnection.setDoInput(true);
            httpconnection.setDoOutput(false);
            InputStream httpinput = httpconnection.getInputStream();
            byte[] buffer = new byte[this.remoteHttpProtocolInfo.getBufferSize()];
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            int read = 0;
            _logSpaceAllocation.debug("ALLOC: " + pnfsId + " : " + 0x3200000);
            allocator.allocate(0x3200000L);
            this.allocated_space += 0x3200000L;
            while ((read = httpinput.read(buffer)) != -1) {
                this.last_transfer_time = System.currentTimeMillis();
                if (this.transfered + (long)read > this.allocated_space) {
                    _logSpaceAllocation.debug("ALLOC: " + pnfsId + " : " + 0x3200000);
                    allocator.allocate(0x3200000L);
                    this.allocated_space += 0x3200000L;
                }
                bb.limit(read);
                fileChannel.write(bb);
                this.changed = true;
                this.transfered += (long)read;
                bb.clear();
            }
            this.say("runIO() wrote " + this.transfered + "bytes");
        } else {
            httpconnection.setDoInput(false);
            httpconnection.setDoOutput(true);
            OutputStream httpoutput = httpconnection.getOutputStream();
        }
        this.say(" runIO() done");
    }

    @Override
    public long getLastTransferred() {
        return this.last_transfer_time;
    }

    @Override
    public long getBytesTransferred() {
        return this.transfered;
    }

    @Override
    public long getTransferTime() {
        return System.currentTimeMillis() - this.starttime;
    }

    @Override
    public boolean wasChanged() {
        return this.changed;
    }
}

