/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import dmg.cells.nucleus.CDC;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.dcache.util.CDCThreadFactory;
import org.dcache.util.PortRange;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public abstract class AbstractNettyServer<T> {
    private final Executor _acceptExecutor;
    private final Executor _socketExecutor;
    private final Executor _diskExecutor;
    private final Timer _timer;
    private final long _clientIdleTimeout;
    private Channel _serverChannel;
    private final ChannelFactory _channelFactory;
    private Map<UUID, T> _moversPerUUID = new HashMap<UUID, T>();
    private int _numberClientConnections;

    public AbstractNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int clientIdleTimeout, int socketThreads) {
        this._diskExecutor = new OrderedMemoryAwareThreadPoolExecutor(threadPoolSize, (long)memoryPerConnection, (long)maxMemory);
        CDCThreadFactory factory = new CDCThreadFactory(Executors.defaultThreadFactory(), CDC.getCellName(), CDC.getDomainName());
        this._acceptExecutor = Executors.newCachedThreadPool(factory);
        this._socketExecutor = Executors.newCachedThreadPool(factory);
        this._channelFactory = socketThreads == -1 ? new NioServerSocketChannelFactory(this._acceptExecutor, this._socketExecutor) : new NioServerSocketChannelFactory(this._acceptExecutor, this._socketExecutor, socketThreads);
        this._clientIdleTimeout = clientIdleTimeout;
        this._timer = new HashedWheelTimer();
    }

    protected synchronized void startServer() throws IOException {
        if (this._serverChannel != null) {
            throw new IllegalStateException("Server channel seems to be in use, refuse to start new one.");
        }
        PortRange range = this.getPortRange();
        ServerBootstrap bootstrap = new ServerBootstrap(this._channelFactory);
        bootstrap.setOption("child.tcpNoDelay", (Object)false);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setPipelineFactory(this.newPipelineFactory());
        this._serverChannel = range.bind(bootstrap);
    }

    protected synchronized void stopServer() throws IOException {
        if (this._serverChannel != null) {
            this._serverChannel.close();
            this._serverChannel = null;
        }
    }

    public synchronized InetSocketAddress getServerAddress() throws IOException {
        if (!this.isRunning()) {
            throw new IOException("Cannot get server address as server channel is not bound!");
        }
        return (InetSocketAddress)this._serverChannel.getLocalAddress();
    }

    public T getMover(UUID uuid) {
        return this._moversPerUUID.get(uuid);
    }

    protected synchronized boolean isRunning() {
        return this._serverChannel != null && this._serverChannel.isBound() && this._serverChannel.isOpen();
    }

    public synchronized void register(UUID uuid, T mover) throws IOException {
        this._moversPerUUID.put(uuid, mover);
        this.toggleServer();
    }

    public synchronized void unregister(UUID uuid) throws IOException {
        this._moversPerUUID.remove(uuid);
        this.toggleServer();
    }

    public synchronized void clientConnected() throws IOException {
        ++this._numberClientConnections;
        this.toggleServer();
    }

    public synchronized void clientDisconnected() throws IOException {
        --this._numberClientConnections;
        this.toggleServer();
    }

    public int getConnectedClients() {
        return this._numberClientConnections;
    }

    protected Map<UUID, T> getMoversPerUUID() {
        return this._moversPerUUID;
    }

    protected abstract PortRange getPortRange();

    protected abstract void toggleServer() throws IOException;

    protected abstract ChannelPipelineFactory newPipelineFactory();

    protected Executor getDiskExecutor() {
        return this._diskExecutor;
    }

    protected Executor getAcceptExecutor() {
        return this._acceptExecutor;
    }

    protected long getClientIdleTimeout() {
        return this._clientIdleTimeout;
    }

    protected Executor getSocketExecutor() {
        return this._socketExecutor;
    }

    protected Timer getTimer() {
        return this._timer;
    }
}

