/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.ImmutableList;
import diskCacheV111.vehicles.PoolManagerGetPoolsMessage;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.pool.migration.RefreshablePoolList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoolListFromPoolManager
extends AbstractMessageCallback<PoolManagerGetPoolsMessage>
implements RefreshablePoolList {
    private static final Logger _log = LoggerFactory.getLogger(PoolListFromPoolManager.class);
    protected ImmutableList<PoolManagerPoolInformation> _pools = ImmutableList.of();
    protected boolean _isValid = false;

    @Override
    public synchronized boolean isValid() {
        return this._isValid;
    }

    @Override
    public synchronized ImmutableList<PoolManagerPoolInformation> getPools() {
        return this._pools;
    }

    @Override
    public synchronized void success(PoolManagerGetPoolsMessage msg) {
        this._pools = ImmutableList.copyOf(msg.getPools());
        this._isValid = true;
    }

    @Override
    public void failure(int rc, Object error) {
        _log.error("Failed to query pool manager (" + error + ")");
    }
}

