/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import dmg.cells.nucleus.CellEndpoint;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.pool.migration.AccessLatencyFilter;
import org.dcache.pool.migration.AccessedFilter;
import org.dcache.pool.migration.BestPoolSelectionStrategy;
import org.dcache.pool.migration.CacheEntryFilter;
import org.dcache.pool.migration.CacheEntryMode;
import org.dcache.pool.migration.Job;
import org.dcache.pool.migration.JobDefinition;
import org.dcache.pool.migration.LruOrder;
import org.dcache.pool.migration.MigrationContext;
import org.dcache.pool.migration.PnfsIdFilter;
import org.dcache.pool.migration.PoolListByLink;
import org.dcache.pool.migration.PoolListByNames;
import org.dcache.pool.migration.PoolListByPoolGroup;
import org.dcache.pool.migration.PoolListFilter;
import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.PoolMigrationJobCancelMessage;
import org.dcache.pool.migration.PoolSelectionStrategy;
import org.dcache.pool.migration.ProportionalPoolSelectionStrategy;
import org.dcache.pool.migration.RandomPoolSelectionStrategy;
import org.dcache.pool.migration.RefreshablePoolList;
import org.dcache.pool.migration.RetentionPolicyFilter;
import org.dcache.pool.migration.ReverseOrder;
import org.dcache.pool.migration.SizeFilter;
import org.dcache.pool.migration.SizeOrder;
import org.dcache.pool.migration.StateFilter;
import org.dcache.pool.migration.StickyFilter;
import org.dcache.pool.migration.StickyOwnerFilter;
import org.dcache.pool.migration.StorageClassFilter;
import org.dcache.pool.migration.SymbolTable;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Glob;
import org.dcache.util.expression.Expression;
import org.dcache.util.expression.ExpressionParser;
import org.dcache.util.expression.Token;
import org.dcache.util.expression.Type;
import org.dcache.util.expression.TypeMismatchException;
import org.dcache.util.expression.UnknownIdentifierException;
import org.parboiled.Parboiled;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationModule
extends AbstractCellComponent
implements CellCommandListener,
CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(MigrationModule.class);
    private static final PoolManagerPoolInformation DUMMY_POOL = new PoolManagerPoolInformation("pool", 0.0, 0.0);
    public static final String CONSTANT_TARGET = "target";
    public static final String CONSTANT_SOURCE = "source";
    public static final String CONSTANT_TARGETS = "targets";
    public static final String CONSTANT_QUEUE_FILES = "queue.files";
    public static final String CONSTANT_QUEUE_BYTES = "queue.bytes";
    public static final int NON_EMPTY_QUEUE = 1;
    public static final int NO_TARGETS = 0;
    private final Map<String, Job> _jobs = new HashMap<String, Job>();
    private final Map<Job, String> _commands = new HashMap<Job, String>();
    private final MigrationContext _context = new MigrationContext();
    private static final Expression TRUE_EXPRESSION = new Expression(Token.TRUE, new Expression[0]);
    private static final Expression FALSE_EXPRESSION = new Expression(Token.FALSE, new Expression[0]);
    private int _counter = 1;
    private static final Pattern STICKY_PATTERN;
    public static final String hh_migration_concurrency = "<job> <n>";
    public static final String fh_migration_concurrency = "Adjusts the concurrency of a job.";
    public static final String hh_migration_copy = "[options] <target> ...";
    public static final String fh_migration_copy = "Copies files to other pools. Unless filter options are specified,\nall files on the source pool are copied.\n\nThe operation is idempotent, that is, it can safely be repeated\nwithout creating extra copies of the files. If the replica exists\non any of the target pools, then it is not copied again. If the\ntarget pool with the existing replica fails to respond, then the\noperation is retried indefinitely, unless the job is marked as\neager.\n\nPlease notice that a job is only idempotent as long as the set of\ntarget pools do not change. If pools go offline or are excluded as\na result of a an exclude or include expression, then the idempotent\nnature of a job may be lost.\n\nBoth the state of the local replica and that of the target replica\ncan be specified. If the target replica already exists, the state\nis updated to be at least as strong as the specified target state,\nthat is, the lifetime of sticky bits is extended, but never reduced,\nand cached can be changed to precious, but never the opposite.\n\nTransfers are subject to the checksum computiton policy of the\ntarget pool. Thus checksums are verified if and only if the target\npool is configured to do so. For existing replicas, the checksum is\nonly verified if the verify option was specified on the migration job.\n\nJobs can be marked permanent. Permanent jobs never terminate and\nare stored in the pool setup file with the 'save' command. Permanent\njobs watch the repository for state changes and copy any replicas\nthat match the selection criteria, even replicas added after the\njob was created. Notice that any state change will cause a replica\nto be reconsidered and enqueued if it matches the selection\ncriteria - also replicas that have been copied before.\n\nSeveral options allow an expression to be specified. The following\noperators are recognized: <, <=, ==, !=, >=, >, ~=, !~, +, -, *, /,\n**, %, and, or, not, ?:. Literals may be floating point literals,\nsingle or double quoted string literals, and boolean true and false.\nDepending on the context, the expression may refer to constants.\n\nSyntax:\n  copy [options] <target> ...\n\nFilter options:\n  -accessed=<n>|[<n>]..[<m>]\n          Only copy replicas accessed n seconds ago, or accessed\n          within the given, possibly open-ended, interval. E.g.\n          -accessed=0..60 matches files accessed within the last\n          minute; -accesed=60.. matches files accessed one minute\n          or more ago.\n  -al=ONLINE|NEARLINE\n          Only copy replicas with the given access latency.\n  -pnfsid=<pnfsid>[,<pnfsid>] ...\n          Only copy replicas with one of the given PNFS IDs.\n  -rp=CUSTODIAL|REPLICA|OUTPUT\n          Only copy replicas with the given retention policy.\n  -size=<n>|[<n>]..[<m>]\n          Only copy replicas with size n, or a size within the\n          given, possibly open-ended, interval.\n  -state=cached|precious\n          Only copy replicas in the given state.\n  -sticky[=<owner>[,<owner>...]]\n          Only copy sticky replicas. Can optionally be limited to\n          the list of owners. A sticky flag for each owner must be\n          present for the replica to be selected.\n  -storage=<class>\n          Only copy replicas with the given storage class.\n\nTransfer options:\n  -concurrency=<concurrency>\n          Specifies how many concurrent transfers to perform.\n          Defaults to 1.\n  -order=[-]size|[-]lru\n          Sort transfer queue. By default transfers are placed in\n          ascending order, that is, smallest and least recently used\n          first. Transfers are placed in descending order if the key\n          is prefixed by a minus sign. Failed transfers are placed at\n          the end of the queue for retry regardless of the order. This\n          option cannot be used for permanent jobs. Notice that for\n          pools with a large number of files, sorting significantly\n          increases the initialization time of the migration job.\n          size:\n              Sort according to file size.\n          lru:\n              Sort according to last access time.\n  -pins=move|keep\n          Controls how sticky flags owned by the pin manager are handled:\n          move:\n              Ask pin manager to move pins to the target pool.\n          keep:\n              Keep pin on the source pool.\n  -smode=same|cached|precious|removable|delete[+<owner>[(<lifetime>)] ...]\n          Update the local replica to the given mode after transfer:\n          same:\n              does not change the local state (this is the default).\n          cached:\n              marks it cached.\n          precious:\n              marks it precious.\n          removable:\n              marks it cached and strips all existing sticky flags\n              exluding pins.\n          delete:\n              deletes the replica unless it is pinned.\n          An optional list of sticky flags can be specified. The\n          lifetime is in seconds. A lifetime of 0 causes the flag\n          to immediately expire. Notice that existing sticky flags\n          of the same owner are overwritten.\n  -tmode=same|cached|precious[+<owner>[(<lifetime>)]...]\n          Set the mode of the target replica:\n          same:\n              applies the state and sticky bits excluding pins\n              of the local replica (this is the default).\n          cached:\n              marks it cached.\n          precious:\n              marks it precious.\n          An optional list of sticky flags can be specified. The\n          lifetime is in seconds.\n  -verify\n          Force checksum computation when an existing target is updated.\n\nTarget options:\n  -eager\n          Copy replicas rather than retrying when pools with\n          existing replicas fail to respond.\n  -exclude=<pattern>[,<pattern>...]\n          Exclude target pools matching any of the patterns. Single\n          character (?) and multi character (*) wildcards may be used.\n  -exclude-when=<expr>\n          Exclude target pools for which the expression evaluates to\n          true. The expression may refer to the following constants:\n          source.name/target.name:\n              pool name\n          source.spaceCost/target.spaceCost:\n              space cost\n          source.cpuCost/target.cpuCost:\n              cpu cost\n          source.free/target.free:\n              free space in bytes\n          source.total/target.total:\n              total space in bytes\n          source.removable/target.removable:\n              removable space in bytes\n          source.used/target.used:\n              used space in bytes\n  -include=<pattern>[,<pattern>...]\n          Only include target pools matching any of the patterns. Single\n          character (?) and multi character (*) wildcards may be used.\n  -include-when=<expr>\n          Only include target pools for which the expression evaluates\n          to true. See the description of -exclude-when for the list\n          of allowed constants.\n  -refresh=<time>\n          Sets the period in seconds of when target pool information\n          is queried from the pool manager. Inclusion and exclusion\n          expressions are evaluated whenever the information is\n          refreshed. The default is 300 seconds.\n  -select=proportional|best|random\n          Determines how a pool is selected from the set of target pools:\n          proportional:\n              selects a pool with a probability proportional\n              to the free space.\n          best:\n              selects the pool with the lowest space cost.\n          random:\n              selects a pool randomly.\n          The default is 'proportional'.\n  -target=pool|pgroup|link\n          Determines the interpretation of the target names. The\n          default is 'pool'.\n\nLifetime options:\n  -pause-when=<expr>\n          Pauses the job when the expression becomes true. The job\n          continues when the expression once again evaluates to false.\n          The following constants are defined for this pool:\n          queue.files:\n              the number of files remaining to be transferred.\n          queue.bytes:\n              the number of bytes remaining to be transferred.\n          source.name:\n              pool name\n          source.spaceCost:\n              space cost\n          source.cpuCost:\n              cpu cost\n          source.free:\n              free space in bytes\n          source.total:\n              total space in bytes\n          source.removable:\n              removable space in bytes\n          source.used:\n              used space in bytes\n          targets:\n              the number of target pools.\n  -permanent\n          Mark job as permanent.\n  -stop-when=<expr>\n          Terminates the job when the expression becomes true. This option\n          cannot be used for permanent jobs. See the description of\n          -pause-when for the list of constants allowed in the expression.\n";
    public static final String hh_migration_move = "[options] <target> ...";
    public static final String fh_migration_move = "Moves replicas to other pools. The source replica is deleted.\nAccepts the same options as 'migration copy'. Corresponds to\n\n     migration copy -smode=delete -tmode=same -pins=move -verify\n";
    public static final String hh_migration_cache = "[options] <target> ...";
    public static final String fh_migration_cache = "Caches replicas on other pools. Accepts the same options as\n'migration copy'. Corresponds to\n\n     migration copy -smode=same -tmode=cached\n";
    public static final String hh_migration_suspend = "<job>";
    public static final String fh_migration_suspend = "Suspends a migration job. A suspended job finishes ongoing\ntransfers, but is does not start any new transfer.";
    public static final String hh_migration_resume = "<job>";
    public static final String fh_migration_resume = "Resumes a suspended migration job.";
    public static final String hh_migration_cancel = "[-force] <job>";
    public static final String fh_migration_cancel = "Cancels a migration job.\n\nOptions:\n  -force\n     Kill ongoing transfers.";
    public static final String fh_migration_clear = "Removes completed migration jobs. For reference, information about\nmigration jobs are kept until explicitly cleared.\n";
    public static final String fh_migration_ls = "Lists all migration jobs.";
    public static final String hh_migration_info = "<job>";
    public static final String fh_migration_info = "Shows detailed information about a migration job. Possible\njob states are:\n\n   INITIALIZING   Initial scan of repository\n   RUNNING        Job runs (schedules new tasks)\n   SLEEPING       A task failed; no tasks are scheduled for 10 seconds\n   PAUSED         Pause expression evaluates to true; no tasks for 10 seconds\n   STOPPING       Stop expression evaluated to true; waiting for tasks to stop\n   SUSPENDED      Job suspended by user; no tasks are scheduled\n   CANCELLING     Job cancelled by user; waiting for tasks to stop\n   CANCELLED      Job cancelled by user; no tasks are running\n   FINISHED       Job completed\n\n   FAILED         Job failed (check log file for details)\nJob tasks may be in any of the following states:\n\n   Queued               Queued for execution\n   GettingLocations     Querying PnfsManager for file locations\n   UpdatingExistingFile Updating the state of existing target file\n   CancellingUpdate     Task cancelled, waiting for update to complete\n   InitiatingCopy       Request send to target, waiting for confirmation\n   Copying              Waiting for target to complete the transfer\n   Pinging              Ping send to target, waiting for reply\n   NoResponse           Cell connection to target lost\n   Waiting              Waiting for final confirmation from target\n   MovingPin            Waiting for pin manager to move pin\n   Cancelling           Attempting to cancel transfer\n   Cancelled            Task cancelled, file was not copied\n   Failed               The task failed\n   Done                 The task completed successfully";

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        super.setCellEndpoint(endpoint);
        this._context.setPoolName(this.getCellName());
    }

    public void setRepository(Repository repository) {
        this._context.setRepository(repository);
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this._context.setExecutor(executor);
    }

    public void setPnfsStub(CellStub stub) {
        this._context.setPnfsStub(stub);
    }

    public void setPoolManagerStub(CellStub stub) {
        this._context.setPoolManagerStub(stub);
    }

    public void setPoolStub(CellStub stub) {
        this._context.setPoolStub(stub);
    }

    public void setPinManagerStub(CellStub stub) {
        this._context.setPinManagerStub(stub);
    }

    private synchronized Job getJob(String id) throws NoSuchElementException {
        Job job = this._jobs.get(id);
        if (job == null) {
            throw new NoSuchElementException("Job not found");
        }
        return job;
    }

    private synchronized String getJobSummary(String id) {
        Job job = this.getJob(id);
        return String.format("[%s] %-12s %s", new Object[]{id, job.getState(), this._commands.get(job)});
    }

    private static Range<Long> parseRange(String s) throws IllegalArgumentException {
        String[] bounds = s.split("\\.\\.", 2);
        switch (bounds.length) {
            case 1: {
                return Ranges.singleton((Comparable)Long.valueOf(Long.parseLong(bounds[0])));
            }
            case 2: {
                if (bounds[0].length() == 0 && bounds[1].length() == 0) {
                    return Ranges.all();
                }
                if (bounds[0].length() == 0) {
                    return Ranges.atMost((Comparable)Long.valueOf(Long.parseLong(bounds[1])));
                }
                if (bounds[1].length() == 0) {
                    return Ranges.atLeast((Comparable)Long.valueOf(Long.parseLong(bounds[0])));
                }
                return Ranges.closed((Comparable)Long.valueOf(Long.parseLong(bounds[0])), (Comparable)Long.valueOf(Long.parseLong(bounds[1])));
            }
        }
        throw new IllegalArgumentException(s + ": Invalid interval");
    }

    private List<CacheEntryFilter> createFilters(Args args) throws IllegalArgumentException, NumberFormatException {
        String state = args.getOpt("state");
        String sticky = args.getOpt("sticky");
        String sc = args.getOpt("storage");
        String pnfsid = args.getOpt("pnfsid");
        String accessed = args.getOpt("accessed");
        String size = args.getOpt("size");
        String al = args.getOpt("al");
        String rp = args.getOpt("rp");
        ArrayList<CacheEntryFilter> filters = new ArrayList<CacheEntryFilter>();
        if (sc != null) {
            filters.add(new StorageClassFilter(sc));
        }
        if (pnfsid != null) {
            HashSet<PnfsId> ids = new HashSet<PnfsId>();
            for (String id : pnfsid.split(",")) {
                ids.add(new PnfsId(id));
            }
            filters.add(new PnfsIdFilter(ids));
        }
        if (state == null) {
            filters.add(new StateFilter(EntryState.CACHED, EntryState.PRECIOUS));
        } else if (state.equals("cached")) {
            filters.add(new StateFilter(EntryState.CACHED));
        } else if (state.equals("precious")) {
            filters.add(new StateFilter(EntryState.PRECIOUS));
        } else {
            throw new IllegalArgumentException(state + ": Invalid state");
        }
        if (sticky != null) {
            if (sticky.equals("")) {
                filters.add(new StickyFilter());
            } else {
                for (String owner : sticky.split(",")) {
                    filters.add(new StickyOwnerFilter(owner));
                }
            }
        }
        if (size != null) {
            filters.add(new SizeFilter(MigrationModule.parseRange(size)));
        }
        if (accessed != null) {
            filters.add(new AccessedFilter(MigrationModule.parseRange(accessed)));
        }
        if (al != null) {
            filters.add(new AccessLatencyFilter(AccessLatency.getAccessLatency((String)al)));
        }
        if (rp != null) {
            filters.add(new RetentionPolicyFilter(RetentionPolicy.getRetentionPolicy((String)rp)));
        }
        return filters;
    }

    private RefreshablePoolList createPoolList(String type, List<String> targets) {
        CellStub poolManager = this._context.getPoolManagerStub();
        if (type.equals("pool")) {
            return new PoolListByNames(poolManager, targets);
        }
        if (type.equals("pgroup")) {
            if (targets.size() != 1) {
                throw new IllegalArgumentException(targets.toString() + ": Only one target supported for -type=pgroup");
            }
            return new PoolListByPoolGroup(poolManager, targets.get(0));
        }
        if (type.equals("link")) {
            if (targets.size() != 1) {
                throw new IllegalArgumentException(targets.toString() + ": Only one target supported for -type=link");
            }
            return new PoolListByLink(poolManager, targets.get(0));
        }
        throw new IllegalArgumentException(type + ": Invalid value");
    }

    private PoolSelectionStrategy createPoolSelectionStrategy(double spaceCost, double cpuCost, String type) {
        if (type.equals("proportional")) {
            return new ProportionalPoolSelectionStrategy();
        }
        if (type.equals("best")) {
            return new BestPoolSelectionStrategy(spaceCost, cpuCost);
        }
        if (type.equals("random")) {
            return new RandomPoolSelectionStrategy();
        }
        throw new IllegalArgumentException(type + ": Invalid value");
    }

    private StickyRecord parseStickyRecord(String s) throws IllegalArgumentException {
        Matcher matcher = STICKY_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(s + ": Syntax error");
        }
        String owner = matcher.group(1);
        String lifetime = matcher.group(3);
        try {
            long expire;
            long l = expire = lifetime == null ? -1L : (long)Integer.valueOf(lifetime).intValue();
            if (expire < -1L) {
                throw new IllegalArgumentException(lifetime + ": Invalid lifetime");
            }
            if (expire > 0L) {
                expire = System.currentTimeMillis() + expire * 1000L;
            }
            return new StickyRecord(owner, expire);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(lifetime + ": Invalid lifetime");
        }
    }

    private CacheEntryMode createCacheEntryMode(String type) {
        String[] s = type.split("\\+");
        ArrayList<StickyRecord> records = new ArrayList<StickyRecord>();
        for (int i = 1; i < s.length; ++i) {
            records.add(this.parseStickyRecord(s[i]));
        }
        if (s[0].equals("same")) {
            return new CacheEntryMode(CacheEntryMode.State.SAME, records);
        }
        if (s[0].equals("cached")) {
            return new CacheEntryMode(CacheEntryMode.State.CACHED, records);
        }
        if (s[0].equals("delete")) {
            return new CacheEntryMode(CacheEntryMode.State.DELETE, records);
        }
        if (s[0].equals("removable")) {
            return new CacheEntryMode(CacheEntryMode.State.REMOVABLE, records);
        }
        if (s[0].equals("precious")) {
            return new CacheEntryMode(CacheEntryMode.State.PRECIOUS, records);
        }
        throw new IllegalArgumentException(type + ": Invalid value");
    }

    private Comparator<CacheEntry> createComparator(String order) {
        if (order == null) {
            return null;
        }
        if (order.equals("size")) {
            return new SizeOrder();
        }
        if (order.equals("-size")) {
            return new ReverseOrder<CacheEntry>(new SizeOrder());
        }
        if (order.equals("lru")) {
            return new LruOrder();
        }
        if (order.equals("-lru")) {
            return new ReverseOrder<CacheEntry>(new LruOrder());
        }
        throw new IllegalArgumentException(order + ": Invalid value for option -order");
    }

    private Expression createPredicate(String s, Expression ifNull, SymbolTable symbols) {
        try {
            if (s == null) {
                return ifNull;
            }
            ExpressionParser parser = (ExpressionParser)Parboiled.createParser(ExpressionParser.class, (Object[])new Object[0]);
            ParsingResult result = new ReportingParseRunner(parser.Top()).run(s);
            if (result.hasErrors()) {
                throw new IllegalArgumentException("Invalid expression: " + ErrorUtils.printParseErrors((ParsingResult)result));
            }
            Expression expression = (Expression)((Object)result.resultValue);
            if (expression.check(symbols) != Type.BOOLEAN) {
                throw new IllegalArgumentException("Expression does not evaluate to a boolean");
            }
            return expression;
        }
        catch (UnknownIdentifierException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private Expression createPoolPredicate(String s, Expression ifNull) {
        SymbolTable symbols = new SymbolTable();
        symbols.put(CONSTANT_SOURCE, DUMMY_POOL);
        symbols.put(CONSTANT_TARGET, DUMMY_POOL);
        return this.createPredicate(s, ifNull, symbols);
    }

    private Expression createLifetimePredicate(String s) {
        SymbolTable symbols = new SymbolTable();
        symbols.put(CONSTANT_SOURCE, DUMMY_POOL);
        symbols.put(CONSTANT_QUEUE_FILES, 1L);
        symbols.put(CONSTANT_QUEUE_BYTES, 1L);
        symbols.put(CONSTANT_TARGETS, 0L);
        return this.createPredicate(s, null, symbols);
    }

    private Set<Pattern> createPatterns(String globs) {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        if (globs != null) {
            for (String s : globs.split(",")) {
                patterns.add(Glob.parseGlobToPattern((String)s));
            }
        }
        return patterns;
    }

    private synchronized String copy(Args args, String defaultSelect, String defaultTarget, String defaultSourceMode, String defaultTargetMode, String defaultRefresh, String defaultPins, boolean defaultVerify) throws IllegalArgumentException, NumberFormatException {
        boolean mustMovePins;
        String exclude = args.getOpt("exclude");
        String excludeWhen = args.getOpt("exclude-when");
        String include = args.getOpt("include");
        String includeWhen = args.getOpt("include-when");
        boolean permanent = args.hasOption("permanent");
        boolean eager = args.hasOption("eager");
        boolean verify = args.hasOption("verify") || defaultVerify;
        String sourceMode = args.getOpt("smode");
        String targetMode = args.getOpt("tmode");
        String select = args.getOpt("select");
        String target = args.getOpt(CONSTANT_TARGET);
        String refresh = args.getOpt("refresh");
        String concurrency = args.getOpt("concurrency");
        String pins = args.getOpt("pins");
        String order = args.getOpt("order");
        String pauseWhen = args.getOpt("pause-when");
        String stopWhen = args.getOpt("stop-when");
        String id = args.getOpt("id");
        if (permanent) {
            if (order != null) {
                throw new IllegalArgumentException("Permanent jobs cannot be ordered");
            }
            if (stopWhen != null) {
                throw new IllegalArgumentException("Permanent jobs cannot have a stop condition.");
            }
        }
        if (select == null) {
            select = defaultSelect;
        }
        if (target == null) {
            target = defaultTarget;
        }
        if (sourceMode == null) {
            sourceMode = defaultSourceMode;
        }
        if (targetMode == null) {
            targetMode = defaultTargetMode;
        }
        if (refresh == null) {
            refresh = defaultRefresh;
        }
        if (concurrency == null) {
            concurrency = "1";
        }
        if (pins == null) {
            pins = defaultPins;
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (int i = 0; i < args.argc(); ++i) {
            targets.add(args.argv(i));
        }
        Set<Pattern> excluded = this.createPatterns(exclude);
        excluded.add(Pattern.compile(Pattern.quote(this._context.getPoolName())));
        Set<Pattern> included = this.createPatterns(include);
        if (pins.equals("keep")) {
            mustMovePins = false;
        } else if (pins.equals("move")) {
            mustMovePins = true;
        } else {
            throw new IllegalArgumentException(pins + ": Invalid value for option -pins");
        }
        PoolListByNames sourceList = new PoolListByNames(this._context.getPoolManagerStub(), Collections.singletonList(this._context.getPoolName()));
        Expression excludeExpression = this.createPoolPredicate(excludeWhen, FALSE_EXPRESSION);
        Expression includeExpression = this.createPoolPredicate(includeWhen, TRUE_EXPRESSION);
        PoolListFilter poolList = new PoolListFilter(this.createPoolList(target, targets), excluded, excludeExpression, included, includeExpression, sourceList);
        JobDefinition definition = new JobDefinition(this.createFilters(args), this.createCacheEntryMode(sourceMode), this.createCacheEntryMode(targetMode), this.createPoolSelectionStrategy(1.0, 0.0, select), this.createComparator(order), sourceList, poolList, Integer.valueOf(refresh) * 1000, permanent, eager, mustMovePins, verify, this.createLifetimePredicate(pauseWhen), this.createLifetimePredicate(stopWhen));
        if (definition.targetMode.state == CacheEntryMode.State.DELETE || definition.targetMode.state == CacheEntryMode.State.REMOVABLE) {
            throw new IllegalArgumentException(targetMode + ": Invalid value");
        }
        if (id == null) {
            while (this._jobs.containsKey(id = String.valueOf(this._counter++))) {
            }
        } else {
            Job job = this._jobs.get(id);
            if (job != null) {
                switch (job.getState()) {
                    case FAILED: 
                    case CANCELLED: 
                    case FINISHED: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Job id is already in use: " + id);
                    }
                }
            }
        }
        int n = Integer.valueOf(concurrency);
        Job job = new Job(this._context, definition);
        job.setConcurrency(n);
        this._jobs.put(id, job);
        return id;
    }

    public synchronized void cancelAll() {
        for (Job job : this._jobs.values()) {
            try {
                job.cancel(true);
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public String ac_migration_concurrency_$_2(Args args) {
        String id = args.argv(0);
        int concurrency = Integer.valueOf(args.argv(1));
        Job job = this.getJob(id);
        job.setConcurrency(concurrency);
        return String.format("[%s] Concurrency set to %d", id, concurrency);
    }

    public synchronized String ac_migration_copy_$_1_99(Args args) throws IllegalArgumentException, NumberFormatException {
        String id = this.copy(args, "proportional", "pool", "same", "same", "300", "keep", false);
        String command = "migration copy " + args.toString();
        this._commands.put(this._jobs.get(id), command);
        return this.getJobSummary(id);
    }

    public String ac_migration_move_$_1_99(Args args) throws IllegalArgumentException, NumberFormatException {
        String id = this.copy(args, "proportional", "pool", "delete", "same", "300", "move", true);
        String command = "migration move " + args.toString();
        this._commands.put(this._jobs.get(id), command);
        return this.getJobSummary(id);
    }

    public String ac_migration_cache_$_1_99(Args args) throws IllegalArgumentException, NumberFormatException {
        String id = this.copy(args, "proportional", "pool", "same", "cached", "300", "keep", false);
        String command = "migration cache " + args.toString();
        this._commands.put(this._jobs.get(id), command);
        return this.getJobSummary(id);
    }

    public String ac_migration_suspend_$_1(Args args) {
        String id = args.argv(0);
        Job job = this.getJob(id);
        job.suspend();
        return this.getJobSummary(id);
    }

    public String ac_migration_resume_$_1(Args args) {
        String id = args.argv(0);
        Job job = this.getJob(id);
        job.resume();
        return this.getJobSummary(id);
    }

    public String ac_migration_cancel_$_1(Args args) {
        String id = args.argv(0);
        boolean force = args.hasOption("force");
        Job job = this.getJob(id);
        job.cancel(force);
        return this.getJobSummary(id);
    }

    public synchronized String ac_migration_clear(Args args) {
        Iterator<Job> i = this._jobs.values().iterator();
        while (i.hasNext()) {
            Job job = i.next();
            switch (job.getState()) {
                case CANCELLED: 
                case FINISHED: {
                    i.remove();
                    this._commands.remove(job);
                    break;
                }
            }
        }
        return "";
    }

    public synchronized String ac_migration_ls(Args args) {
        StringBuilder s = new StringBuilder();
        for (String id : this._jobs.keySet()) {
            s.append(this.getJobSummary(id)).append('\n');
        }
        return s.toString();
    }

    public synchronized String ac_migration_info_$_1(Args args) throws NoSuchElementException {
        String id = args.argv(0);
        Job job = this.getJob(id);
        String command = this._commands.get(job);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Command    : " + command);
        job.getInfo(pw);
        return sw.toString();
    }

    public synchronized void messageArrived(PoolMigrationCopyFinishedMessage message) {
        if (!message.getPool().equals(this._context.getPoolName())) {
            return;
        }
        for (Job job : this._jobs.values()) {
            job.messageArrived(message);
        }
    }

    public Object messageArrived(PoolMigrationJobCancelMessage message) {
        try {
            return this.getJob(message.getJobId()).messageArrived(message);
        }
        catch (NoSuchElementException e) {
            message.setSucceeded();
            return message;
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        for (String id : this._jobs.keySet()) {
            pw.println(this.getJobSummary(id));
        }
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        pw.println("#\n# MigrationModule\n#");
        for (Job job : this._jobs.values()) {
            if (!job.getDefinition().isPermanent) continue;
            pw.println(this._commands.get(job));
        }
    }

    public synchronized boolean isActive(PnfsId id) {
        return this._context.isActive(id);
    }

    static {
        TRUE_EXPRESSION.setType(Type.BOOLEAN);
        FALSE_EXPRESSION.setType(Type.BOOLEAN);
        STICKY_PATTERN = Pattern.compile("(\\w+)(\\((-?\\d+)\\))?");
    }
}

