/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.vehicles.PoolManagerPoolInformation;
import org.dcache.pool.migration.PoolSelectionStrategy;

public abstract class CostFactorPoolSelectionStrategy
implements PoolSelectionStrategy {
    private final double _spaceCostFactor;
    private final double _cpuCostFactor;

    public CostFactorPoolSelectionStrategy(double spaceCostFactor, double cpuCostFactor) {
        this._spaceCostFactor = spaceCostFactor;
        this._cpuCostFactor = cpuCostFactor;
    }

    protected double cost(PoolManagerPoolInformation pool) {
        double space = this._spaceCostFactor > 0.0 ? pool.getSpaceCost() * this._spaceCostFactor : 0.0;
        double cpu = this._cpuCostFactor > 0.0 ? pool.getCpuCost() * this._cpuCostFactor : 0.0;
        return space + cpu;
    }
}

