/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PnfsId;
import java.util.Comparator;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.Repository;

class CacheEntryOrder
implements Comparator<PnfsId> {
    private Repository _repository;
    private Comparator<CacheEntry> _comparator;

    public CacheEntryOrder(Repository repository, Comparator<CacheEntry> comparator) {
        this._repository = repository;
        this._comparator = comparator;
    }

    @Override
    public int compare(PnfsId id1, PnfsId id2) {
        try {
            CacheEntry entry1 = this._repository.getEntry(id1);
            CacheEntry entry2 = this._repository.getEntry(id2);
            return this._comparator.compare(entry1, entry2);
        }
        catch (FileNotInCacheException e) {
            return id1.compareTo(id2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread got interupted", e);
        }
        catch (CacheException e) {
            throw new RuntimeException("Repository failed: " + e.getMessage(), e);
        }
    }
}

