/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import dmg.util.Formats;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.classic.StorageClassInfo;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.Repository;

public class StorageClassContainer
extends AbstractCellComponent
implements CellCommandListener {
    private Repository _repository;
    private final Object _storageClassLock = new Object();
    private final String _poolName;
    private final Map<String, StorageClassInfo> _storageClasses = new HashMap<String, StorageClassInfo>();
    private final Map<PnfsId, StorageClassInfo> _pnfsIds = new HashMap<PnfsId, StorageClassInfo>();
    private boolean _poolStatusInfoChanged = true;
    public String hh_queue_activate = "<pnfsId>| class <storageClass>@<hsm>  # move pnfsid from <failed> to active";
    public String hh_queue_deactivate = "<pnfsId>  # move pnfsid from <active> to <failed>";
    public String hh_queue_ls_classes = " [-l}";
    public String hh_queue_ls_queue = " [-l]";
    public String hh_queue_remove_class = "<hsm> <storageClass>";
    public String hh_queue_suspend_class = "<hsm> <storageClass> | *";
    public String hh_queue_resume_class = "<hsm> <storageClass> | *";
    public String hh_define_class = "DEPRICATED";
    public String hh_queue_define_class = "<hsm> <storageClass> [-expire=<expirationTime/sec>] [-total=<maxTotalSize/bytes>] [-pending=<maxPending>] ";
    public String hh_queue_remove_pnfsid = "<pnfsId> # !!!! DANGEROUS";

    public StorageClassContainer(Repository repository, String poolName) {
        this._repository = repository;
        this._poolName = poolName;
    }

    public synchronized Collection<StorageClassInfo> getStorageClassInfos() {
        return new ArrayList<StorageClassInfo>(this._storageClasses.values());
    }

    public synchronized boolean poolStatusChanged() {
        boolean result = this._poolStatusInfoChanged;
        this._poolStatusInfoChanged = false;
        return result;
    }

    public int size() {
        return this._storageClasses.size();
    }

    public int getStorageClassCount() {
        return this._storageClasses.size();
    }

    public int getRequestCount() {
        return this._pnfsIds.size();
    }

    public StorageClassInfo getStorageClassInfoByName(String hsmName, String storageClass) throws NoSuchElementException {
        String composedName = storageClass + "@" + hsmName.toLowerCase();
        StorageClassInfo info = this._storageClasses.get(composedName);
        if (info == null) {
            throw new NoSuchElementException(composedName);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StorageClassInfo defineStorageClass(String hsmName, String storageClass) {
        String composedName = storageClass + "@" + hsmName.toLowerCase();
        Object object = this._storageClassLock;
        synchronized (object) {
            StorageClassInfo info = this._storageClasses.get(composedName);
            if (info == null) {
                info = new StorageClassInfo(hsmName, storageClass);
            }
            info.setDefined(true);
            this._storageClasses.put(composedName, info);
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StorageClassInfo removeStorageClass(String hsmName, String storageClass) {
        Object object = this._storageClassLock;
        synchronized (object) {
            String composedName = storageClass + "@" + hsmName.toLowerCase();
            StorageClassInfo info = this._storageClasses.get(composedName);
            if (info.size() > 0) {
                throw new IllegalArgumentException("Class not empty");
            }
            return this._storageClasses.remove(composedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void suspendStorageClass(String hsmName, String storageClass, boolean suspend) {
        Object object = this._storageClassLock;
        synchronized (object) {
            String composedName = storageClass + "@" + hsmName.toLowerCase();
            StorageClassInfo info = this._storageClasses.get(composedName);
            if (info == null) {
                throw new IllegalArgumentException("class not found : " + composedName);
            }
            info.setSuspended(suspend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void suspendStorageClasses(boolean suspend) {
        Object object = this._storageClassLock;
        synchronized (object) {
            for (StorageClassInfo info : this._storageClasses.values()) {
                info.setSuspended(suspend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeCacheEntry(PnfsId pnfsId) throws CacheException {
        StorageClassInfo info = this._pnfsIds.remove(pnfsId);
        if (info == null) {
            return false;
        }
        boolean removed = info.remove(pnfsId);
        Object object = this._storageClassLock;
        synchronized (object) {
            if (info.size() == 0 && !info.isDefined()) {
                this._storageClasses.remove(info.getName() + "@" + info.getHsm());
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addCacheEntry(PnfsId id) throws CacheException, InterruptedException {
        CacheEntry entry = this._repository.getEntry(id);
        String storageClass = entry.getStorageInfo().getStorageClass();
        String hsmName = entry.getStorageInfo().getHsm().toLowerCase();
        String composedName = storageClass + "@" + hsmName;
        Object object = this._storageClassLock;
        synchronized (object) {
            StorageClassInfo classInfo = this._storageClasses.get(composedName);
            if (classInfo == null) {
                classInfo = new StorageClassInfo(hsmName, storageClass);
                StorageClassInfo tmpInfo = this._storageClasses.get("*@" + hsmName);
                if (tmpInfo != null) {
                    classInfo.setExpiration(tmpInfo.getExpiration());
                    classInfo.setPending(tmpInfo.getPending());
                    classInfo.setMaxSize(tmpInfo.getMaxSize());
                }
                this._storageClasses.put(composedName, classInfo);
            }
            classInfo.add(entry);
            this._pnfsIds.put(entry.getPnfsId(), classInfo);
            return classInfo.size() >= classInfo.getPending();
        }
    }

    @Override
    public void printSetup(PrintWriter pw) {
        for (StorageClassInfo classInfo : this._storageClasses.values()) {
            if (!classInfo.isDefined()) continue;
            pw.println("queue define class " + classInfo.getHsm() + " " + classInfo.getStorageClass() + " -pending=" + classInfo.getPending() + " -total=" + classInfo.getMaxSize() + " -expire=" + classInfo.getExpiration());
        }
    }

    private void dumpClassInfo(StringBuilder sb, StorageClassInfo classInfo) {
        sb.append("                   Name : ").append(classInfo.getName()).append("\n");
        sb.append("              Class@Hsm : ").append(classInfo.getStorageClass()).append("@").append(classInfo.getHsm()).append("\n");
        sb.append(" Exiration rest/defined : ").append(classInfo.expiresIn()).append(" / ").append(classInfo.getExpiration()).append("   seconds\n");
        sb.append(" Pending   rest/defined : ").append(classInfo.size()).append(" / ").append(classInfo.getPending()).append("\n");
        sb.append(" Size      rest/defined : ").append(classInfo.getTotalSize()).append(" / ").append(classInfo.getMaxSize()).append("\n");
        sb.append(" Active Store Procs.    : ").append(classInfo.getActiveCount()).append(classInfo.isSuspended() ? "  SUSPENDED" : "").append("\n");
    }

    public String ac_queue_activate_$_1_2(Args args) throws CacheException {
        if (args.argc() == 1) {
            PnfsId pnfsId = new PnfsId(args.argv(0));
            StorageClassInfo info = this._pnfsIds.get(pnfsId);
            if (info == null) {
                throw new IllegalArgumentException("Not found : " + pnfsId);
            }
            info.activate(pnfsId);
            return "";
        }
        if (!args.argv(0).equals("class")) {
            throw new IllegalArgumentException("queue activate class <storageClass>");
        }
        String className = args.argv(1);
        int pos = className.indexOf("@");
        if (pos <= 0 || pos + 1 == className.length()) {
            throw new IllegalArgumentException("Illegal storage class syntax : class@hsm");
        }
        StorageClassInfo classInfo = this.getStorageClassInfoByName(className.substring(pos + 1), className.substring(0, pos));
        classInfo.activateAll();
        return "";
    }

    public String ac_queue_deactivate_$_1(Args args) throws CacheException {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        StorageClassInfo info = this._pnfsIds.get(pnfsId);
        if (info == null) {
            throw new IllegalArgumentException("Not found : " + pnfsId);
        }
        info.deactivate(pnfsId);
        return "";
    }

    public String ac_queue_ls_classes(Args args) throws CacheException {
        StringBuilder sb = new StringBuilder();
        boolean l = args.hasOption("l");
        for (StorageClassInfo classInfo : this.getStorageClassInfos()) {
            if (l) {
                this.dumpClassInfo(sb, classInfo);
                continue;
            }
            sb.append(classInfo.getStorageClass()).append("@").append(classInfo.getHsm());
            sb.append("  active=").append(classInfo.getActiveCount());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_queue_ls_queue(Args args) throws CacheException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        boolean l = args.hasOption("l");
        try {
            for (StorageClassInfo classInfo : this.getStorageClassInfos()) {
                boolean suspended = classInfo.isSuspended();
                if (l) {
                    this.dumpClassInfo(sb, classInfo);
                } else {
                    sb.append(" Class@Hsm : ").append(classInfo.getStorageClass()).append("@").append(classInfo.getHsm()).append(suspended ? "  SUSPENDED" : "").append("\n");
                }
                for (PnfsId id : classInfo.getRequests()) {
                    try {
                        CacheEntry info = this._repository.getEntry(id);
                        long time = info.getLastAccessTime();
                        StorageInfo sinfo = info.getStorageInfo();
                        String sclass = sinfo.getStorageClass();
                        String hsm = sinfo.getHsm();
                        String cclass = sinfo.getCacheClass();
                        sb.append("  ").append(id).append("  ").append(Formats.field((String)hsm, (int)8, (int)2)).append(Formats.field((String)(sclass == null ? "-" : sclass), (int)20, (int)2)).append(Formats.field((String)(cclass == null ? "-" : cclass), (int)20, (int)2)).append("\n");
                    }
                    catch (FileNotInCacheException e) {}
                }
                boolean headerDone = false;
                for (PnfsId id : classInfo.getFailedRequests()) {
                    try {
                        if (!headerDone) {
                            headerDone = true;
                            sb.append("\n Deactivated Requests\n\n");
                        }
                        CacheEntry info = this._repository.getEntry(id);
                        long time = info.getLastAccessTime();
                        StorageInfo sinfo = info.getStorageInfo();
                        String sclass = sinfo.getStorageClass();
                        String hsm = sinfo.getHsm();
                        String cclass = sinfo.getCacheClass();
                        sb.append("  ").append(id).append("  ").append(Formats.field((String)hsm, (int)8, (int)2)).append(Formats.field((String)(sclass == null ? "-" : sclass), (int)20, (int)2)).append(Formats.field((String)(cclass == null ? "-" : cclass), (int)20, (int)2)).append("\n");
                    }
                    catch (FileNotInCacheException e) {}
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (NullPointerException ee) {
            ee.printStackTrace();
            throw ee;
        }
    }

    public String ac_queue_remove_class_$_2(Args args) throws Exception {
        String hsmName = args.argv(0);
        String className = args.argv(1);
        this.removeStorageClass(hsmName.toLowerCase(), className);
        return "";
    }

    public String ac_queue_suspend_class_$_1_2(Args args) throws Exception {
        if (args.argv(0).equals("*")) {
            this.suspendStorageClasses(true);
        } else {
            String hsmName = args.argv(0);
            String className = args.argv(1);
            this.suspendStorageClass(hsmName.toLowerCase(), className, true);
        }
        return "";
    }

    public String ac_queue_resume_class_$_1_2(Args args) throws Exception {
        if (args.argv(0).equals("*")) {
            this.suspendStorageClasses(false);
        } else {
            String hsmName = args.argv(0);
            String className = args.argv(1);
            this.suspendStorageClass(hsmName.toLowerCase(), className, false);
        }
        return "";
    }

    public String ac_define_class_$_2(Args args) throws Exception {
        return this.ac_queue_define_class_$_2(args);
    }

    public String ac_queue_define_class_$_2(Args args) throws Exception {
        String hsmName = args.argv(0);
        String className = args.argv(1);
        StorageClassInfo info = this.defineStorageClass(hsmName.toLowerCase(), className);
        String tmp = null;
        tmp = args.getOpt("expire");
        if (tmp != null) {
            info.setExpiration(Integer.parseInt(tmp));
        }
        if ((tmp = args.getOpt("pending")) != null) {
            info.setPending(Integer.parseInt(tmp));
        }
        if ((tmp = args.getOpt("total")) != null) {
            info.setMaxSize(Long.parseLong(tmp));
        }
        this._poolStatusInfoChanged = true;
        return info.toString();
    }

    public String ac_queue_remove_pnfsid_$_1(Args args) throws Exception {
        PnfsId pnfsId = new PnfsId(args.argv(0));
        if (!this.removeCacheEntry(pnfsId)) {
            throw new IllegalArgumentException("Not found : " + pnfsId);
        }
        return "Removed : " + pnfsId;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("    Version : $Id: StorageClassContainer.java 16563 2011-11-05 10:43:03Z behrmann $");
        pw.println("   Classes  : " + this.getStorageClassCount());
        pw.println("   Requests : " + this.getRequestCount());
    }
}

