/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import dmg.util.Formats;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.repository.Account;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryChangeEvent;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.SpaceSweeperPolicy;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StateChangeListener;
import org.dcache.pool.repository.StickyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceSweeper2
implements Runnable,
CellCommandListener,
StateChangeListener,
SpaceSweeperPolicy {
    private static final Logger _log = LoggerFactory.getLogger(SpaceSweeper2.class);
    private final SimpleDateFormat __format = new SimpleDateFormat("HH:mm-MM/dd");
    private final Set<PnfsId> _list = new LinkedHashSet<PnfsId>();
    private Repository _repository;
    private Account _account;
    public String hh_sweeper_purge = "# Purges all removable files from pool";
    public String hh_sweeper_free = "<bytesToFree>";
    public String hh_sweeper_ls = " [-l] [-s]";
    public String hh_sweeper_get_lru = "[-f] # return lru in seconds [-f means formatted]";

    public void setRepository(Repository repository) {
        this._repository = repository;
        this._repository.addListener(this);
    }

    public void setAccount(Account account) {
        this._account = account;
        new Thread((Runnable)this, "sweeper").start();
    }

    @Override
    public boolean isRemovable(MetaDataRecord entry) {
        return entry.getState() == EntryState.CACHED && !entry.isSticky();
    }

    private boolean isRemovable(CacheEntry entry) {
        return entry.getState() == EntryState.CACHED && !entry.isSticky();
    }

    private synchronized PnfsId getEldest() {
        if (this._list.size() == 0) {
            return null;
        }
        return this._list.iterator().next();
    }

    @Override
    public long getLru() {
        try {
            PnfsId id = this.getEldest();
            if (id == null) {
                return 0L;
            }
            return this._repository.getEntry(id).getLastAccessTime();
        }
        catch (InterruptedException e) {
            return 0L;
        }
        catch (CacheException e) {
            return 0L;
        }
    }

    private synchronized void add(CacheEntry entry) {
        if (!this.isRemovable(entry)) {
            throw new IllegalArgumentException("Cannot add a precious or un-cached file to the sweeper queue.");
        }
        PnfsId id = entry.getPnfsId();
        if (this._list.add(id)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Added " + id + " to sweeper");
            }
            this.notifyAll();
        }
    }

    private synchronized boolean remove(CacheEntry entry) {
        PnfsId id = entry.getPnfsId();
        if (this._list.remove(id)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Removed " + id + " from sweeper");
            }
            return true;
        }
        return false;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        CacheEntry entry = event.getEntry();
        switch (event.getNewState()) {
            case REMOVED: 
            case DESTROYED: {
                this.remove(entry);
                break;
            }
            default: {
                if (this.isRemovable(entry)) {
                    this.add(entry);
                    break;
                }
                this.remove(entry);
            }
        }
    }

    @Override
    public void stickyChanged(StickyChangeEvent event) {
        CacheEntry entry = event.getEntry();
        if (this.isRemovable(entry)) {
            this.add(entry);
        } else {
            this.remove(entry);
        }
    }

    @Override
    public void accessTimeChanged(EntryChangeEvent event) {
        CacheEntry entry = event.getEntry();
        if (this.remove(entry)) {
            this.add(entry);
        }
    }

    public synchronized String ac_sweeper_purge(Args args) throws Exception {
        final long toFree = this._account.getRemovable();
        new Thread("sweeper-free"){

            @Override
            public void run() {
                try {
                    SpaceSweeper2.this.reclaim(toFree);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return String.format("Reclaiming %d bytes", toFree);
    }

    public synchronized String ac_sweeper_free_$_1(Args args) throws NumberFormatException {
        final long toFree = Long.parseLong(args.argv(0));
        new Thread("sweeper-free"){

            @Override
            public void run() {
                try {
                    SpaceSweeper2.this.reclaim(toFree);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        return String.format("Reclaiming %d bytes", toFree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_sweeper_ls(Args args) throws CacheException, InterruptedException {
        ArrayList<PnfsId> list;
        StringBuilder sb = new StringBuilder();
        boolean l = args.hasOption("l");
        boolean s = args.hasOption("s");
        SpaceSweeper2 spaceSweeper2 = this;
        synchronized (spaceSweeper2) {
            list = new ArrayList<PnfsId>(this._list);
        }
        int i = 0;
        for (PnfsId id : list) {
            try {
                CacheEntry entry = this._repository.getEntry(id);
                if (l) {
                    StorageInfo info;
                    sb.append(Formats.field((String)("" + i), (int)3, (int)4)).append(" ");
                    sb.append(id.toString()).append("  ");
                    sb.append((Object)entry.getState()).append("  ");
                    sb.append(Formats.field((String)("" + entry.getReplicaSize()), (int)11, (int)4));
                    sb.append(" ");
                    sb.append(this.__format.format(new Date(entry.getCreationTime()))).append(" ");
                    sb.append(this.__format.format(new Date(entry.getLastAccessTime()))).append(" ");
                    if (s && (info = entry.getStorageInfo()) != null) {
                        sb.append("\n    ").append(info);
                    }
                    sb.append("\n");
                } else {
                    sb.append(entry.toString()).append("\n");
                }
                ++i;
            }
            catch (FileNotInCacheException e) {}
        }
        return sb.toString();
    }

    private String getTimeString(long secin) {
        int sec = Math.max(0, (int)secin);
        int min = sec / 60;
        int hour = min / 60;
        int day = hour / 24;
        String sS = Integer.toString(sec %= 60);
        String mS = Integer.toString(min %= 60);
        String hS = Integer.toString(hour %= 24);
        StringBuilder sb = new StringBuilder();
        if (day > 0) {
            sb.append(day).append(" d ");
        }
        sb.append(hS.length() < 2 ? "0" + hS : hS).append(":");
        sb.append(mS.length() < 2 ? "0" + mS : mS).append(":");
        sb.append(sS.length() < 2 ? "0" + sS : sS);
        return sb.toString();
    }

    public String ac_sweeper_get_lru(Args args) {
        long lru = (System.currentTimeMillis() - this.getLru()) / 1000L;
        boolean f = args.hasOption("f");
        return f ? this.getTimeString(lru) : "" + lru;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reclaim(long amount) throws InterruptedException {
        PnfsId id;
        ArrayList<CacheEntry> tmpList = new ArrayList<CacheEntry>();
        _log.info(String.format("Sweeper trying to reclaim %d bytes", amount));
        SpaceSweeper2 spaceSweeper2 = this;
        synchronized (spaceSweeper2) {
            Iterator<PnfsId> i = this._list.iterator();
            long minSpaceNeeded = amount;
            while (i.hasNext() && minSpaceNeeded > 0L) {
                id = i.next();
                try {
                    CacheEntry entry = this._repository.getEntry(id);
                    if (entry.getLinkCount() > 0) {
                        _log.warn("file skipped by sweeeper (in use): " + entry);
                        continue;
                    }
                    if (!this.isRemovable(entry)) {
                        _log.error("file skipped by sweeper (not removable): " + entry);
                        continue;
                    }
                    long size = entry.getReplicaSize();
                    tmpList.add(entry);
                    minSpaceNeeded -= size;
                    _log.debug("adds to remove list : " + entry.getPnfsId() + " " + size);
                }
                catch (FileNotInCacheException e) {
                }
                catch (CacheException e) {
                    _log.error(e.getMessage());
                }
            }
        }
        long deleted = 0L;
        for (CacheEntry entry : tmpList) {
            try {
                id = entry.getPnfsId();
                long size = entry.getReplicaSize();
                _log.info("trying to remove " + id);
                this._repository.setState(id, EntryState.REMOVED);
                deleted += size;
            }
            catch (CacheException e) {
                _log.error(e.getMessage());
            }
            catch (IllegalTransitionException e) {
                _log.warn(e.toString());
            }
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForRequests() throws InterruptedException {
        Account account;
        Account account2 = account = this._account;
        synchronized (account2) {
            while (account.getRequested() <= account.getFree() || account.getRemovable() == 0L) {
                account.wait();
            }
            return account.getRequested() - account.getFree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                while (true) {
                    if (this.reclaim(this.waitForRequests()) != 0L) {
                        continue;
                    }
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                this._repository.removeListener(this);
            }
        }
        catch (Throwable throwable) {
            this._repository.removeListener(this);
            throw throwable;
        }
    }
}

