/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.JobScheduler;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.JobInfo;
import dmg.cells.nucleus.CDC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.classic.CompletionHandler;
import org.dcache.pool.classic.IoRequestState;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.classic.MoverExecutorServices;
import org.dcache.pool.classic.PoolIORequest;
import org.dcache.util.AdjustableSemaphore;
import org.dcache.util.FifoPriorityComparator;
import org.dcache.util.IoPrioritizable;
import org.dcache.util.IoPriority;
import org.dcache.util.LifoPriorityComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIoScheduler
implements IoScheduler,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(SimpleIoScheduler.class);
    private final Thread _worker;
    private final String _name;
    private final BlockingQueue<PrioritizedRequest> _queue;
    private final Map<Integer, PrioritizedRequest> _jobs = new ConcurrentHashMap<Integer, PrioritizedRequest>();
    private final int _queueId;
    private int _nextId = 0;
    boolean _shutdown = false;
    private final AdjustableSemaphore _semaphore = new AdjustableSemaphore();
    private final MoverExecutorServices _executorServices;

    public SimpleIoScheduler(String name, MoverExecutorServices executorServices, int queueId) {
        this(name, executorServices, queueId, true);
    }

    public SimpleIoScheduler(String name, MoverExecutorServices executorServices, int queueId, boolean fifo) {
        this._name = name;
        this._executorServices = executorServices;
        this._queueId = queueId;
        Serializable comparator = fifo ? new FifoPriorityComparator() : new LifoPriorityComparator();
        this._queue = new PriorityBlockingQueue<IoPrioritizable>(16, (Comparator<IoPrioritizable>)((Object)comparator));
        this._semaphore.setMaxPermits(2);
        this._worker = new Thread(this);
        this._worker.setName(this._name);
        this._worker.start();
    }

    @Override
    public int add(PoolIORequest request, IoPriority priority) {
        int id = this._queueId << 24 | this.nextId();
        if (this._semaphore.getMaxPermits() <= 0) {
            _log.warn("A task was added to queue '{}', however the queue is not configured to execute any tasks.", (Object)this._name);
        }
        request.setState(IoRequestState.QUEUED);
        PrioritizedRequest wrapper = new PrioritizedRequest(id, request, priority);
        this._queue.add(wrapper);
        this._jobs.put(id, wrapper);
        return id;
    }

    private synchronized int nextId() {
        this._nextId = this._nextId == 0xFFFFFF ? 0 : ++this._nextId;
        return this._nextId;
    }

    @Override
    public int getActiveJobs() {
        return this._semaphore.getUsedPermits();
    }

    @Override
    public JobInfo getJobInfo(int id) {
        PrioritizedRequest pRequest = this._jobs.get(id);
        if (pRequest == null) {
            throw new NoSuchElementException("Job not found : Job-" + id);
        }
        return SimpleIoScheduler.toJobInfo(pRequest.getRequest(), id);
    }

    @Override
    public List<JobInfo> getJobInfos() {
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>();
        for (Map.Entry<Integer, PrioritizedRequest> job : this._jobs.entrySet()) {
            jobs.add(SimpleIoScheduler.toJobInfo(job.getValue().getRequest(), job.getKey()));
        }
        return Collections.unmodifiableList(jobs);
    }

    @Override
    public int getMaxActiveJobs() {
        return this._semaphore.getMaxPermits();
    }

    @Override
    public int getQueueSize() {
        return this._queue.size();
    }

    @Override
    public int getCountByPriority(IoPriority priority) {
        int count = 0;
        for (PrioritizedRequest request : this._queue) {
            if (request.getPriority() != priority) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void cancel(int id) throws NoSuchElementException {
        PrioritizedRequest wrapper = this._jobs.get(id);
        if (wrapper == null) {
            throw new NoSuchElementException("Job " + id + " not found");
        }
        if (this._queue.remove(wrapper)) {
            this._jobs.remove(id);
            PoolIORequest request = wrapper.getRequest();
            request.setState(IoRequestState.DONE);
            request.setTransferStatus(666, "Transfer canceled");
            String protocolName = this.protocolNameOf(request);
            this._executorServices.getPostExecutorService(protocolName).execute(request);
        } else {
            wrapper.getRequest().kill();
        }
    }

    @Override
    public StringBuffer printJobQueue(StringBuffer sb) {
        for (Map.Entry<Integer, PrioritizedRequest> job : this._jobs.entrySet()) {
            sb.append(job.getKey()).append(" : ").append(job.getValue().getRequest()).append('\n');
        }
        return sb;
    }

    @Override
    public void setMaxActiveJobs(int maxJobs) {
        this._semaphore.setMaxPermits(maxJobs);
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._shutdown) {
            try {
                final PrioritizedRequest wrapp = this._queue.take();
                wrapp.getCdc().restore();
                this._semaphore.acquire();
                final PoolIORequest request = wrapp.getRequest();
                final String protocolName = this.protocolNameOf(request);
                request.transfer(this._executorServices.getExecutorService(protocolName), new CompletionHandler(){

                    public void completed(Object result, Object attachment) {
                        this.postProcess();
                    }

                    public void failed(Throwable e, Object attachment) {
                        String msg;
                        int rc;
                        if (e instanceof InterruptedException) {
                            rc = 666;
                            msg = "Transfer was killed";
                        } else if (e instanceof CacheException) {
                            rc = ((CacheException)e).getRc();
                            msg = e.getMessage();
                            if (rc == 204) {
                                request.getFaultListener().faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, msg, e));
                            }
                        } else {
                            rc = 10011;
                            msg = "Transfer failed due to unexpected exception: " + e;
                        }
                        request.setTransferStatus(rc, msg);
                        this.postProcess();
                    }

                    private void postProcess() {
                        SimpleIoScheduler.this._semaphore.release();
                        SimpleIoScheduler.this._jobs.remove(wrapp.getId());
                        request.setState(IoRequestState.DONE);
                        SimpleIoScheduler.this._executorServices.getPostExecutorService(protocolName).execute(request);
                    }
                });
            }
            catch (InterruptedException e) {
                this._shutdown = true;
            }
            finally {
                CDC.clear();
            }
        }
    }

    private String protocolNameOf(PoolIORequest request) {
        return request.getProtocolInfo().getProtocol() + "-" + request.getProtocolInfo().getMajorVersion();
    }

    private static JobInfo toJobInfo(final PoolIORequest request, final int id) {
        IoJobInfo jobInfo = new IoJobInfo(new JobScheduler.Job(){

            @Override
            public long getSubmitTime() {
                return request.getCreationTime();
            }

            @Override
            public long getStartTime() {
                return request.getStartTime();
            }

            @Override
            public String getStatusString() {
                return request.getState().toString();
            }

            @Override
            public Runnable getTarget() {
                return null;
            }

            @Override
            public int getJobId() {
                return id;
            }
        });
        jobInfo.setIoInfo(request.getPnfsId(), request.getBytesTransferred(), request.getTransferTime(), request.getLastTransferred());
        jobInfo.setClient(request.getClient(), request.getClientId());
        return jobInfo;
    }

    private static class PrioritizedRequest
    implements IoPrioritizable {
        private final PoolIORequest _request;
        private final IoPriority _priority;
        private final long _ctime;
        private final int _id;
        private final CDC _cdc;

        PrioritizedRequest(int id, PoolIORequest o, IoPriority p) {
            this._id = id;
            this._request = o;
            this._priority = p;
            this._ctime = System.nanoTime();
            this._cdc = new CDC();
        }

        public PoolIORequest getRequest() {
            return this._request;
        }

        public CDC getCdc() {
            return this._cdc;
        }

        public int getId() {
            return this._id;
        }

        @Override
        public IoPriority getPriority() {
            return this._priority;
        }

        @Override
        public long getCreateTime() {
            return this._ctime;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrioritizedRequest)) {
                return false;
            }
            PrioritizedRequest other = (PrioritizedRequest)o;
            return this._id == other._id;
        }

        public int hashCode() {
            return this._id;
        }
    }
}

