/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.JobInfo;
import org.dcache.pool.classic.IoScheduler;

class SchedulerEntry {
    private final String _name;
    private IoScheduler _scheduler;
    private long _lastAccessed = 0L;
    private long _total = 0L;

    SchedulerEntry(String name) {
        this._name = name;
    }

    String getName() {
        return this._name;
    }

    synchronized void setScheduler(IoScheduler scheduler) {
        this._scheduler = scheduler;
    }

    synchronized IoScheduler getScheduler() {
        return this._scheduler;
    }

    synchronized void setLastAccessed(long lastAccessed) {
        this._lastAccessed = lastAccessed;
    }

    synchronized long getLastAccessed() {
        return this._lastAccessed;
    }

    synchronized void setTotal(long total) {
        this._total = total;
    }

    synchronized long getTotal() {
        return this._total;
    }

    synchronized boolean isExpired(JobInfo job, long now) {
        long started = job.getStartTime();
        long lastAccessed = job instanceof IoJobInfo ? ((IoJobInfo)job).getLastTransferred() : now;
        int jobId = (int)job.getJobId();
        return this.getLastAccessed() > 0L && lastAccessed > 0L && now - lastAccessed > this.getLastAccessed() || this.getTotal() > 0L && started > 0L && now - started > this.getTotal();
    }
}

