/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.pools.PoolV2Mode;
import diskCacheV111.repository.CacheRepositoryEntryInfo;
import diskCacheV111.repository.RepositoryCookie;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.HsmSet;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.UnitInteger;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.JobInfo;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.Pool2PoolTransferMsg;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolCheckFreeSpaceMessage;
import diskCacheV111.vehicles.PoolCheckable;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import diskCacheV111.vehicles.PoolFetchFileMessage;
import diskCacheV111.vehicles.PoolFileCheckable;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import diskCacheV111.vehicles.PoolMgrReplicateFileMsg;
import diskCacheV111.vehicles.PoolModifyModeMessage;
import diskCacheV111.vehicles.PoolModifyPersistencyMessage;
import diskCacheV111.vehicles.PoolMoverKillMessage;
import diskCacheV111.vehicles.PoolQueryRepositoryMsg;
import diskCacheV111.vehicles.PoolRemoveFilesFromHSMMessage;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import diskCacheV111.vehicles.PoolSetStickyMessage;
import diskCacheV111.vehicles.PoolUpdateCacheStatisticsMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.RemoveFileInfoMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CommandSyntaxException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.ChecksumModuleV1;
import org.dcache.pool.classic.HsmFlushController;
import org.dcache.pool.classic.HsmStorageHandler2;
import org.dcache.pool.classic.IoQueueManager;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.classic.JobTimeoutManager;
import org.dcache.pool.classic.PoolIOReadTransfer;
import org.dcache.pool.classic.PoolIORequest;
import org.dcache.pool.classic.PoolIOTransfer;
import org.dcache.pool.classic.PoolIOWriteTransfer;
import org.dcache.pool.classic.ReplicaStatePolicy;
import org.dcache.pool.classic.StorageClassContainer;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.p2p.P2PClient;
import org.dcache.pool.repository.AbstractStateChangeListener;
import org.dcache.pool.repository.Account;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.SpaceRecord;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.dcache.util.IoPriority;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolV4
extends AbstractCellComponent
implements FaultListener,
CellCommandListener,
CellMessageReceiver {
    private static final int DUP_REQ_NONE = 0;
    private static final int DUP_REQ_IGNORE = 1;
    private static final int DUP_REQ_REFRESH = 2;
    private static final int P2P_CACHED = 1;
    private static final int P2P_PRECIOUS = 2;
    private static final Pattern TAG_PATTERN = Pattern.compile("([^=]+)=(\\S*)\\s*");
    private static final String P2P_QUEUE_NAME = "p2p";
    private static final Logger _log = LoggerFactory.getLogger(PoolV4.class);
    private final String _poolName;
    private final Map<String, Class<?>> _moverHash = new ConcurrentHashMap();
    private final long _serialId = System.currentTimeMillis();
    private PoolV2Mode _poolMode;
    private boolean _reportOnRemovals = false;
    private boolean _suppressHsmLoad = false;
    private boolean _cleanPreciousFiles = false;
    private String _poolStatusMessage = "OK";
    private int _poolStatusCode = 0;
    private PnfsHandler _pnfs;
    private StorageClassContainer _storageQueue;
    private CacheRepositoryV5 _repository;
    private Account _account;
    private String _poolupDestination = "PoolManager";
    private int _version = 4;
    private CellPath _billingCell = new CellPath("billing");
    private final Map<String, String> _tags = new HashMap<String, String>();
    private String _baseDir;
    private final PoolManagerPingThread _pingThread;
    private HsmFlushController _flushingThread;
    private IoQueueManager _ioQueue;
    private JobTimeoutManager _timeoutManager;
    private HsmSet _hsmSet;
    private HsmStorageHandler2 _storageHandler;
    private boolean _crashEnabled = false;
    private String _crashType = "exception";
    private long _gap = 0x100000000L;
    private int _p2pFileMode = 1;
    private int _dupRequest = 1;
    private P2PClient _p2pClient = null;
    private boolean _isVolatile = false;
    private boolean _hasTapeBackend = true;
    private int _cleaningInterval = 60;
    private final Object _hybridInventoryLock = new Object();
    private boolean _hybridInventoryActive = false;
    private int _hybridCurrent = 0;
    private ChecksumModuleV1 _checksumModule;
    private ReplicationHandler _replicationHandler = new ReplicationHandler();
    private ReplicaStatePolicy _replicaStatePolicy;
    private boolean _running = false;
    private double _breakEven = 0.7;
    private double _moverCostFactor = 0.5;
    private Map<String, Class<?>> _handlerClasses = new Hashtable();
    public static final String hh_set_breakeven = "[<breakEven>] # free and recoverable space";
    public static final String hh_set_mover_cost_factor = "[<factor>]";
    public static final String fh_set_mover_cost_factor = "The mover cost factor controls how much the number of moversaffects proportional pool selection.\n\nIntuitively, for every 1/f movers, where f is the mover costfactor, the probability of choosing this pools is halfed. Whenset to zero, the number of movers does not affect pool selection.";
    public String hh_pnfs_register = " # add entry of all files into pnfs";
    public String hh_pnfs_unregister = " # remove entry of all files from pnfs";
    public String hh_run_hybrid_inventory = " [-destroy]";
    public String hh_pf = "<pnfsId>";
    public String hh_set_replication = "off|on|<mgr>,<host>,<destMode>";
    public String hh_pool_suppress_hsmload = "on|off";
    public String hh_movermap_define = "<protocol>-<major> <moverClassName>";
    public String hh_movermap_undefine = "<protocol>-<major>";
    public String hh_movermap_ls = "";
    public String hh_set_duplicate_request = "none|ignore|refresh";
    public String hh_set_p2p = "integrated|separated; OBSOLETE";
    public String fh_pool_disable = "   pool disable [options] [ <errorCode> [<errorMessage>]]\n      OPTIONS :\n        -fetch    #  disallows fetch (transfer to client)\n        -stage    #  disallows staging (from HSM)\n        -store    #  disallows store (transfer from client)\n        -p2p-client\n        -rdonly   #  := store,stage,p2p-client\n        -strict   #  := disallows everything\n";
    public String hh_pool_disable = "[options] [<errorCode> [<errorMessage>]] # suspend sending 'up messages'";
    public String hh_pool_enable = " # resume sending up messages'";
    public String hh_set_max_movers = "!!! Please use 'mover|st|rh set max active <jobs>'";
    public String hh_set_gap = "<always removable gap>/size[<unit>] # unit = k|m|g";
    public String hh_set_report_remove = "on|off";
    public String hh_crash = "disabled|shutdown|exception";
    public String hh_set_sticky = "# Deprecated";
    public String hh_set_cleaning_interval = "<interval/sec>";
    public String hh_flush_class = "<hsm> <storageClass> [-count=<count>]";
    public String hh_flush_pnfsid = "<pnfsid> # flushs a single pnfsid";
    public String hh_mover_set_max_active = "<maxActiveIoMovers> -queue=<queueName>";
    public String hh_mover_queue_ls = "";
    public String hh_mover_ls = "[-binary [jobId] ]";
    public String hh_mover_remove = "<jobId>";
    public String hh_mover_kill = "<jobId> [-force]";
    public String hh_p2p_set_max_active = "<maxActiveIoMovers>";
    public String hh_p2p_ls = "[-binary [jobId] ]";
    public String hh_p2p_remove = "<jobId>; OBSOLETE: use: mover remove -queue=p2p";
    public String hh_p2p_kill = "<jobId> [-force]; OBSOLETE: use: mover kill -queue=p2p";
    public String hh_set_heartbeat = "<heartbeatInterval/sec>";

    public PoolV4(String poolName, String args) {
        this._poolName = poolName;
        _log.info("Pool " + poolName + " starting");
        this._pingThread = new PoolManagerPingThread();
    }

    protected void assertNotRunning(String error) {
        if (this._running) {
            throw new IllegalStateException(error);
        }
    }

    public void setBaseDir(String baseDir) {
        this.assertNotRunning("Cannot change base dir after initialisation");
        this._baseDir = baseDir;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public void setReplicateOnArrival(String replicate) {
        this._replicationHandler.init(replicate.equals("") ? "on" : replicate);
    }

    public void setAllowCleaningPreciousFiles(boolean allow) {
        this._cleanPreciousFiles = allow;
    }

    public void setVolatile(boolean isVolatile) {
        this._isVolatile = isVolatile;
    }

    public boolean isVolatile() {
        return this._isVolatile;
    }

    public void setHasTapeBackend(boolean hasTapeBackend) {
        this._hasTapeBackend = hasTapeBackend;
    }

    public boolean getHasTapeBackend() {
        return this._hasTapeBackend;
    }

    public void setP2PMode(String mode) {
        if (mode == null) {
            this._p2pFileMode = 1;
        } else if (mode.equals("precious")) {
            this._p2pFileMode = 2;
        } else if (mode.equals("cached")) {
            this._p2pFileMode = 1;
        } else {
            throw new IllegalArgumentException("p2p=precious|cached");
        }
    }

    public void setDuplicateRequestMode(String mode) {
        if (mode == null || mode.equals("none")) {
            this._dupRequest = 0;
        } else if (mode.equals("ignore")) {
            this._dupRequest = 1;
        } else if (mode.equals("refresh")) {
            this._dupRequest = 2;
        } else {
            throw new IllegalArgumentException("Illegal 'dupRequest' value");
        }
    }

    public void setPoolUpDestination(String name) {
        this._poolupDestination = name;
    }

    public void setBillingCellName(String name) {
        this._billingCell = new CellPath(name);
    }

    public void setPnfsHandler(PnfsHandler pnfs) {
        this._pnfs = pnfs;
    }

    public void setRepository(CacheRepositoryV5 repository) {
        if (this._repository != null) {
            this._repository.removeFaultListener(this);
        }
        this._repository = repository;
        this._repository.addFaultListener(this);
        this._repository.addListener(new RepositoryLoader());
        this._repository.addListener(new NotifyBillingOnRemoveListener());
        this._repository.addListener(new HFlagMaintainer());
        this._repository.addListener(this._replicationHandler);
    }

    public void setAccount(Account account) {
        this._account = account;
    }

    public void setChecksumModule(ChecksumModuleV1 module) {
        this.assertNotRunning("Cannot set checksum module after initialization");
        this._checksumModule = module;
    }

    public void setStorageQueue(StorageClassContainer queue) {
        this.assertNotRunning("Cannot set storage queue after initialization");
        this._storageQueue = queue;
    }

    public void setStorageHandler(HsmStorageHandler2 handler) {
        this._storageHandler = handler;
    }

    public void setHSMSet(HsmSet set) {
        this.assertNotRunning("Cannot set HSM set after initialization");
        this._hsmSet = set;
    }

    public void setTimeoutManager(JobTimeoutManager manager) {
        this.assertNotRunning("Cannot set timeout manager after initialization");
        this._timeoutManager = manager;
        this._timeoutManager.start();
    }

    public void setFlushController(HsmFlushController controller) {
        this.assertNotRunning("Cannot set flushing controller after initialization");
        this._flushingThread = controller;
    }

    public void setPPClient(P2PClient client) {
        this.assertNotRunning("Cannot set P2P client after initialization");
        this._p2pClient = client;
    }

    public void setReplicaStatePolicy(ReplicaStatePolicy replicaStatePolicy) {
        this._replicaStatePolicy = replicaStatePolicy;
    }

    public void setTags(String tags) {
        HashMap<String, String> newTags = new HashMap<String, String>();
        Matcher matcher = TAG_PATTERN.matcher(tags);
        while (matcher.lookingAt()) {
            String tag = matcher.group(1);
            String value = matcher.group(2);
            newTags.put(tag, value);
            matcher.region(matcher.end(), matcher.regionEnd());
        }
        if (matcher.regionStart() != matcher.regionEnd()) {
            String msg = "Cannot parse '" + tags.substring(matcher.regionStart()) + "'";
            throw new IllegalArgumentException(msg);
        }
        for (Map.Entry e : newTags.entrySet()) {
            this._tags.put((String)e.getKey(), (String)e.getValue());
            _log.info("Tag: " + (String)e.getKey() + "=" + (String)e.getValue());
        }
    }

    public void setIoQueueManager(IoQueueManager ioQueueManager) {
        this._ioQueue = ioQueueManager;
    }

    public void setPoolMode(PoolV2Mode mode) {
        this._poolMode = mode;
    }

    public void init() {
        assert (this._baseDir != null) : "Base directory must be set";
        assert (this._pnfs != null) : "PNFS handler must be set";
        assert (this._repository != null) : "Repository must be set";
        assert (this._checksumModule != null) : "Checksum module must be set";
        assert (this._storageQueue != null) : "Storage queue must be set";
        assert (this._storageHandler != null) : "Storage handler must be set";
        assert (this._hsmSet != null) : "HSM set must be set";
        assert (this._timeoutManager != null) : "Timeout manager must be set";
        assert (this._flushingThread != null) : "Flush controller must be set";
        assert (this._p2pClient != null) : "P2P client must be set";
        assert (this._account != null) : "Account must be set";
        if (this._isVolatile && this._hasTapeBackend) {
            throw new IllegalStateException("Volatile pool cannot have a tape backend");
        }
        this.disablePool(63, 1, "Initializing");
        this._pingThread.start();
    }

    @Override
    public void afterStart() {
        this.assertNotRunning("Cannot initialize several times");
        this._running = true;
        new Thread(){

            @Override
            public void run() {
                try {
                    PoolV4.this._repository.init();
                    PoolV4.this.disablePool(29, 1, "Initializing");
                    PoolV4.this._repository.load();
                    PoolV4.this.enablePool();
                    PoolV4.this._flushingThread.start();
                }
                catch (Throwable e) {
                    _log.error("Repository reported a problem : " + e.getMessage());
                    _log.warn("Pool not enabled " + PoolV4.this._poolName);
                    PoolV4.this.disablePool(127, 666, "Init failed: " + e.getMessage());
                }
                _log.info("Repository finished");
            }
        }.start();
    }

    @Override
    public void beforeStop() {
        this.disablePool(127, 666, "Shutdown");
    }

    public void cleanUp() {
        this._ioQueue.shutdown();
    }

    @Override
    public void faultOccurred(FaultEvent event) {
        Throwable cause = event.getCause();
        if (cause != null) {
            _log.error("Fault occured in " + event.getSource() + ": " + event.getMessage(), cause);
        } else {
            _log.error("Fault occured in " + event.getSource() + ": " + event.getMessage());
        }
        switch (event.getAction()) {
            case READONLY: {
                this.disablePool(29, 99, "Pool read-only: " + event.getMessage());
                break;
            }
            case DISABLED: {
                this.disablePool(63, 99, "Pool disabled: " + event.getMessage());
                break;
            }
            default: {
                this.disablePool(127, 666, "Pool disabled: " + event.getMessage());
            }
        }
    }

    public CellVersion getCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 17678 $");
    }

    @Override
    public void printSetup(PrintWriter pw) {
        pw.println("set heartbeat " + this._pingThread.getHeartbeat());
        pw.println("set report remove " + (this._reportOnRemovals ? "on" : "off"));
        pw.println("set breakeven " + this._breakEven);
        pw.println("set mover cost factor " + this._moverCostFactor);
        if (this._suppressHsmLoad) {
            pw.println("pool suppress hsmload on");
        }
        pw.println("set gap " + this._gap);
        pw.println("set duplicate request " + (this._dupRequest == 0 ? "none" : (this._dupRequest == 1 ? "ignore" : "refresh")));
        this._ioQueue.printSetup(pw);
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        PoolCellInfo poolinfo = new PoolCellInfo(info);
        poolinfo.setPoolCostInfo(this.getPoolCostInfo());
        poolinfo.setTagMap(this._tags);
        poolinfo.setErrorStatus(this._poolStatusCode, this._poolStatusMessage);
        poolinfo.setCellVersion(this.getCellVersion());
        return poolinfo;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Base directory    : " + this._baseDir);
        pw.println("Revision          : [$Revision: 17678 $]");
        pw.println("Version           : " + this.getCellVersion() + " (Sub=" + this._version + ")");
        pw.println("Gap               : " + this._gap);
        pw.println("Report remove     : " + (this._reportOnRemovals ? "on" : "off"));
        pw.println("Pool Mode         : " + this._poolMode);
        if (this._poolMode.isDisabled()) {
            pw.println("Detail            : [" + this._poolStatusCode + "] " + this._poolStatusMessage);
        }
        pw.println("Clean prec. files : " + (this._cleanPreciousFiles ? "on" : "off"));
        pw.println("Hsm Load Suppr.   : " + (this._suppressHsmLoad ? "on" : "off"));
        pw.println("Ping Heartbeat    : " + this._pingThread.getHeartbeat() + " seconds");
        pw.println("ReplicationMgr    : " + this._replicationHandler);
        if (this._hasTapeBackend) {
            pw.println("LargeFileStore    : None");
        } else if (this._isVolatile) {
            pw.println("LargeFileStore    : Volatile");
        } else {
            pw.println("LargeFileStore    : Precious");
        }
        pw.println("DuplicateRequests : " + (this._dupRequest == 0 ? "None" : (this._dupRequest == 1 ? "Ignored" : "Refreshed")));
        pw.println("P2P File Mode     : " + (this._p2pFileMode == 2 ? "Precious" : "Cached"));
        if (this._hybridInventoryActive) {
            pw.println("Inventory         : " + this._hybridCurrent);
        }
        for (IoScheduler js : this._ioQueue.getSchedulers()) {
            pw.println("Mover Queue (" + js.getName() + ") " + js.getActiveJobs() + "(" + js.getMaxActiveJobs() + ")/" + js.getQueueSize());
        }
    }

    private int queueIoRequest(PoolIoFileMessage message, PoolIORequest request) throws InvocationTargetException {
        String queueName = message.getIoQueueName();
        if (message instanceof PoolAcceptFileMessage) {
            return this._ioQueue.add(queueName, request, IoPriority.HIGH);
        }
        if (message.isPool2Pool()) {
            return this._ioQueue.add(P2P_QUEUE_NAME, request, IoPriority.HIGH);
        }
        return this._ioQueue.add(queueName, request, IoPriority.REGULAR);
    }

    private void ioFile(CellMessage envelope, PoolIoFileMessage message) {
        PnfsId pnfsId = message.getPnfsId();
        try {
            PoolIOTransfer transfer;
            MoverProtocol mover;
            JobInfo job;
            long id = message.getId();
            ProtocolInfo pi = message.getProtocolInfo();
            Subject subject = message.getSubject();
            StorageInfo si = message.getStorageInfo();
            String initiator = message.getInitiator();
            String pool = message.getPoolName();
            String queueName = message.getIoQueueName();
            CellPath source = (CellPath)envelope.getSourcePath().clone();
            String door = source.getCellName() + "@" + source.getCellDomainName();
            if (!(message instanceof PoolAcceptFileMessage) && !message.isPool2Pool() && (job = this._ioQueue.findJob(door, id)) != null) {
                switch (this._dupRequest) {
                    case 0: {
                        _log.info("Dup Request : none <" + door + ":" + id + ">");
                        break;
                    }
                    case 1: {
                        _log.info("Dup Request : ignoring <" + door + ":" + id + ">");
                        return;
                    }
                    case 2: {
                        long jobId = job.getJobId();
                        _log.info("Dup Request : refresing <" + door + ":" + id + "> old = " + jobId);
                        this._ioQueue.cancel((int)jobId);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Dup Request : PANIC (code corrupted) <" + door + ":" + id + ">");
                    }
                }
            }
            if ((mover = this.getProtocolHandler(pi)) == null) {
                throw new CacheException(27, "PANIC : Could not get handler for " + pi);
            }
            if (message instanceof PoolAcceptFileMessage) {
                List<StickyRecord> stickyRecords = this._replicaStatePolicy.getStickyRecords(si);
                EntryState targetState = this._replicaStatePolicy.getTargetState(si);
                transfer = new PoolIOWriteTransfer(pnfsId, pi, subject, si, mover, this._repository, this._checksumModule, targetState, stickyRecords);
            } else {
                transfer = new PoolIOReadTransfer(pnfsId, pi, subject, si, mover, this._repository);
            }
            try {
                source.revert();
                PoolIORequest request = new PoolIORequest(transfer, id, initiator, source, pool, queueName, this.getCellEndpoint(), this._billingCell, this);
                message.setMoverId(this.queueIoRequest(message, request));
                transfer = null;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                if (transfer != null) {
                    try {
                        transfer.close();
                    }
                    catch (NoRouteToCellException e) {
                        _log.error("Communication failure while closing entry: " + e.getMessage());
                    }
                    catch (IOException e) {
                        _log.error("IO error while closing entry: " + e.getMessage());
                    }
                    catch (InterruptedException e) {
                        _log.error("Interrupted while closing entry: " + e.getMessage());
                    }
                }
            }
            message.setSucceeded();
        }
        catch (FileInCacheException e) {
            _log.warn("Pool already contains replica");
            message.setFailed(e.getRc(), "Pool already contains " + pnfsId);
        }
        catch (FileNotInCacheException e) {
            _log.warn("Pool does not contain replica");
            message.setFailed(e.getRc(), "Pool does not contain " + pnfsId);
        }
        catch (CacheException e) {
            _log.error(e.getMessage());
            message.setFailed(e.getRc(), e.getMessage());
        }
        catch (Throwable e) {
            _log.error("Possible bug found: " + e.getMessage(), e);
            message.setFailed(666, "Failed to enqueue mover: " + e.getMessage());
        }
        try {
            envelope.revertDirection();
            this.sendMessage(envelope);
        }
        catch (NoRouteToCellException e) {
            _log.error(e.toString());
        }
    }

    private MoverProtocol getProtocolHandler(ProtocolInfo info) {
        Class[] argsClass = new Class[]{CellEndpoint.class};
        String moverClassName = info.getProtocol() + "-" + info.getMajorVersion();
        Class<?> mover = this._moverHash.get(moverClassName);
        try {
            if (mover == null && (mover = this._handlerClasses.get(moverClassName = "org.dcache.pool.movers." + info.getProtocol() + "Protocol_" + info.getMajorVersion())) == null) {
                mover = Class.forName(moverClassName);
                this._handlerClasses.put(moverClassName, mover);
            }
            Constructor<?> moverCon = mover.getConstructor(argsClass);
            Object[] args = new Object[]{this.getCellEndpoint()};
            return (MoverProtocol)moverCon.newInstance(args);
        }
        catch (Exception e) {
            _log.error("Could not create mover for " + moverClassName, (Throwable)e);
            return null;
        }
    }

    private void checkFile(PoolFileCheckable poolMessage) throws CacheException, InterruptedException {
        PnfsId id = poolMessage.getPnfsId();
        switch (this._repository.getState(id)) {
            case PRECIOUS: 
            case CACHED: {
                poolMessage.setHave(true);
                poolMessage.setWaiting(false);
                break;
            }
            case FROM_CLIENT: 
            case FROM_STORE: 
            case FROM_POOL: {
                poolMessage.setHave(false);
                poolMessage.setWaiting(true);
                break;
            }
            case BROKEN: {
                throw new CacheException(666, id.toString() + " is broken in " + this._poolName);
            }
            default: {
                poolMessage.setHave(false);
                poolMessage.setWaiting(false);
            }
        }
    }

    public PoolMoverKillMessage messageArrived(PoolMoverKillMessage kill) {
        if (kill.isReply()) {
            return null;
        }
        try {
            int id = kill.getMoverId();
            IoScheduler js = this._ioQueue.getQueueByJobId(id);
            this.mover_kill(js, id, false);
            kill.setSucceeded();
        }
        catch (NoSuchElementException e) {
            _log.info(e.toString());
            kill.setReply(1, e);
        }
        return kill;
    }

    public void messageArrived(CellMessage envelope, PoolIoFileMessage msg) throws CacheException {
        if (msg.isReply()) {
            return;
        }
        if (msg instanceof PoolAcceptFileMessage && this._poolMode.isDisabled(4) || msg instanceof PoolDeliverFileMessage && this._poolMode.isDisabled(2)) {
            _log.warn("PoolIoFileMessage request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        msg.setReply();
        this.ioFile(envelope, msg);
    }

    public DelayedReply messageArrived(Pool2PoolTransferMsg msg) throws CacheException, IOException, InterruptedException {
        if (this._poolMode.isDisabled(16)) {
            _log.warn("Pool2PoolTransferMsg request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        String poolName = msg.getPoolName();
        PnfsId pnfsId = msg.getPnfsId();
        StorageInfo storageInfo = msg.getStorageInfo();
        CompanionFileAvailableCallback callback = new CompanionFileAvailableCallback(msg);
        EntryState targetState = EntryState.CACHED;
        int fileMode = msg.getDestinationFileStatus();
        if (fileMode != 0) {
            if (fileMode == 1) {
                targetState = EntryState.PRECIOUS;
            }
        } else if (!this._hasTapeBackend && !this._isVolatile && this._p2pFileMode == 2) {
            targetState = EntryState.PRECIOUS;
        }
        List<StickyRecord> stickyRecords = Collections.emptyList();
        this._p2pClient.newCompanion(pnfsId, poolName, storageInfo, targetState, stickyRecords, callback);
        return callback;
    }

    public Object messageArrived(PoolFetchFileMessage msg) throws CacheException {
        if (this._poolMode.isDisabled(8)) {
            _log.warn("PoolFetchFileMessage request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        if (!this._hasTapeBackend) {
            _log.warn("PoolFetchFileMessage request rejected due to LFS mode");
            throw new CacheException(104, "Pool has no tape backend");
        }
        PnfsId pnfsId = msg.getPnfsId();
        StorageInfo storageInfo = msg.getStorageInfo();
        _log.info("Pool " + this._poolName + " asked to fetch file " + pnfsId + " (hsm=" + storageInfo.getHsm() + ")");
        try {
            ReplyToPoolFetch reply = new ReplyToPoolFetch(msg);
            this._storageHandler.fetch(pnfsId, storageInfo, reply);
            return reply;
        }
        catch (FileInCacheException e) {
            _log.warn("Pool already contains replica");
            msg.setSucceeded();
            return msg;
        }
        catch (CacheException e) {
            _log.error(e.toString());
            if (e.getRc() == 204) {
                this.disablePool(63, e.getRc(), e.getMessage());
            }
            throw e;
        }
    }

    public void messageArrived(CellMessage envelope, PoolRemoveFilesFromHSMMessage msg) throws CacheException {
        if (this._poolMode.isDisabled(8)) {
            _log.warn("PoolRemoveFilesFromHsmMessage request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        if (!this._hasTapeBackend) {
            _log.warn("PoolRemoveFilesFromHsmMessage request rejected due to LFS mode");
            throw new CacheException(104, "Pool has no tape backend");
        }
        this._storageHandler.remove(envelope);
    }

    public PoolCheckFreeSpaceMessage messageArrived(PoolCheckFreeSpaceMessage msg) throws CacheException {
        msg.setFreeSpace(this._account.getFree());
        msg.setSucceeded();
        return msg;
    }

    public Message messageArrived(Message msg) throws CacheException, InterruptedException {
        if (msg instanceof PoolCheckable) {
            if (msg instanceof PoolFileCheckable) {
                this.checkFile((PoolFileCheckable)((Object)msg));
            }
            msg.setSucceeded();
            return msg;
        }
        return null;
    }

    public PoolUpdateCacheStatisticsMessage messageArrived(PoolUpdateCacheStatisticsMessage msg) {
        msg.setSucceeded();
        return msg;
    }

    public PoolRemoveFilesMessage messageArrived(PoolRemoveFilesMessage msg) throws CacheException, InterruptedException {
        if (this._poolMode.isDisabled(1)) {
            _log.warn("PoolRemoveFilesMessage request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        String[] fileList = msg.getFiles();
        int counter = 0;
        for (int i = 0; i < fileList.length; ++i) {
            try {
                PnfsId pnfsId = new PnfsId(fileList[i]);
                if (!this._cleanPreciousFiles && this._hasTapeBackend && this._repository.getState(pnfsId) == EntryState.PRECIOUS) {
                    ++counter;
                    _log.error("Replica " + fileList[i] + " kept (precious)");
                    continue;
                }
                this._repository.setState(pnfsId, EntryState.REMOVED);
                fileList[i] = null;
                continue;
            }
            catch (IllegalTransitionException e) {
                _log.error("Replica " + fileList[i] + " not removed: " + e.getMessage());
                ++counter;
                continue;
            }
            catch (IllegalArgumentException e) {
                _log.error("Invalid syntax in remove request (" + fileList[i] + ")");
                ++counter;
            }
        }
        if (counter > 0) {
            String[] replyList = new String[counter];
            int j = 0;
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i] == null) continue;
                replyList[j++] = fileList[i];
            }
            msg.setFailed(1, replyList);
        } else {
            msg.setSucceeded();
        }
        return msg;
    }

    public PoolModifyPersistencyMessage messageArrived(PoolModifyPersistencyMessage msg) {
        try {
            PnfsId pnfsId = msg.getPnfsId();
            switch (this._repository.getState(pnfsId)) {
                case PRECIOUS: {
                    if (msg.isCached()) {
                        this._repository.setState(pnfsId, EntryState.CACHED);
                    }
                    msg.setSucceeded();
                    break;
                }
                case CACHED: {
                    if (msg.isPrecious()) {
                        this._repository.setState(pnfsId, EntryState.PRECIOUS);
                    }
                    msg.setSucceeded();
                    break;
                }
                case FROM_CLIENT: 
                case FROM_STORE: 
                case FROM_POOL: {
                    msg.setFailed(101, "File still transient: " + pnfsId);
                    break;
                }
                case BROKEN: {
                    msg.setFailed(101, "File is broken: " + pnfsId);
                    break;
                }
                case NEW: 
                case REMOVED: 
                case DESTROYED: {
                    msg.setFailed(101, "File does not exist: " + pnfsId);
                }
            }
        }
        catch (Exception e) {
            msg.setFailed(100, e);
        }
        return msg;
    }

    public PoolModifyModeMessage messageArrived(PoolModifyModeMessage msg) {
        PoolV2Mode mode = msg.getPoolMode();
        if (mode != null) {
            if (mode.isEnabled()) {
                this.enablePool();
            } else {
                this.disablePool(mode.getMode(), msg.getStatusCode(), msg.getStatusMessage());
            }
        }
        msg.setSucceeded();
        return msg;
    }

    public PoolSetStickyMessage messageArrived(PoolSetStickyMessage msg) throws CacheException, InterruptedException {
        if (this._poolMode.isDisabled(63)) {
            _log.warn("PoolSetStickyMessage request rejected due to " + this._poolMode);
            throw new CacheException(104, "Pool is disabled");
        }
        this._repository.setSticky(msg.getPnfsId(), msg.getOwner(), msg.isSticky() ? msg.getLifeTime() : 0L, true);
        msg.setSucceeded();
        return msg;
    }

    public PoolQueryRepositoryMsg messageArrived(PoolQueryRepositoryMsg msg) throws CacheException, InterruptedException {
        msg.setReply(new RepositoryCookie(), this.getRepositoryListing());
        return msg;
    }

    private List<CacheRepositoryEntryInfo> getRepositoryListing() throws CacheException, InterruptedException {
        ArrayList<CacheRepositoryEntryInfo> listing = new ArrayList<CacheRepositoryEntryInfo>();
        for (PnfsId pnfsid : this._repository) {
            try {
                switch (this._repository.getState(pnfsid)) {
                    case PRECIOUS: 
                    case CACHED: 
                    case BROKEN: {
                        listing.add(new CacheRepositoryEntryInfo(this._repository.getEntry(pnfsid)));
                        break;
                    }
                }
            }
            catch (FileNotInCacheException e) {}
        }
        return listing;
    }

    private synchronized void disablePool(int mode, int errorCode, String errorString) {
        this._poolStatusCode = errorCode;
        this._poolStatusMessage = errorString == null ? "Requested by operator" : errorString;
        this._poolMode.setMode(mode);
        this._pingThread.sendPoolManagerMessage(true);
        _log.warn("Pool mode changed to {}: {}", (Object)this._poolMode, (Object)this._poolStatusMessage);
    }

    private synchronized void enablePool() {
        this._poolMode.setMode(0);
        this._poolStatusCode = 0;
        this._poolStatusMessage = "OK";
        this._pingThread.sendPoolManagerMessage(true);
        _log.warn("Pool mode changed to " + this._poolMode);
    }

    private PoolCostInfo getPoolCostInfo() {
        PoolCostInfo info = new PoolCostInfo(this._poolName);
        SpaceRecord space = this._repository.getSpaceRecord();
        info.setSpaceUsage(space.getTotalSpace(), space.getFreeSpace(), space.getPreciousSpace(), space.getRemovableSpace(), space.getLRU());
        info.getSpaceInfo().setParameter(this._breakEven, this._gap);
        info.setMoverCostFactor(this._moverCostFactor);
        for (IoScheduler js : this._ioQueue.getSchedulers()) {
            if (js.getName().equals(P2P_QUEUE_NAME)) continue;
            info.addExtendedMoverQueueSizes(js.getName(), js.getActiveJobs(), js.getMaxActiveJobs(), js.getQueueSize(), js.getCountByPriority(IoPriority.REGULAR), js.getCountByPriority(IoPriority.HIGH));
        }
        info.setP2pClientQueueSizes(this._p2pClient.getActiveJobs(), this._p2pClient.getMaxActiveJobs(), this._p2pClient.getQueueSize());
        IoScheduler p2pQueue = this._ioQueue.getQueue(P2P_QUEUE_NAME);
        info.setP2pServerQueueSizes(p2pQueue.getActiveJobs(), p2pQueue.getMaxActiveJobs(), p2pQueue.getQueueSize());
        info.setQueueSizes(this._ioQueue.getActiveJobs() - p2pQueue.getActiveJobs(), this._ioQueue.getMaxActiveJobs() - p2pQueue.getMaxActiveJobs(), this._ioQueue.getQueueSize() - p2pQueue.getQueueSize(), this._storageHandler.getFetchScheduler().getActiveJobs(), this._suppressHsmLoad ? 0 : this._storageHandler.getFetchScheduler().getMaxActiveJobs(), this._storageHandler.getFetchScheduler().getQueueSize(), this._storageHandler.getStoreScheduler().getActiveJobs(), this._suppressHsmLoad ? 0 : this._storageHandler.getStoreScheduler().getMaxActiveJobs(), this._storageHandler.getStoreScheduler().getQueueSize());
        return info;
    }

    public String ac_set_breakeven_$_0_1(Args args) {
        if (args.argc() > 0) {
            this._breakEven = Double.parseDouble(args.argv(0));
        }
        return "BreakEven = " + this._breakEven;
    }

    public String ac_set_mover_cost_factor_$_0_1(Args args) {
        if (args.argc() > 0) {
            double value = Double.parseDouble(args.argv(0));
            if (value < 0.0) {
                throw new IllegalArgumentException("Mover cost factor must be larger than or equal to 0.0");
            }
            this._moverCostFactor = value;
        }
        return "Cost factor is " + this._moverCostFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_pnfs_register(Args args) {
        Object object = this._hybridInventoryLock;
        synchronized (object) {
            if (this._hybridInventoryActive) {
                throw new IllegalArgumentException("Hybrid inventory still active");
            }
            this._hybridInventoryActive = true;
            new HybridInventory(true);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_pnfs_unregister(Args args) {
        Object object = this._hybridInventoryLock;
        synchronized (object) {
            if (this._hybridInventoryActive) {
                throw new IllegalArgumentException("Hybrid inventory still active");
            }
            this._hybridInventoryActive = true;
            new HybridInventory(false);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_run_hybrid_inventory(Args args) {
        Object object = this._hybridInventoryLock;
        synchronized (object) {
            if (this._hybridInventoryActive) {
                throw new IllegalArgumentException("Hybrid inventory still active");
            }
            this._hybridInventoryActive = true;
            new HybridInventory(!args.hasOption("destroy"));
        }
        return "";
    }

    public String ac_pf_$_1(Args args) throws CacheException, IllegalArgumentException {
        return this._pnfs.getPathByPnfsId(new PnfsId(args.argv(0)));
    }

    public String ac_set_replication_$_1(Args args) {
        this.setReplicateOnArrival(args.argv(0));
        return this._replicationHandler.toString();
    }

    public String ac_pool_suppress_hsmload_$_1(Args args) {
        String mode = args.argv(0);
        if (mode.equals("on")) {
            this._suppressHsmLoad = true;
        } else if (mode.equals("off")) {
            this._suppressHsmLoad = false;
        } else {
            throw new IllegalArgumentException("Illegal syntax : pool suppress hsmload on|off");
        }
        return "hsm load suppression swithed : " + (this._suppressHsmLoad ? "on" : "off");
    }

    public String ac_movermap_define_$_2(Args args) throws Exception {
        this._moverHash.put(args.argv(0), Class.forName(args.argv(1)));
        return "";
    }

    public String ac_movermap_undefine_$_1(Args args) {
        this._moverHash.remove(args.argv(0));
        return "";
    }

    public String ac_movermap_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Class<?>> entry : this._moverHash.entrySet()) {
            sb.append(entry.getKey()).append(" -> ").append(entry.getValue().getName()).append("\n");
        }
        return sb.toString();
    }

    public String ac_set_duplicate_request_$_1(Args args) throws CommandSyntaxException {
        String mode = args.argv(0);
        if (mode.equals("none")) {
            this._dupRequest = 0;
        } else if (mode.equals("ignore")) {
            this._dupRequest = 1;
        } else if (mode.equals("refresh")) {
            this._dupRequest = 2;
        } else {
            throw new CommandSyntaxException("Not Found : ", "Usage : pool duplicate request none|ignore|refresh");
        }
        return "";
    }

    public String ac_set_p2p_$_1(Args args) throws CommandSyntaxException {
        return "WARNING: this command is obsolete";
    }

    public String ac_pool_disable_$_0_2(Args args) {
        if (this._poolMode.isDisabled(64)) {
            return "The pool is dead and a restart is required to enable it";
        }
        int rc = args.argc() > 0 ? Integer.parseInt(args.argv(0)) : 1;
        String rm = args.argc() > 1 ? args.argv(1) : "Operator intervention";
        int modeBits = 1;
        if (args.hasOption("strict")) {
            modeBits |= 0x3F;
        }
        if (args.hasOption("stage")) {
            modeBits |= 8;
        }
        if (args.hasOption("fetch")) {
            modeBits |= 2;
        }
        if (args.hasOption("store")) {
            modeBits |= 4;
        }
        if (args.hasOption("p2p-client")) {
            modeBits |= 0x10;
        }
        if (args.hasOption("p2p-server")) {
            modeBits |= 0x20;
        }
        if (args.hasOption("rdonly")) {
            modeBits |= 0x1D;
        }
        this.disablePool(modeBits, rc, rm);
        return "Pool " + this._poolName + " " + this._poolMode;
    }

    public String ac_pool_enable(Args args) {
        if (this._poolMode.isDisabled(64)) {
            return "The pool is dead and a restart is required to enable it";
        }
        this.enablePool();
        return "Pool " + this._poolName + " enabled";
    }

    public String ac_set_max_movers_$_1(Args args) throws IllegalArgumentException {
        int num = Integer.parseInt(args.argv(0));
        if (num < 0 || num > 10000) {
            throw new IllegalArgumentException("Not in range (0...10000)");
        }
        return "Please use 'mover|st|rh set max active <jobs>'";
    }

    public String ac_set_gap_$_1(Args args) {
        this._gap = UnitInteger.parseUnitLong(args.argv(0));
        return "Gap set to " + this._gap;
    }

    public String ac_set_report_remove_$_1(Args args) throws CommandSyntaxException {
        String onoff = args.argv(0);
        if (onoff.equals("on")) {
            this._reportOnRemovals = true;
        } else if (onoff.equals("off")) {
            this._reportOnRemovals = false;
        } else {
            throw new CommandSyntaxException("Invalid value : " + onoff);
        }
        return "";
    }

    public String ac_crash_$_0_1(Args args) throws IllegalArgumentException {
        if (args.argc() < 1) {
            return "Crash is " + (this._crashEnabled ? this._crashType : "disabled");
        }
        if (args.argv(0).equals("shutdown")) {
            this._crashEnabled = true;
            this._crashType = "shutdown";
        } else if (args.argv(0).equals("exception")) {
            this._crashEnabled = true;
            this._crashType = "exception";
        } else if (args.argv(0).equals("disabled")) {
            this._crashEnabled = false;
        } else {
            throw new IllegalArgumentException("crash disabled|shutdown|exception");
        }
        return "Crash is " + (this._crashEnabled ? this._crashType : "disabled");
    }

    public String ac_set_sticky_$_0_1(Args args) {
        return "The command is deprecated and has no effect";
    }

    public String ac_set_cleaning_interval_$_1(Args args) {
        this._cleaningInterval = Integer.parseInt(args.argv(0));
        _log.info("set cleaning interval to " + this._cleaningInterval);
        return "";
    }

    public String ac_flush_class_$_2(Args args) {
        String tmp = args.getOpt("count");
        int count = tmp == null || tmp.equals("") ? 0 : Integer.parseInt(tmp);
        long id = this._flushingThread.flushStorageClass(args.argv(0), args.argv(1), count);
        return "Flush Initiated (id=" + id + ")";
    }

    public String ac_flush_pnfsid_$_1(Args args) throws CacheException, InterruptedException {
        this._storageHandler.store(new PnfsId(args.argv(0)), null);
        return "Flush Initiated";
    }

    public String ac_mover_set_max_active_$_1(Args args) throws NumberFormatException, IllegalArgumentException {
        String queueName = args.getOpt("queue");
        if (queueName == null) {
            return this.mover_set_max_active(this._ioQueue.getDefaultScheduler(), args);
        }
        IoScheduler js = this._ioQueue.getQueue(queueName);
        if (js == null) {
            return "Not found : " + queueName;
        }
        return this.mover_set_max_active(js, args);
    }

    public String ac_p2p_set_max_active_$_1(Args args) throws NumberFormatException, IllegalArgumentException {
        IoScheduler p2pQueue = this._ioQueue.getQueue(P2P_QUEUE_NAME);
        return this.mover_set_max_active(p2pQueue, args);
    }

    private String mover_set_max_active(IoScheduler js, Args args) throws NumberFormatException, IllegalArgumentException {
        int active = Integer.parseInt(args.argv(0));
        if (active < 0) {
            throw new IllegalArgumentException("<maxActiveMovers> must be >= 0");
        }
        js.setMaxActiveJobs(active);
        return "Max Active Io Movers set to " + active;
    }

    public Object ac_mover_queue_ls_$_0_1(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.hasOption("l")) {
            for (IoScheduler js : this._ioQueue.getSchedulers()) {
                sb.append(js.getName()).append(" ").append(js.getActiveJobs()).append(" ").append(js.getMaxActiveJobs()).append(" ").append(js.getQueueSize()).append("\n");
            }
        } else {
            for (IoScheduler js : this._ioQueue.getSchedulers()) {
                sb.append(js.getName()).append("\n");
            }
        }
        return sb.toString();
    }

    public Object ac_mover_ls_$_0_1(Args args) throws NoSuchElementException {
        String queueName = args.getOpt("queue");
        boolean binary = args.hasOption("binary");
        if (binary && args.argc() > 0) {
            int id = Integer.parseInt(args.argv(0));
            IoScheduler js = this._ioQueue.getQueueByJobId(id);
            return js.getJobInfo(id);
        }
        if (queueName == null) {
            return this.mover_ls(this._ioQueue.getQueues(), binary);
        }
        if (queueName.length() == 0) {
            StringBuilder sb = new StringBuilder();
            for (IoScheduler js : this._ioQueue.getSchedulers()) {
                sb.append("[").append(js.getName()).append("]\n");
                sb.append(this.mover_ls(js, binary).toString());
            }
            return sb.toString();
        }
        IoScheduler js = this._ioQueue.getQueue(queueName);
        if (js == null) {
            throw new NoSuchElementException(queueName);
        }
        return this.mover_ls(js, binary);
    }

    public Object ac_p2p_ls_$_0_1(Args args) {
        IoScheduler p2pQueue = this._ioQueue.getQueue(P2P_QUEUE_NAME);
        boolean binary = args.hasOption("binary");
        if (binary && args.argc() > 0) {
            int id = Integer.parseInt(args.argv(0));
            IoScheduler js = this._ioQueue.getQueueByJobId(id);
            return js.getJobInfo(id);
        }
        return this.mover_ls(p2pQueue, binary);
    }

    private Object mover_ls(IoScheduler js, boolean binary) {
        return this.mover_ls(Arrays.asList(js), binary);
    }

    private Object mover_ls(List<IoScheduler> jobSchedulers, boolean binary) {
        if (binary) {
            ArrayList<JobInfo> list = new ArrayList<JobInfo>();
            for (IoScheduler js : jobSchedulers) {
                list.addAll(js.getJobInfos());
            }
            return list.toArray(new IoJobInfo[0]);
        }
        StringBuffer sb = new StringBuffer();
        for (IoScheduler js : jobSchedulers) {
            js.printJobQueue(sb);
        }
        return sb.toString();
    }

    public String ac_mover_remove_$_1(Args args) throws NoSuchElementException, NumberFormatException {
        int id = Integer.parseInt(args.argv(0));
        IoScheduler js = this._ioQueue.getQueueByJobId(id);
        js.cancel(id);
        return "Removed";
    }

    public String ac_p2p_remove_$_1(Args args) throws NoSuchElementException, NumberFormatException {
        return "OBSOLETE: use: mover remove -queue=p2p";
    }

    public String ac_mover_kill_$_1(Args args) throws NoSuchElementException, NumberFormatException {
        int id = Integer.parseInt(args.argv(0));
        boolean force = args.hasOption("force");
        IoScheduler js = this._ioQueue.getQueueByJobId(id);
        this.mover_kill(js, id, force);
        return "Kill initialized";
    }

    public String ac_p2p_kill_$_1(Args args) throws NoSuchElementException, NumberFormatException {
        return "OBSOLETE: use: mover kill -queue=p2p";
    }

    private void mover_kill(IoScheduler js, int id, boolean force) throws NoSuchElementException {
        _log.info("Killing mover " + id);
        js.cancel(id);
    }

    public String ac_set_heartbeat_$_0_1(Args args) throws NumberFormatException {
        if (args.argc() > 0) {
            this._pingThread.setHeartbeat(Integer.parseInt(args.argv(0)));
        }
        return "Heartbeat at " + this._pingThread.getHeartbeat();
    }

    private class HybridInventory
    implements Runnable {
        private boolean _activate = true;

        public HybridInventory(boolean activate) {
            this._activate = activate;
            new Thread((Runnable)this, "HybridInventory").start();
        }

        private void addCacheLocation(PnfsId id) {
            try {
                PoolV4.this._pnfs.addCacheLocation(id);
            }
            catch (FileNotFoundCacheException e) {
                try {
                    PoolV4.this._repository.setState(id, EntryState.REMOVED);
                    _log.info("File not found in PNFS; removed " + id);
                }
                catch (InterruptedException f) {
                    _log.error("File not found in PNFS, but failed to remove " + id + ": " + f);
                }
                catch (CacheException f) {
                    _log.error("File not found in PNFS, but failed to remove " + id + ": " + f);
                }
                catch (IllegalTransitionException f) {
                    _log.error("File not found in PNFS, but failed to remove " + id + ": " + f);
                }
            }
            catch (CacheException e) {
                _log.error("Cache location was not registered for " + id + ": " + e.getMessage());
            }
        }

        private void clearCacheLocation(PnfsId id) {
            PoolV4.this._pnfs.clearCacheLocation(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PoolV4.this._hybridCurrent = 0;
            if (this._activate) {
                _log.info("Registering all replicas in PNFS");
            } else {
                _log.info("Unregistering all replicas in PNFS");
            }
            long startTime = System.currentTimeMillis();
            for (PnfsId pnfsid : PoolV4.this._repository) {
                if (Thread.interrupted()) break;
                try {
                    switch (PoolV4.this._repository.getState(pnfsid)) {
                        case PRECIOUS: 
                        case CACHED: 
                        case BROKEN: {
                            PoolV4.this._hybridCurrent++;
                            if (this._activate) {
                                this.addCacheLocation(pnfsid);
                                break;
                            }
                            this.clearCacheLocation(pnfsid);
                            break;
                        }
                    }
                }
                catch (CacheException e) {
                    _log.warn(e.getMessage());
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            long stopTime = System.currentTimeMillis();
            Object object = PoolV4.this._hybridInventoryLock;
            synchronized (object) {
                PoolV4.this._hybridInventoryActive = false;
            }
            _log.info("Replica " + (this._activate ? "registration" : "deregistration") + " finished. " + PoolV4.this._hybridCurrent + " replicas processed in " + (stopTime - startTime) + " msec");
        }
    }

    private class PoolManagerPingThread
    implements Runnable {
        private final Thread _worker = new Thread((Runnable)this, "ping");
        private int _heartbeat = 30;

        private PoolManagerPingThread() {
        }

        private void start() {
            this._worker.start();
        }

        @Override
        public void run() {
            _log.debug("Ping thread started");
            try {
                while (!Thread.interrupted()) {
                    this.sendPoolManagerMessage(true);
                    Thread.sleep(this._heartbeat * 1000);
                }
            }
            catch (InterruptedException e) {
                _log.debug("Ping thread was interrupted");
            }
            _log.info("Ping thread sending pool down message");
            PoolV4.this.disablePool(127, 666, "PingThread terminated");
            _log.debug("Ping Thread finished");
        }

        public void setHeartbeat(int seconds) {
            this._heartbeat = seconds;
        }

        public int getHeartbeat() {
            return this._heartbeat;
        }

        public synchronized void sendPoolManagerMessage(boolean forceSend) {
            if (forceSend || PoolV4.this._storageQueue.poolStatusChanged()) {
                this.send(this.getPoolManagerMessage());
            }
        }

        private CellMessage getPoolManagerMessage() {
            boolean disabled = PoolV4.this._poolMode.getMode() == 1 || PoolV4.this._poolMode.isDisabled(63);
            PoolCostInfo info = disabled ? null : PoolV4.this.getPoolCostInfo();
            PoolManagerPoolUpMessage poolManagerMessage = new PoolManagerPoolUpMessage(PoolV4.this._poolName, PoolV4.this._serialId, PoolV4.this._poolMode, info);
            poolManagerMessage.setTagMap(PoolV4.this._tags);
            if (PoolV4.this._hsmSet != null) {
                poolManagerMessage.setHsmInstances(new TreeSet<String>(PoolV4.this._hsmSet.getHsmInstances()));
            }
            poolManagerMessage.setMessage(PoolV4.this._poolStatusMessage);
            poolManagerMessage.setCode(PoolV4.this._poolStatusCode);
            return new CellMessage(new CellPath(PoolV4.this._poolupDestination), (Object)poolManagerMessage);
        }

        private void send(CellMessage msg) {
            try {
                PoolV4.this.sendMessage(msg);
            }
            catch (NoRouteToCellException e) {
                _log.error("Failed to send ping message: " + e.getMessage());
            }
        }
    }

    private class CompanionFileAvailableCallback
    extends DelayedReply
    implements CacheFileAvailable {
        private final Pool2PoolTransferMsg _message;

        private CompanionFileAvailableCallback(Pool2PoolTransferMsg message) {
            this._message = message;
        }

        @Override
        public void cacheFileAvailable(PnfsId pnfsId, Throwable error) {
            if (this._message.getReplyRequired()) {
                if (error == null) {
                    this._message.setSucceeded();
                } else if (error instanceof FileInCacheException) {
                    this._message.setReply(0, null);
                } else if (error instanceof CacheException) {
                    this._message.setReply(((CacheException)error).getRc(), error);
                } else {
                    this._message.setReply(10011, error);
                }
                try {
                    this.send(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Cannot send P2P reply: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    _log.error("Cannot send P2P reply: " + e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class ReplyToPoolFetch
    extends DelayedReply
    implements CacheFileAvailable {
        private final PoolFetchFileMessage _message;

        private ReplyToPoolFetch(PoolFetchFileMessage message) {
            this._message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cacheFileAvailable(PnfsId pnfsId, Throwable ee) {
            try {
                if (ee == null) {
                    this._message.setSucceeded();
                } else if (ee instanceof CacheException) {
                    CacheException ce = (CacheException)ee;
                    int errorCode = ce.getRc();
                    this._message.setFailed(errorCode, ce.getMessage());
                    switch (errorCode) {
                        case 41: 
                        case 42: 
                        case 43: {
                            PoolV4.this.disablePool(63, errorCode, ce.getMessage());
                        }
                    }
                } else {
                    this._message.setFailed(1000, ee);
                }
            }
            finally {
                if (this._message.getReturnCode() != 0) {
                    _log.error("Fetch failed: " + this._message.getErrorObject());
                    try {
                        PoolV4.this._repository.setState(pnfsId, EntryState.REMOVED);
                    }
                    catch (InterruptedException e) {
                        _log.warn("Failed to remove replica: " + e.getMessage());
                    }
                    catch (CacheException e) {
                        _log.warn("Failed to remove replica: " + e.getMessage());
                    }
                    catch (IllegalTransitionException e) {
                        _log.warn("Failed to remove replica: " + e.getMessage());
                    }
                }
                try {
                    this.send(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Failed to send reply: " + e.getMessage());
                }
                catch (InterruptedException e) {
                    _log.error("Failed to send reply: " + e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class ReplicationHandler
    extends AbstractStateChangeListener {
        private boolean _enabled = false;
        private CellPath _replicationManager = new CellPath("PoolManager");
        private String _destinationHostName = null;
        private String _destinationMode = "keep";
        private boolean _replicateOnRestore = false;

        private ReplicationHandler() {
        }

        @Override
        public void stateChanged(StateChangeEvent event) {
            EntryState from = event.getOldState();
            EntryState to = event.getNewState();
            if (to == EntryState.CACHED || to == EntryState.PRECIOUS) {
                switch (from) {
                    case FROM_CLIENT: {
                        this.initiateReplication(event.getPnfsId(), "write");
                        break;
                    }
                    case FROM_STORE: {
                        this.initiateReplication(event.getPnfsId(), "restore");
                    }
                }
            }
        }

        public void init(String vars) {
            if (this._destinationHostName == null) {
                try {
                    this._destinationHostName = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException ee) {
                    this._destinationHostName = "localhost";
                }
            }
            if (vars == null || vars.equals("off")) {
                this._enabled = false;
                return;
            }
            if (vars.equals("on")) {
                this._enabled = true;
                return;
            }
            this._enabled = true;
            String[] args = vars.split(",");
            if (args.length > 0 && !args[0].equals("")) {
                this._replicationManager = new CellPath(args[0]);
            }
            this._destinationHostName = args.length > 1 && !args[1].equals("") ? args[1] : this._destinationHostName;
            String string = this._destinationMode = args.length > 2 && !args[2].equals("") ? args[2] : this._destinationMode;
            if (this._destinationHostName.equals("*")) {
                try {
                    this._destinationHostName = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException ee) {
                    this._destinationHostName = "localhost";
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._enabled) {
                sb.append("{Mgr=").append(this._replicationManager).append(",Host=").append(this._destinationHostName).append(",DestMode=").append(this._destinationMode).append("}");
            } else {
                sb.append("Disabled");
            }
            return sb.toString();
        }

        private void initiateReplication(PnfsId id, String source) {
            if (!this._enabled || source.equals("restore") && !this._replicateOnRestore) {
                return;
            }
            try {
                this._initiateReplication(PoolV4.this._repository.getEntry(id), source);
            }
            catch (InterruptedException e) {
                _log.error("Problem in sending replication request: " + e);
                Thread.currentThread().interrupt();
            }
            catch (CacheException e) {
                _log.error("Problem in sending replication request: " + e);
            }
            catch (NoRouteToCellException e) {
                _log.error("Problem in sending replication request: " + e.getMessage());
            }
        }

        private void _initiateReplication(CacheEntry entry, String source) throws CacheException, NoRouteToCellException {
            PnfsId pnfsId = entry.getPnfsId();
            StorageInfo storageInfo = entry.getStorageInfo().clone();
            storageInfo.setKey("replication.source", source);
            FileAttributes attributes = new FileAttributes();
            attributes.setPnfsId(pnfsId);
            attributes.setStorageInfo(storageInfo);
            attributes.setLocations(Collections.singleton(PoolV4.this._poolName));
            attributes.setSize(storageInfo.getFileSize());
            PoolMgrReplicateFileMsg req = new PoolMgrReplicateFileMsg(attributes, new DCapProtocolInfo("DCap", 3, 0, this._destinationHostName, 2222), storageInfo.getFileSize());
            req.setReplyRequired(false);
            PoolV4.this.sendMessage(new CellMessage(this._replicationManager, (Object)req));
        }
    }

    private class NotifyBillingOnRemoveListener
    extends AbstractStateChangeListener {
        private NotifyBillingOnRemoveListener() {
        }

        @Override
        public void stateChanged(StateChangeEvent event) {
            if (PoolV4.this._reportOnRemovals && event.getNewState() == EntryState.REMOVED) {
                try {
                    CacheEntry entry = event.getEntry();
                    String source = PoolV4.this.getCellName() + "@" + PoolV4.this.getCellDomainName();
                    RemoveFileInfoMessage msg = new RemoveFileInfoMessage(source, entry.getPnfsId());
                    msg.setFileSize(entry.getReplicaSize());
                    msg.setStorageInfo(entry.getStorageInfo());
                    PoolV4.this.sendMessage(new CellMessage(PoolV4.this._billingCell, (Object)msg));
                }
                catch (NoRouteToCellException e) {
                    _log.error("Failed to send message to " + PoolV4.this._billingCell + ": " + e.getMessage());
                }
            }
        }
    }

    private class RepositoryLoader
    extends AbstractStateChangeListener {
        private RepositoryLoader() {
        }

        @Override
        public void stateChanged(StateChangeEvent event) {
            EntryState to;
            PnfsId id = event.getPnfsId();
            EntryState from = event.getOldState();
            if (from == (to = event.getNewState())) {
                return;
            }
            if (to == EntryState.PRECIOUS) {
                _log.debug("Adding " + id + " to flush queue");
                if (PoolV4.this._hasTapeBackend) {
                    try {
                        PoolV4.this._storageQueue.addCacheEntry(id);
                    }
                    catch (FileNotInCacheException e) {
                        _log.info("Failed to flush " + id + ": Replica is no longer in the pool", (Throwable)e);
                    }
                    catch (CacheException e) {
                        _log.error("Error adding " + id + " to flush queue: " + e.getMessage());
                    }
                    catch (InterruptedException e) {
                        _log.error("Error adding " + id + " to flush queue: " + e.getMessage());
                    }
                }
            } else if (from == EntryState.PRECIOUS) {
                _log.debug("Removing " + id + " from flush queue");
                try {
                    if (!PoolV4.this._storageQueue.removeCacheEntry(id)) {
                        _log.info("File " + id + " not found in flush queue");
                    }
                }
                catch (CacheException e) {
                    _log.error("Error removing " + id + " from flush queue: " + e);
                }
            }
        }
    }

    private class HFlagMaintainer
    extends AbstractStateChangeListener {
        private HFlagMaintainer() {
        }

        @Override
        public void stateChanged(StateChangeEvent event) {
            if (event.getOldState() == EntryState.FROM_CLIENT) {
                PnfsId id = event.getPnfsId();
                if (PoolV4.this._hasTapeBackend) {
                    PoolV4.this._pnfs.putPnfsFlag(id, "h", "yes");
                } else {
                    PoolV4.this._pnfs.putPnfsFlag(id, "h", "no");
                }
            }
        }
    }
}

