/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.dcache.pool.classic.ChecksumModuleV1;
import org.dcache.pool.classic.PoolIOTransfer;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.FileRepositoryChannel;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolIOWriteTransfer
extends PoolIOTransfer {
    private static final Logger _log = LoggerFactory.getLogger(PoolIOWriteTransfer.class);
    private final ReplicaDescriptor _handle;
    private final File _file;
    private final ChecksumModuleV1 _checksumModule;
    private ChecksumFactory _checksumFactory;
    private long _size;

    public static List<StickyRecord> getStickyRecords(StorageInfo info) {
        AccessLatency al = info.getAccessLatency();
        if (al != null && al.equals((Object)AccessLatency.ONLINE)) {
            return Collections.singletonList(new StickyRecord("system", -1L));
        }
        return Collections.emptyList();
    }

    public static EntryState getTargetState(StorageInfo info) {
        RetentionPolicy rp = info.getRetentionPolicy();
        if (info.getKey("overwrite") != null) {
            return EntryState.CACHED;
        }
        if (rp != null && rp.equals((Object)RetentionPolicy.CUSTODIAL)) {
            return EntryState.PRECIOUS;
        }
        return EntryState.CACHED;
    }

    public PoolIOWriteTransfer(PnfsId pnfsId, ProtocolInfo protocolInfo, Subject subject, StorageInfo storageInfo, MoverProtocol mover, Repository repository, ChecksumModuleV1 checksumModule, EntryState targetState, List<StickyRecord> stickyRecords) throws FileInCacheException, IOException {
        super(pnfsId, protocolInfo, subject, storageInfo, mover);
        this._checksumModule = checksumModule;
        this._handle = repository.createEntry(pnfsId, this._storageInfo, EntryState.FROM_CLIENT, targetState, stickyRecords);
        this._file = this._handle.getFile();
        this._file.createNewFile();
    }

    private void runMover(RepositoryChannel fileIoChannel) throws Exception {
        this._mover.runIO(fileIoChannel, this._protocolInfo, this._storageInfo, this._pnfsId, this._handle, IoMode.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transfer() throws Exception {
        try {
            FileRepositoryChannel fileIoChannel = new FileRepositoryChannel(this._file, "rw");
            try {
                if (this._checksumModule.checkOnTransfer() && this._mover instanceof ChecksumMover) {
                    ChecksumMover cm = (ChecksumMover)((Object)this._mover);
                    this._checksumFactory = cm.getChecksumFactory(this._protocolInfo);
                    if (this._checksumFactory == null) {
                        this._checksumFactory = this._checksumModule.getDefaultChecksumFactory();
                    }
                    cm.setDigest(this._checksumFactory);
                }
                this.runMover(fileIoChannel);
            }
            finally {
                try {
                    fileIoChannel.sync();
                }
                catch (SyncFailedException e) {
                    fileIoChannel.sync();
                    _log.info("First sync failed [" + e + "], but second sync suceeded");
                }
                fileIoChannel.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new CacheException(204, "File could not be created; please check the file system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CacheException, InterruptedException, IOException, NoRouteToCellException {
        try {
            Checksum clientChecksum = null;
            Checksum transferChecksum = null;
            if (this._mover instanceof ChecksumMover) {
                ChecksumMover cm = (ChecksumMover)((Object)this._mover);
                clientChecksum = cm.getClientChecksum();
                if (this._checksumModule.checkOnTransfer()) {
                    transferChecksum = cm.getTransferChecksum();
                }
                if (this._checksumFactory == null) {
                    this._checksumFactory = cm.getChecksumFactory(this._protocolInfo);
                }
            }
            if (this._checksumFactory == null) {
                this._checksumFactory = this._checksumModule.getDefaultChecksumFactory();
            }
            this._checksumModule.setMoverChecksums(this._pnfsId, this._file, this._checksumFactory, clientChecksum, transferChecksum);
            this._handle.commit(null);
        }
        finally {
            this._handle.close();
            this._storageInfo.setFileSize(this.getFileSize());
        }
    }

    @Override
    public long getFileSize() {
        return this._file.length();
    }

    @Override
    public ReplicaDescriptor getIoHandle() {
        return this._handle;
    }

    @Override
    public IoMode getIoMode() {
        return IoMode.WRITE;
    }
}

