/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import javax.security.auth.Subject;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.ReplicaDescriptor;

public abstract class PoolIOTransfer {
    protected final MoverProtocol _mover;
    protected final PnfsId _pnfsId;
    protected final ProtocolInfo _protocolInfo;
    protected final StorageInfo _storageInfo;
    protected final Subject _subject;

    public PoolIOTransfer(PnfsId pnfsId, ProtocolInfo protocolInfo, Subject subject, StorageInfo storageInfo, MoverProtocol mover) {
        this._pnfsId = pnfsId;
        this._protocolInfo = protocolInfo;
        this._subject = subject;
        this._storageInfo = storageInfo;
        this._mover = mover;
    }

    public StorageInfo getStorageInfo() {
        return this._storageInfo;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public long getTransferTime() {
        return this._mover.getTransferTime();
    }

    public long getBytesTransferred() {
        return this._mover.getBytesTransferred();
    }

    public double getTransferRate() {
        double bt = this._mover.getBytesTransferred();
        long tm = this._mover.getTransferTime();
        return tm == 0L ? 0.0 : bt / (double)tm;
    }

    public long getLastTransferred() {
        return this._mover.getLastTransferred();
    }

    public MoverProtocol getMover() {
        return this._mover;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._pnfsId);
        sb.append(" h={").append(this._mover.toString()).append("} bytes=").append(this.getBytesTransferred()).append(" time/sec=").append(this.getTransferTime() / 1000L).append(" LM=");
        long lastTransferTime = this.getLastTransferred();
        if (lastTransferTime == 0L) {
            sb.append(0);
        } else {
            sb.append((System.currentTimeMillis() - lastTransferTime) / 1000L);
        }
        return sb.toString();
    }

    public abstract void transfer() throws Exception;

    public abstract void close() throws CacheException, InterruptedException, IOException, NoRouteToCellException;

    public Subject getSubject() {
        return this._subject;
    }

    public abstract long getFileSize();

    public abstract ReplicaDescriptor getIoHandle();

    public abstract IoMode getIoMode();
}

