/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.MoverInfoMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import org.dcache.pool.FaultListener;
import org.dcache.pool.classic.Cancelable;
import org.dcache.pool.classic.CompletionHandler;
import org.dcache.pool.classic.IoProcessable;
import org.dcache.pool.classic.IoRequestState;
import org.dcache.pool.classic.MoverExecutorService;
import org.dcache.pool.classic.PoolIOTransfer;
import org.dcache.pool.classic.PoolIOWriteTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolIORequest
implements IoProcessable {
    private final PoolIOTransfer _transfer;
    private final long _id;
    private final String _queue;
    private final String _poolName;
    private final CellPath _door;
    private final String _initiator;
    private CellPath _billingCell;
    private final CellEndpoint _cellEndpoint;
    private static final Logger _log = LoggerFactory.getLogger(PoolIORequest.class);
    private final FaultListener _faultListener;
    private Cancelable _mover = null;
    private final long _ctime = System.currentTimeMillis();
    private volatile long _startTime = 0L;
    private volatile IoRequestState _state = IoRequestState.CREATED;
    private volatile int _errorCode = 0;
    private volatile String _errorMessage = "";
    private boolean _canceled = false;

    public PoolIORequest(PoolIOTransfer transfer, long id, String initiator, CellPath door, String poolName, String queue, CellEndpoint cellEndpoint, CellPath billingCell, FaultListener faultListener) {
        this._transfer = transfer;
        this._id = id;
        this._initiator = initiator;
        this._door = door;
        this._poolName = poolName;
        this._queue = queue;
        this._cellEndpoint = cellEndpoint;
        this._billingCell = billingCell;
        this._faultListener = faultListener;
    }

    void sendBillingMessage() {
        MoverInfoMessage info = new MoverInfoMessage(this._cellEndpoint.getCellInfo().getCellName() + "@" + this._cellEndpoint.getCellInfo().getDomainName(), this.getPnfsId());
        info.setSubject(this._transfer.getSubject());
        info.setInitiator(this._initiator);
        info.setFileCreated(this._transfer instanceof PoolIOWriteTransfer);
        info.setStorageInfo(this.getStorageInfo());
        info.setFileSize(this._transfer.getFileSize());
        info.setResult(this._errorCode, this._errorMessage);
        info.setTransferAttributes(this.getBytesTransferred(), this.getTransferTime(), this.getProtocolInfo());
        try {
            this._cellEndpoint.sendMessage(new CellMessage(this._billingCell, (Object)info));
        }
        catch (NoRouteToCellException e) {
            _log.error("Cannot send message to " + this._billingCell + ": No route to cell");
        }
    }

    void sendFinished() {
        DoorTransferFinishedMessage finished = new DoorTransferFinishedMessage(this.getClientId(), this.getPnfsId(), this.getProtocolInfo(), this.getStorageInfo(), this._poolName);
        finished.setIoQueueName(this._queue);
        if (this._errorCode == 0) {
            finished.setSucceeded();
        } else {
            finished.setReply(this._errorCode, this._errorMessage);
        }
        try {
            this._cellEndpoint.sendMessage(new CellMessage(this._door, (Object)finished));
        }
        catch (NoRouteToCellException e) {
            _log.error("Cannot send message to " + this._door + ": No route to cell");
        }
    }

    protected ProtocolInfo getProtocolInfo() {
        return this._transfer.getProtocolInfo();
    }

    protected StorageInfo getStorageInfo() {
        return this._transfer.getStorageInfo();
    }

    @Override
    public long getTransferTime() {
        return this._transfer.getTransferTime();
    }

    @Override
    public long getBytesTransferred() {
        return this._transfer.getBytesTransferred();
    }

    @Override
    public double getTransferRate() {
        return this._transfer.getTransferRate();
    }

    @Override
    public long getLastTransferred() {
        return this._transfer.getLastTransferred();
    }

    public PnfsId getPnfsId() {
        return this._transfer.getPnfsId();
    }

    @Override
    public String getClient() {
        return this._door.getDestinationAddress().toString();
    }

    @Override
    public long getClientId() {
        return this._id;
    }

    @Override
    public synchronized boolean kill() {
        this._state = IoRequestState.CANCELED;
        this._canceled = true;
        if (this._mover == null) {
            return false;
        }
        this._mover.cancel();
        return true;
    }

    synchronized void transfer(MoverExecutorService moverExecutorService, CompletionHandler completionHandler) {
        this._startTime = System.currentTimeMillis();
        if (this._canceled) {
            completionHandler.failed(new InterruptedException("Mover canceled"), null);
        } else {
            this._state = IoRequestState.RUNNING;
            this._mover = moverExecutorService.execute(this, completionHandler);
        }
    }

    void close() throws CacheException, InterruptedException, IOException, NoRouteToCellException {
        try {
            this._transfer.close();
        }
        catch (CacheException e) {
            _log.warn("Transfer failed in post-processing: {}", (Object)e.toString());
            throw e;
        }
        catch (InterruptedException e) {
            _log.warn("Transfer failed in post-processing: {}", (Object)e.toString());
            throw e;
        }
        catch (IOException e) {
            _log.warn("Transfer failed in post-processing: {}", (Object)e.toString());
            throw e;
        }
        catch (NoRouteToCellException e) {
            _log.warn("Transfer failed in post-processing: {}", (Object)e.toString());
            throw e;
        }
        catch (RuntimeException e) {
            _log.error("Transfer failed in post-processing due to unexpected exception", (Throwable)e);
            throw e;
        }
    }

    public PoolIOTransfer getTransfer() {
        return this._transfer;
    }

    public CellEndpoint getCellEndpoint() {
        return this._cellEndpoint;
    }

    public void setState(IoRequestState state) {
        this._state = state;
    }

    public IoRequestState getState() {
        return this._state;
    }

    public long getCreationTime() {
        return this._ctime;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public FaultListener getFaultListener() {
        return this._faultListener;
    }

    public void setTransferStatus(int errorCode, String errorMessage) {
        this._errorCode = errorCode;
        this._errorMessage = errorMessage;
    }

    public String toString() {
        return (Object)((Object)this._state) + " : " + this._transfer.toString();
    }
}

