/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.pool.classic.PoolIOTransfer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.FileRepositoryChannel;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;

public class PoolIOReadTransfer
extends PoolIOTransfer {
    private final ReplicaDescriptor _handle;
    private final long _size;

    public PoolIOReadTransfer(PnfsId pnfsId, ProtocolInfo protocolInfo, Subject subject, StorageInfo storageInfo, MoverProtocol mover, Repository repository) throws CacheException, InterruptedException {
        super(pnfsId, protocolInfo, subject, storageInfo, mover);
        Set<Repository.OpenFlags> flags = Collections.emptySet();
        this._handle = repository.openEntry(pnfsId, flags);
        this._size = this._handle.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transfer() throws Exception {
        long transferTimer = System.currentTimeMillis();
        File file = this._handle.getFile();
        try {
            long fileSize = file.length();
            FileRepositoryChannel fileIoChannel = new FileRepositoryChannel(file, "r");
            try {
                this._mover.runIO(fileIoChannel, this._protocolInfo, this._storageInfo, this._pnfsId, null, IoMode.READ);
            }
            finally {
                fileIoChannel.close();
            }
            if (this._mover.wasChanged()) {
                throw new RuntimeException("Bug: Mover changed read-only file");
            }
        }
        catch (FileNotFoundException e) {
            throw new CacheException(204, "File could not be opened  [" + e.getMessage() + "]; please check the file system");
        }
        finally {
            transferTimer = System.currentTimeMillis() - transferTimer;
        }
    }

    @Override
    public void close() {
        this._handle.close();
    }

    @Override
    public long getFileSize() {
        return this._size;
    }

    @Override
    public ReplicaDescriptor getIoHandle() {
        return this._handle;
    }

    @Override
    public IoMode getIoMode() {
        return IoMode.READ;
    }
}

