/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import java.util.Map;
import org.dcache.pool.classic.ClassicPostExecutionService;
import org.dcache.pool.classic.LegacyMoverExecutorService;
import org.dcache.pool.classic.MoverExecutorService;
import org.dcache.pool.classic.PostTransferExecutionService;

public class MoverExecutorServices {
    private final MoverExecutorService _defaultExecutorService = new LegacyMoverExecutorService();
    private final PostTransferExecutionService _defaultPostService = new ClassicPostExecutionService();
    private final Map<String, MoverExecutorService> _executionService;

    public MoverExecutorServices(Map<String, MoverExecutorService> executionService) {
        this._executionService = executionService;
    }

    public MoverExecutorService getExecutorService(String protocol) {
        MoverExecutorService service = this._executionService.get(protocol);
        if (service != null) {
            return service;
        }
        return this._defaultExecutorService;
    }

    public PostTransferExecutionService getPostExecutorService(String protocol) {
        return this._defaultPostService;
    }
}

