/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import dmg.cells.nucleus.CDC;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.dcache.pool.classic.Cancelable;
import org.dcache.pool.classic.CompletionHandler;
import org.dcache.pool.classic.MoverExecutorService;
import org.dcache.pool.classic.PoolIORequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMoverExecutorService
implements MoverExecutorService {
    private static final Logger _log = LoggerFactory.getLogger(LegacyMoverExecutorService.class);
    private static final String _name = LegacyMoverExecutorService.class.getSimpleName();
    private final ExecutorService _executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private int _counter = 0;
        private ThreadFactory _factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this._factory.newThread(r);
            t.setName(_name + "-worker-" + ++this._counter);
            return t;
        }
    });

    @Override
    public Cancelable execute(PoolIORequest request, CompletionHandler completionHandler) {
        MoverTask moverTask = new MoverTask(request, completionHandler);
        this._executor.execute(moverTask);
        return moverTask;
    }

    private static class MoverTask
    implements Runnable,
    Cancelable {
        private final PoolIORequest _request;
        private final CDC _cdc = new CDC();
        private final CompletionHandler _completionHandler;
        private Thread _thread;
        private boolean _needInterruption = false;

        public MoverTask(PoolIORequest request, CompletionHandler completionHandler) {
            this._request = request;
            this._completionHandler = completionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.setThread();
                this._cdc.restore();
                this._request.getTransfer().transfer();
                this._completionHandler.completed(null, null);
            }
            catch (Exception e) {
                _log.error("Transfer failed: {}", (Object)e.toString());
                this._completionHandler.failed(e, null);
            }
            catch (Throwable e) {
                _log.error("Transfer failed:", e);
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
                this._completionHandler.failed(e, null);
            }
            finally {
                this.cleanThread();
                CDC.clear();
            }
        }

        private synchronized void setThread() throws InterruptedException {
            if (this._needInterruption) {
                throw new InterruptedException("Thread interrupted before excecution");
            }
            this._thread = Thread.currentThread();
        }

        private synchronized void cleanThread() {
            this._thread = null;
        }

        @Override
        public synchronized void cancel() {
            if (this._thread != null) {
                this._thread.interrupt();
            } else {
                this._needInterruption = true;
            }
        }
    }
}

