/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.vehicles.JobInfo;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.classic.SchedulerEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTimeoutManager
extends AbstractCellComponent
implements Runnable,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(JobTimeoutManager.class);
    private final List<SchedulerEntry> _schedulers = new CopyOnWriteArrayList<SchedulerEntry>();
    private final Thread _worker = new Thread((Runnable)this, "JobTimeoutManager");
    public String hh_jtm_go = "trigger the worker thread";
    public String hh_jtm_ls = "list queues";
    public String hh_jtm_set_timeout = "[-total=<timeout/sec>] [-lastAccess=<timeout/sec>] [-queue=<queueName>]";

    public synchronized void start() {
        if (this._worker.isAlive()) {
            throw new IllegalStateException("Already running");
        }
        this._worker.start();
    }

    public void addScheduler(String type, IoScheduler scheduler) {
        this.say("Adding scheduler : " + type);
        SchedulerEntry entry = this.findOrCreate(type);
        entry.setScheduler(scheduler);
    }

    @Override
    public void printSetup(PrintWriter pw) {
        for (SchedulerEntry entry : this._schedulers) {
            pw.println("jtm set timeout -queue=" + entry.getName() + " -lastAccess=" + entry.getLastAccessed() / 1000L + " -total=" + entry.getTotal() / 1000L);
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("Job Timeout Manager");
        for (SchedulerEntry entry : this._schedulers) {
            pw.println("  " + entry.getName() + " (lastAccess=" + entry.getLastAccessed() / 1000L + ";total=" + entry.getTotal() / 1000L + ")");
        }
    }

    public synchronized String ac_jtm_go(Args args) {
        this.notifyAll();
        return "";
    }

    public String ac_jtm_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        for (SchedulerEntry entry : this._schedulers) {
            sb.append(entry.getName()).append(" ");
        }
        return sb.toString();
    }

    private SchedulerEntry find(String name) {
        for (SchedulerEntry entry : this._schedulers) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    private synchronized SchedulerEntry findOrCreate(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null argument not allowed");
        }
        SchedulerEntry entry = this.find(name);
        if (entry == null) {
            entry = new SchedulerEntry(name);
            this._schedulers.add(entry);
        }
        return entry;
    }

    public String ac_jtm_set_timeout(Args args) {
        long total;
        String queue = args.getOpt("queue");
        String lastAccessStr = args.getOpt("lastAccess");
        String totalStr = args.getOpt("total");
        long lastAccess = lastAccessStr == null ? -1L : Long.parseLong(lastAccessStr) * 1000L;
        long l = total = totalStr == null ? -1L : Long.parseLong(totalStr) * 1000L;
        if (queue == null) {
            for (SchedulerEntry entry : this._schedulers) {
                if (lastAccess >= 0L) {
                    entry.setLastAccessed(lastAccess);
                }
                if (total < 0L) continue;
                entry.setTotal(total);
            }
        } else {
            SchedulerEntry entry = this.findOrCreate(queue);
            if (lastAccess >= 0L) {
                entry.setLastAccessed(lastAccess);
            }
            if (total >= 0L) {
                entry.setTotal(total);
            }
        }
        return "";
    }

    private void say(String str) {
        _log.info(str);
    }

    private void esay(String str) {
        _log.error(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                JobTimeoutManager jobTimeoutManager = this;
                synchronized (jobTimeoutManager) {
                    this.wait(120000L);
                }
                long now = System.currentTimeMillis();
                for (SchedulerEntry entry : this._schedulers) {
                    IoScheduler jobs = entry.getScheduler();
                    if (jobs == null) continue;
                    for (JobInfo info : jobs.getJobInfos()) {
                        int jobId = (int)info.getJobId();
                        if (!entry.isExpired(info, now)) continue;
                        this.esay("Trying to kill <" + entry.getName() + "> id=" + jobId);
                        jobs.cancel(jobId);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

