/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.vehicles.JobInfo;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dcache.pool.classic.IoScheduler;
import org.dcache.pool.classic.JobTimeoutManager;
import org.dcache.pool.classic.MoverExecutorServices;
import org.dcache.pool.classic.PoolIORequest;
import org.dcache.pool.classic.SimpleIoScheduler;
import org.dcache.util.IoPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoQueueManager {
    private static final Logger _log = LoggerFactory.getLogger(IoQueueManager.class);
    public static final String DEFAULT_QUEUE = "regular";
    private List<IoScheduler> _list = new ArrayList<IoScheduler>();
    private final Map<String, IoScheduler> _hash = new HashMap<String, IoScheduler>();

    public IoQueueManager(JobTimeoutManager jobTimeoutManager, String[] queues, MoverExecutorServices executorServices) {
        if (queues == null) {
            throw new IllegalArgumentException("queue names can't be null");
        }
        this.addQueue(DEFAULT_QUEUE, jobTimeoutManager, executorServices);
        for (String queueName : queues) {
            if ((queueName = queueName.trim()).isEmpty()) continue;
            this.addQueue(queueName, jobTimeoutManager, executorServices);
        }
        _log.info("Defined IO queues {}: " + this._hash.keySet());
    }

    private void addQueue(String queueName, JobTimeoutManager jobTimeoutManager, MoverExecutorServices executorServices) {
        boolean fifo;
        boolean bl = fifo = !queueName.startsWith("-");
        if (!fifo) {
            queueName = queueName.substring(1);
        }
        if (this._hash.get(queueName) == null) {
            _log.info("adding queue: {}", (Object)queueName);
            int id = this._list.size();
            SimpleIoScheduler job = new SimpleIoScheduler(queueName, executorServices, id, fifo);
            this._list.add(job);
            this._hash.put(queueName, job);
            jobTimeoutManager.addScheduler(queueName, job);
        } else {
            _log.warn("Queue not created, name already exists: " + queueName);
        }
    }

    public synchronized IoScheduler getDefaultScheduler() {
        return this._list.get(0);
    }

    public synchronized Collection<IoScheduler> getSchedulers() {
        return Collections.unmodifiableCollection(this._list);
    }

    public synchronized IoScheduler getQueue(String queueName) {
        return this._hash.get(queueName);
    }

    public synchronized List<IoScheduler> getQueues() {
        return new ArrayList<IoScheduler>(this._list);
    }

    public synchronized IoScheduler getQueueByJobId(int id) {
        int pos = id >> 24;
        if (pos >= this._list.size()) {
            throw new IllegalArgumentException("Invalid id (doesn't below to any known scheduler)");
        }
        return this._list.get(pos);
    }

    public synchronized int add(String queueName, PoolIORequest request, IoPriority priority) throws InvocationTargetException {
        IoScheduler js = queueName == null ? null : this._hash.get(queueName);
        return js == null ? this.add(request, priority) : js.add(request, priority);
    }

    public synchronized int add(PoolIORequest request, IoPriority priority) throws InvocationTargetException {
        return this.getDefaultScheduler().add(request, priority);
    }

    public synchronized void cancel(int jobId) throws NoSuchElementException {
        this.getQueueByJobId(jobId).cancel(jobId);
    }

    public synchronized int getMaxActiveJobs() {
        int sum = 0;
        for (IoScheduler s : this._list) {
            sum += s.getMaxActiveJobs();
        }
        return sum;
    }

    public synchronized int getActiveJobs() {
        int sum = 0;
        for (IoScheduler s : this._list) {
            sum += s.getActiveJobs();
        }
        return sum;
    }

    public synchronized int getQueueSize() {
        int sum = 0;
        for (IoScheduler s : this._list) {
            sum += s.getQueueSize();
        }
        return sum;
    }

    public synchronized List<JobInfo> getJobInfos() {
        ArrayList<JobInfo> list = new ArrayList<JobInfo>();
        for (IoScheduler s : this._list) {
            list.addAll(s.getJobInfos());
        }
        return list;
    }

    public synchronized void printSetup(PrintWriter pw) {
        for (IoScheduler s : this._list) {
            pw.println("mover set max active -queue=" + s.getName() + " " + s.getMaxActiveJobs());
        }
    }

    public synchronized JobInfo findJob(String client, long id) {
        for (JobInfo info : this.getJobInfos()) {
            if (!client.equals(info.getClientName()) || id != info.getClientId()) continue;
            return info;
        }
        return null;
    }

    public synchronized void shutdown() {
        for (IoScheduler s : this._list) {
            s.shutdown();
        }
    }
}

