/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.JobScheduler;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.util.Date;
import org.dcache.cells.CellCommandListener;
import org.dcache.pool.classic.HsmStorageHandler2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmStorageInterpreter
implements CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(HsmStorageInterpreter.class);
    private final HsmStorageHandler2 _storageHandler;
    private final JobScheduler _fetchQueue;
    private final JobScheduler _storeQueue;
    private final PnfsHandler _pnfs;
    public String hh_rh_set_timeout = "<timeout/seconds>";
    public String hh_rh_set_max_active = "<maxActiveHsmMovers>";
    public String hh_rh_jobs_ls = "";
    public String hh_rh_jobs_remove = "<jobId>";
    public String hh_rh_jobs_kill = "[-force] <jobId>";
    public String hh_rh_ls = "[<pnfsId>]";
    public String hh_st_set_timeout = "<timeout/seconds>";
    public String hh_st_set_max_active = "<maxActiveHsmMovers>";
    public String hh_st_jobs_ls = "";
    public String hh_st_jobs_remove = "<jobId>";
    public String hh_st_jobs_kill = "[-force] <jobId>";
    public String hh_st_ls = "[<pnfsId>]";
    public String hh_rm_set_timeout = "<timeout/seconds>";
    public String hh_rm_set_max_active = "<maxActiveRemovers>";
    public String hh_rh_restore = "[-block] <pnfsId>";

    public HsmStorageInterpreter(HsmStorageHandler2 handler, PnfsHandler pnfs) {
        this._storageHandler = handler;
        this._pnfs = pnfs;
        this._fetchQueue = this._storageHandler.getFetchScheduler();
        this._storeQueue = this._storageHandler.getStoreScheduler();
    }

    public String ac_rh_set_timeout_$_1(Args args) {
        long timeout = Long.parseLong(args.argv(0)) * 1000L;
        this._storageHandler.setTimeout(-1L, timeout, -1L);
        return "";
    }

    public String ac_rh_set_max_active_$_1(Args args) throws Exception {
        int active = Integer.parseInt(args.argv(0));
        if (active < 0) {
            throw new IllegalArgumentException("<maxActiveRestores> must be >= 0");
        }
        this._fetchQueue.setMaxActiveJobs(active);
        return "Max Active Hsm Restore Processes set to " + active;
    }

    public String ac_rh_jobs_ls(Args args) throws Exception {
        return this._fetchQueue.printJobQueue(null).toString();
    }

    public String ac_rh_jobs_remove_$_1(Args args) throws Exception {
        int id = Integer.parseInt(args.argv(0));
        this._fetchQueue.remove(id);
        return "Removed";
    }

    public String ac_rh_jobs_kill_$_1(Args args) throws Exception {
        int id = Integer.parseInt(args.argv(0));
        this._fetchQueue.kill(id, args.hasOption("force"));
        return "Kill initialized";
    }

    public String ac_rh_ls(Args args) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (PnfsId pnfsId : this._storageHandler.getRestorePnfsIds()) {
            HsmStorageHandler2.Info info = this._storageHandler.getRestoreInfoByPnfsId(pnfsId);
            if (info == null) {
                sb.append(pnfsId).append("  <zombie>\n");
                continue;
            }
            sb.append(pnfsId).append("  ").append(info.getListenerCount()).append("   ").append(new Date(info.getStartTime()).toString()).append("\n");
        }
        return sb.toString();
    }

    public String ac_st_set_timeout_$_1(Args args) {
        long timeout = Long.parseLong(args.argv(0)) * 1000L;
        this._storageHandler.setTimeout(timeout, -1L, -1L);
        return "";
    }

    public String ac_st_set_max_active_$_1(Args args) throws Exception {
        int active = Integer.parseInt(args.argv(0));
        if (active < 0) {
            throw new IllegalArgumentException("<maxActiveStores> must be >= 0");
        }
        this._storeQueue.setMaxActiveJobs(active);
        return "Max Active Hsm Store Processes set to " + active;
    }

    public String ac_st_jobs_ls(Args args) throws Exception {
        return this._storeQueue.printJobQueue(null).toString();
    }

    public String ac_st_jobs_remove_$_1(Args args) throws Exception {
        int id = Integer.parseInt(args.argv(0));
        this._storeQueue.remove(id);
        return "Removed";
    }

    public String ac_st_jobs_kill_$_1(Args args) throws Exception {
        int id = Integer.parseInt(args.argv(0));
        this._storeQueue.kill(id, args.hasOption("force"));
        return "Kill initialized";
    }

    public String ac_st_ls(Args args) throws Exception {
        StringBuffer sb = new StringBuffer();
        for (PnfsId pnfsId : this._storageHandler.getStorePnfsIds()) {
            _log.debug("ok " + pnfsId);
            HsmStorageHandler2.Info info = this._storageHandler.getStoreInfoByPnfsId(pnfsId);
            _log.debug("done " + info);
            if (info == null) {
                sb.append(pnfsId).append("  <zombie>\n");
                continue;
            }
            sb.append(pnfsId).append("  ").append(info.getListenerCount()).append("   ").append(new Date(info.getStartTime()).toString()).append("\n");
        }
        return sb.toString();
    }

    public String ac_rm_set_timeout_$_1(Args args) {
        long timeout = Long.parseLong(args.argv(0)) * 1000L;
        this._storageHandler.setTimeout(-1L, -1L, timeout);
        return "";
    }

    public String ac_rm_set_max_active_$_1(Args args) throws Exception {
        int active = Integer.parseInt(args.argv(0));
        if (active < 0) {
            throw new IllegalArgumentException("<maxActiveRemovers> must be >= 0");
        }
        this._storageHandler.setMaxRemoveJobs(active);
        return "Max active remover processes set to " + active;
    }

    public Object ac_rh_restore_$_1(Args args) {
        final PnfsId pnfsId = new PnfsId(args.argv(0));
        final boolean block = args.hasOption("block");
        final DelayedReply reply = new DelayedReply();
        final CacheFileAvailable cfa = new CacheFileAvailable(){

            @Override
            public void cacheFileAvailable(PnfsId pnfsId, Throwable ee) {
                try {
                    if (ee == null) {
                        reply.send((Object)("Fetched " + pnfsId));
                    } else {
                        reply.send((Object)("Failed to fetch " + pnfsId + ": " + ee));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (NoRouteToCellException e) {
                    _log.error("Failed to deliver reply: " + (Object)((Object)e));
                }
            }
        };
        Thread t = new Thread("rh restore"){

            @Override
            public void run() {
                try {
                    StorageInfo si = HsmStorageInterpreter.this._pnfs.getStorageInfoByPnfsId(pnfsId).getStorageInfo();
                    HsmStorageInterpreter.this._storageHandler.fetch(pnfsId, si, block ? cfa : null);
                }
                catch (CacheException e) {
                    cfa.cacheFileAvailable(pnfsId, e);
                }
            }
        };
        t.start();
        return block ? reply : "Fetch request queued";
    }
}

