/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.pools.PoolCellInfo;
import diskCacheV111.pools.StorageClassFlushInfo;
import diskCacheV111.vehicles.PoolFlushControlInfoMessage;
import diskCacheV111.vehicles.PoolFlushControlMessage;
import diskCacheV111.vehicles.PoolFlushDoFlushMessage;
import diskCacheV111.vehicles.PoolFlushGainControlMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.Formats;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.pool.classic.HsmStorageHandler2;
import org.dcache.pool.classic.StorageClassContainer;
import org.dcache.pool.classic.StorageClassInfo;
import org.dcache.pool.classic.StorageClassInfoFlushable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsmFlushController
extends AbstractCellComponent
implements Runnable,
CellMessageReceiver,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(HsmFlushController.class);
    private final Thread _worker;
    private int _maxActive = 1000;
    private int _flushingInterval = 60;
    private int _retryDelayOnError = 60;
    private long _holdUntil = System.currentTimeMillis() + 300000L;
    private final StorageClassContainer _storageQueue;
    private final HsmStorageHandler2 _storageHandler;
    public String hh_flush_set_max_active = "<maxActiveFlush's>";
    public String hh_flush_set_interval = "<flushing check interval/sec>";
    public String hh_flush_set_retry_delay = "<errorRetryDelay>/sec";
    private Object _parameterLock = new Object();

    public HsmFlushController(StorageClassContainer storageQueue, HsmStorageHandler2 storageHandler) {
        this._worker = new Thread((Runnable)this, "flushing");
        this._storageQueue = storageQueue;
        this._storageHandler = storageHandler;
    }

    private void setFlushInfos(PoolFlushControlInfoMessage flushInfo) {
        flushInfo.setCellInfo((PoolCellInfo)this.getCellInfo());
        ArrayList<StorageClassFlushInfo> list = new ArrayList<StorageClassFlushInfo>();
        for (StorageClassInfo info : this._storageQueue.getStorageClassInfos()) {
            list.add(info.getFlushInfo());
        }
        flushInfo.setFlushInfos(list.toArray(new StorageClassFlushInfo[list.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PoolFlushGainControlMessage messageArrived(PoolFlushGainControlMessage gain) {
        long holdTimer = gain.getHoldTimer();
        if (holdTimer > 0L) {
            Object object = this._parameterLock;
            synchronized (object) {
                this._holdUntil = System.currentTimeMillis() + holdTimer;
            }
        }
        if (gain.getReplyRequired()) {
            this.setFlushInfos(gain);
        }
        return gain;
    }

    public synchronized void messageArrived(CellMessage envelope, PoolFlushDoFlushMessage msg) {
        new PrivateFlush(msg, envelope);
    }

    public synchronized PoolFlushControlMessage messageArrived(PoolFlushControlMessage msg) {
        msg.setFailed(354, "Message type not supported : " + msg.getClass().getName());
        return msg;
    }

    public long flushStorageClass(String hsm, String storageClass, int maxCount) {
        return this.flushStorageClass(hsm, storageClass, maxCount, null);
    }

    long flushStorageClass(String hsm, String storageClass, int maxCount, StorageClassInfoFlushable callback) {
        StorageClassInfo info = this._storageQueue.getStorageClassInfoByName(hsm, storageClass);
        _log.debug("Flushing storageClass : " + info);
        long id = info.submit(this._storageHandler, maxCount, callback);
        _log.debug("Flushing storageClass : " + storageClass + " Done");
        return id;
    }

    public void start() {
        this._worker.start();
    }

    public String ac_flush_exception(Args args) throws Exception {
        Exception e = new Exception("Dummy Exception");
        e.fillInStackTrace();
        throw e;
    }

    public synchronized String ac_flush_set_max_active_$_1(Args args) {
        this._maxActive = Integer.parseInt(args.argv(0));
        return "Max active flush = " + this._maxActive;
    }

    public String ac_flush_set_interval_$_1(Args args) {
        this._flushingInterval = Integer.parseInt(args.argv(0));
        this.trigger();
        return "flushing interval set to " + this._flushingInterval;
    }

    public String ac_flush_set_retry_delay_$_1(Args args) {
        this._retryDelayOnError = Integer.parseInt(args.argv(0));
        return "Retry delay set to " + this._retryDelayOnError + " sec";
    }

    @Override
    public void printSetup(PrintWriter pw) {
        pw.println("#\n# Flushing Thread setup\n#");
        pw.println("flush set max active " + this._maxActive);
        pw.println("flush set interval " + this._flushingInterval);
        pw.println("flush set retry delay " + this._retryDelayOnError);
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("   Flushing Interval /seconds    : " + this._flushingInterval);
        pw.println("   Maximum classes flushing      : " + this._maxActive);
        pw.println("   Minimum flush delay on error  : " + this._retryDelayOnError);
        pw.println("  Remote controlled (hold until) : " + (this._holdUntil > System.currentTimeMillis() ? new Date(this._holdUntil).toString() : "Locally Controlled"));
    }

    public Object ac_flush_ls(Args args) {
        long now = System.currentTimeMillis();
        if (!args.hasOption("binary")) {
            StringBuffer sb = new StringBuffer();
            sb.append(Formats.field((String)"Class", (int)20, (int)2));
            sb.append(Formats.field((String)"Active", (int)8, (int)4));
            sb.append(Formats.field((String)"Error", (int)8, (int)4));
            sb.append(Formats.field((String)"Last/min", (int)10, (int)4));
            sb.append(Formats.field((String)"Requests", (int)10, (int)4));
            sb.append(Formats.field((String)"Failed", (int)10, (int)4));
            sb.append("\n");
            for (StorageClassInfo info : this._storageQueue.getStorageClassInfos()) {
                sb.append(Formats.field((String)(info.getStorageClass() + "@" + info.getHsm()), (int)20, (int)2));
                sb.append(Formats.field((String)("" + info.getActiveCount()), (int)8, (int)4));
                sb.append(Formats.field((String)("" + info.getErrorCount()), (int)8, (int)4));
                long lastSubmit = info.getLastSubmitted();
                lastSubmit = lastSubmit == 0L ? 0L : (now - info.getLastSubmitted()) / 60000L;
                sb.append(Formats.field((String)("" + lastSubmit), (int)10, (int)4));
                sb.append(Formats.field((String)("" + info.getRequestCount()), (int)10, (int)4));
                sb.append(Formats.field((String)("" + info.getFailedRequestCount()), (int)10, (int)4));
                sb.append("\n");
            }
            return sb.toString();
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (StorageClassInfo info : this._storageQueue.getStorageClassInfos()) {
            Object[] o = new Object[]{info.getHsm(), info.getStorageClass(), now - info.getLastSubmitted(), (long)info.getRequestCount(), (long)info.getFailedRequestCount(), (long)info.getActiveCount(), (long)info.getErrorCount()};
            list.add(o);
        }
        return list.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        _log.debug("Flush thread started");
        long holdUntil = 0L;
        while (!Thread.interrupted()) {
            try {
                long now = System.currentTimeMillis();
                Object object = this._parameterLock;
                synchronized (object) {
                    holdUntil = this._holdUntil;
                }
                if (this._holdUntil < now) {
                    Iterator<StorageClassInfo> e = this._storageQueue.getStorageClassInfos().iterator();
                    int active = 0;
                    while (e.hasNext() && active < this._maxActive) {
                        boolean isActive;
                        StorageClassInfo info = e.next();
                        boolean bl = isActive = info.getActiveCount() > 0;
                        if (isActive) {
                            ++active;
                            continue;
                        }
                        if (!info.isTriggered() || now - info.getLastSubmitted() <= (long)(this._retryDelayOnError * 1000)) continue;
                        _log.info("Flushing : " + info);
                        this.flushStorageClass(info.getHsm(), info.getStorageClass(), 0);
                        ++active;
                    }
                }
            }
            catch (Exception e) {
                _log.error(e.toString(), (Throwable)e);
            }
            try {
                this.wait(this._flushingInterval * 1000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        _log.debug("Flush thread finished");
    }

    public synchronized void trigger() {
        this.notifyAll();
    }

    private class PrivateFlush
    implements Runnable,
    StorageClassInfoFlushable {
        private final PoolFlushDoFlushMessage _flush;
        private final CellMessage _message;

        private PrivateFlush(PoolFlushDoFlushMessage flush, CellMessage message) {
            this._flush = flush;
            this._message = message;
            this._message.revertDirection();
            new Thread((Runnable)this, "Worker").start();
        }

        @Override
        public void run() {
            String hsm = this._flush.getHsmName();
            String storageClass = this._flush.getStorageClassName();
            String composed = storageClass + "@" + hsm;
            _log.debug("Starting flush for " + composed);
            try {
                long flushId = HsmFlushController.this.flushStorageClass(hsm, storageClass, this._flush.getMaxFlushCount(), this);
                this._flush.setFlushId(flushId);
                _log.debug("Finished flush for " + composed);
            }
            catch (Exception ee) {
                _log.error("Private flush failed for " + composed + " : " + ee);
                this._flush.setFailed(576, ee);
            }
            if (this._flush.getReplyRequired()) {
                try {
                    HsmFlushController.this.sendMessage(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Problem replying : " + this._message + " " + (Object)((Object)e));
                }
            }
        }

        @Override
        public void storageClassInfoFlushed(String hsm, String storageClass, long flushId, int requests, int failed) {
            _log.info("Flushed : " + hsm + "  " + storageClass + " , id=" + flushId + ";R=" + requests + ";f=" + failed);
            if (this._flush.getReplyRequired()) {
                HsmFlushController.this.setFlushInfos(this._flush);
                this._flush.setResult(requests, failed);
                try {
                    HsmFlushController.this.sendMessage(this._message);
                }
                catch (NoRouteToCellException e) {
                    _log.error("Problem replying : " + this._message + " " + (Object)((Object)e));
                }
            }
        }
    }
}

