/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import dmg.cells.nucleus.CDC;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.classic.PoolIORequest;
import org.dcache.pool.classic.PostTransferExecutionService;

public class ClassicPostExecutionService
implements PostTransferExecutionService {
    private final ExecutorService _executor = Executors.newCachedThreadPool();

    @Override
    public void execute(final PoolIORequest request) {
        final CDC cdc = new CDC();
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                cdc.restore();
                try {
                    request.close();
                }
                catch (InterruptedException e) {
                    request.setTransferStatus(666, "Transfer was killed");
                }
                catch (CacheException e) {
                    int rc = e.getRc();
                    String msg = e.getMessage();
                    if (rc == 204) {
                        request.getFaultListener().faultOccurred(new FaultEvent("repository", FaultAction.DISABLED, msg, e));
                    }
                    request.setTransferStatus(rc, msg);
                }
                catch (Exception e) {
                    request.setTransferStatus(10011, "Transfer failed due to unexpected exception: " + e.getMessage());
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    request.setTransferStatus(10011, "Transfer failed due to unexpected exception: " + e.getMessage());
                }
                request.sendBillingMessage();
                request.sendFinished();
                CDC.clear();
            }
        });
    }
}

