/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.NotInTrashCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.StorageInfo;
import dmg.util.Args;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellLifeCycleAware;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.classic.ChecksumModuleV1;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.util.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumScanner
implements CellCommandListener,
CellLifeCycleAware {
    private static final Logger _log = LoggerFactory.getLogger(ChecksumScanner.class);
    private final FullScan _fullScan = new FullScan();
    private final Scrubber _scrubber = new Scrubber();
    private final SingleScan _singleScan = new SingleScan();
    private Repository _repository;
    private PnfsHandler _pnfs;
    private ChecksumModuleV1 _csm;
    private File _scrubberStateFile;
    private final Map<PnfsId, Checksum> _bad = new ConcurrentHashMap<PnfsId, Checksum>();
    public static final String hh_csm_check = " [ * | <pnfsId> ]";
    public static final String hh_csm_show_errors = "# show errors found with 'csm check'";

    public void startScrubber() {
        this._scrubber.start();
    }

    public void stopScrubber() {
        this._scrubber.kill();
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    public void setPnfs(PnfsHandler pnfs) {
        this._pnfs = pnfs;
    }

    public void setChecksumModule(ChecksumModuleV1 csm) {
        this._csm = csm;
    }

    public void setScrubberStateFile(File path) {
        this._scrubberStateFile = path;
    }

    private Checksum checkFile(File file, double throughputLimit) throws IOException, InterruptedException {
        return this._csm.getDefaultChecksumFactory().computeChecksum(file, throughputLimit);
    }

    private Checksum readChecksum(CacheEntry entry) throws CacheException {
        String flags;
        StorageInfo info = entry.getStorageInfo();
        String string = flags = info == null ? null : info.getKey("flag-c");
        if (flags == null) {
            return this._csm.getDefaultChecksumFactory().find(this._pnfs.getFileAttributes(entry.getPnfsId(), EnumSet.of(FileAttribute.CHECKSUM)).getChecksums());
        }
        return Checksum.parseChecksum((String)flags);
    }

    public String ac_csm_check_$_1(Args args) throws Exception {
        if (args.argv(0).equals("*")) {
            this._fullScan.start();
        } else {
            this._singleScan.go(new PnfsId(args.argv(0)));
        }
        return "Started ...; check 'csm status' for status";
    }

    public String ac_csm_status(Args args) {
        return this._fullScan.toString() + "\n" + this._singleScan.toString() + "\n" + this._scrubber.toString();
    }

    public String ac_csm_show_errors(Args args) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<PnfsId, Checksum> e : this._bad.entrySet()) {
            builder.append(e.getKey()).append(" -> ").append(e.getValue()).append('\n');
        }
        return builder.toString();
    }

    @Override
    public void afterStart() {
        this.startScrubber();
    }

    @Override
    public void beforeStop() {
        this.stopScrubber();
    }

    private abstract class Singleton {
        private final String _name;
        private Exception _lastException;
        private Thread _currentThread;

        private Singleton(String name) {
            this._name = name;
        }

        protected abstract void runIt() throws Exception;

        public synchronized void kill() {
            if (this.isActive()) {
                this._currentThread.interrupt();
            }
        }

        public synchronized boolean isActive() {
            return this._currentThread != null;
        }

        private synchronized void stopped() {
            this._currentThread = null;
        }

        public synchronized void setException(Exception exception) {
            this._lastException = exception;
            _log.error(exception.toString());
        }

        public synchronized Exception getException() {
            return this._lastException;
        }

        public synchronized void start() {
            if (this.isActive()) {
                throw new IllegalStateException("Still active");
            }
            this._lastException = null;
            this._currentThread = new Thread(this._name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Singleton.this.runIt();
                    }
                    catch (Exception ee) {
                        Singleton.this._lastException = ee;
                    }
                    finally {
                        Singleton.this.stopped();
                    }
                }
            };
            this._currentThread.start();
        }

        public synchronized String toString() {
            return this._name + (this.isActive() ? " Active " : " Idle ") + (this._lastException == null ? "" : this._lastException.toString());
        }
    }

    private class Scrubber
    extends Singleton {
        private final long CHECKPOINT_INTERVAL;
        private final long FAILURE_RATELIMIT_DELAY;
        private volatile int _badCount;
        private volatile int _numFiles;
        private volatile int _totalCount;
        private PnfsId _lastFileChecked;
        private long _lastCheckpoint;
        private long _lastStart;

        public Scrubber() {
            super("Scrubber");
            this.CHECKPOINT_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
            this.FAILURE_RATELIMIT_DELAY = TimeUnit.SECONDS.toMillis(10L);
        }

        private void saveState() {
            String line = this._lastStart + " " + (this._lastFileChecked == null ? "-" : this._lastFileChecked);
            try {
                Files.write((CharSequence)line, (File)ChecksumScanner.this._scrubberStateFile, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                _log.error("Failed to save scrubber state ({}) to {}: {}", new Object[]{line, ChecksumScanner.this._scrubberStateFile, e.getMessage()});
            }
        }

        private void initializeFromSavedState() {
            String line;
            try {
                line = Files.readFirstLine((File)ChecksumScanner.this._scrubberStateFile, (Charset)Charset.defaultCharset());
            }
            catch (FileNotFoundException e) {
                this._lastStart = System.currentTimeMillis();
                return;
            }
            catch (IOException e) {
                _log.error("Failed to read scrubber saved state from {}: {}", (Object)ChecksumScanner.this._scrubberStateFile, (Object)e.getMessage());
                return;
            }
            String[] fields = line.split(" ");
            if (fields.length != 2) {
                _log.error("scrubber saved state in {} has an invalid format: {}", (Object)ChecksumScanner.this._scrubberStateFile, (Object)line);
                return;
            }
            try {
                this._lastStart = Long.parseLong(fields[0]);
            }
            catch (NumberFormatException e) {
                _log.error("Failed to read the last scrubber start time from {}: {}", (Object)ChecksumScanner.this._scrubberStateFile, (Object)e.getMessage());
                return;
            }
            if (PnfsId.isValid(fields[1])) {
                _log.debug("Resuming scrubbing from the first file with a pnfs id greater than {}", (Object)fields[1]);
                this._lastFileChecked = new PnfsId(fields[1]);
            } else if (!fields[1].equals("-")) {
                _log.error("Last checked pnfs id within {} has an invalid format: {}", (Object)ChecksumScanner.this._scrubberStateFile, (Object)fields[1]);
            }
        }

        private boolean isFirstStart() {
            return !ChecksumScanner.this._scrubberStateFile.exists();
        }

        private boolean isResuming() {
            return this._lastFileChecked != null;
        }

        private void waitUntil(long t) throws InterruptedException {
            long now;
            while ((now = System.currentTimeMillis()) < t) {
                Thread.sleep(t - now);
            }
        }

        @Override
        public synchronized void start() {
            if (ChecksumScanner.this._csm.isScrubbingEnabled() && !this.isActive()) {
                super.start();
            }
        }

        @Override
        public void runIt() throws InterruptedException {
            this.initializeFromSavedState();
            boolean isFinished = !this.isFirstStart() && !this.isResuming();
            try {
                while (true) {
                    if (isFinished) {
                        _log.debug("Next scrub start is {}", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date(this._lastStart + ChecksumScanner.this._csm.getScrubPeriod())));
                        if (System.currentTimeMillis() - this._lastStart > ChecksumScanner.this._csm.getScrubPeriod()) {
                            _log.warn("The last scrub took longer time to finish ({} s.) than the configured period ({} s.) - consider increasing the scrubbing period", (Object)(System.currentTimeMillis() - this._lastStart), (Object)ChecksumScanner.this._csm.getScrubPeriod());
                        }
                        this.waitUntil(this._lastStart + ChecksumScanner.this._csm.getScrubPeriod());
                        this._lastStart = System.currentTimeMillis();
                        isFinished = false;
                    }
                    try {
                        PnfsId[] toScan = this.getFilesToVerify();
                        this._numFiles = toScan.length;
                        this._badCount = 0;
                        this._totalCount = 0;
                        this.scanFiles(toScan);
                        if (this._badCount > 0) {
                            _log.warn("Finished scrubbing. Found {} bad files of {}", (Object)this._badCount, (Object)this._numFiles);
                        }
                        isFinished = true;
                    }
                    catch (IllegalStateException e) {
                        Thread.sleep(this.FAILURE_RATELIMIT_DELAY);
                    }
                    catch (TimeoutCacheException e) {
                        Thread.sleep(this.FAILURE_RATELIMIT_DELAY);
                    }
                    catch (CacheException e) {
                        _log.error("Received an unexpected error during scrubbing: {}", (Object)e.getMessage());
                        Thread.sleep(this.FAILURE_RATELIMIT_DELAY);
                    }
                }
            }
            catch (Throwable throwable) {
                _log.debug("Stopping scrubber");
                this.saveState();
                throw throwable;
            }
        }

        private PnfsId[] getFilesToVerify() {
            Object[] repcopy = (PnfsId[])Iterables.toArray((Iterable)ChecksumScanner.this._repository, PnfsId.class);
            Arrays.sort(repcopy);
            if (!this.isResuming()) {
                return repcopy;
            }
            int index = Arrays.binarySearch(repcopy, this._lastFileChecked);
            if (index >= 0) {
                return (PnfsId[])Arrays.copyOfRange(repcopy, index + 1, repcopy.length);
            }
            return (PnfsId[])Arrays.copyOfRange(repcopy, -index - 1, repcopy.length);
        }

        private boolean isChecksumOk(PnfsId id) throws InterruptedException, CacheException {
            ReplicaDescriptor handle = ChecksumScanner.this._repository.openEntry(id, EnumSet.of(Repository.OpenFlags.NOATIME));
            try {
                Checksum storedChecksum = ChecksumScanner.this.readChecksum(handle.getEntry());
                if (storedChecksum == null) {
                    boolean bl = true;
                    return bl;
                }
                File file = handle.getFile();
                Checksum newChecksum = ChecksumScanner.this.checkFile(file, ChecksumScanner.this._csm.getThroughputLimit());
                boolean bl = storedChecksum.equals((Object)newChecksum);
                return bl;
            }
            catch (IOException e) {
                throw new DiskErrorCacheException("Failed to checksum " + id + ": " + e.getMessage());
            }
            finally {
                handle.close();
            }
        }

        private void checkpointIfNeeded() {
            if (System.currentTimeMillis() - this._lastCheckpoint > this.CHECKPOINT_INTERVAL) {
                this.saveState();
                this._lastCheckpoint = System.currentTimeMillis();
            }
        }

        private void scanFiles(PnfsId[] repository) throws InterruptedException, CacheException {
            for (PnfsId id : repository) {
                if (ChecksumScanner.this._repository.getState(id) == EntryState.CACHED || ChecksumScanner.this._repository.getState(id) == EntryState.PRECIOUS) {
                    try {
                        if (!this.isChecksumOk(id)) {
                            ++this._badCount;
                            _log.error("Checksum mismatch detected for {} - marking as BROKEN", (Object)id);
                            try {
                                ChecksumScanner.this._repository.setState(id, EntryState.BROKEN);
                            }
                            catch (IllegalTransitionException e) {
                                _log.warn("Failed to mark {} as BROKEN: {}", (Object)id, (Object)e.getMessage());
                            }
                        }
                        this._lastFileChecked = id;
                    }
                    catch (FileNotInCacheException e) {
                    }
                    catch (DiskErrorCacheException e) {
                        _log.error("Failed to verify the checksum of {} (skipping): {}", (Object)id, (Object)e.getMessage());
                    }
                }
                ++this._totalCount;
                this.checkpointIfNeeded();
            }
            this._lastFileChecked = null;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this._totalCount + " of " + this._numFiles + " checked; " + this._badCount + " errors detected";
        }
    }

    private class SingleScan
    extends Singleton {
        private volatile PnfsId _pnfsId;
        private volatile Checksum _fileCRC;
        private volatile Checksum _infoCRC;

        public SingleScan() {
            super("SingeScan");
        }

        public synchronized void go(PnfsId pnfsId) throws Exception {
            this._pnfsId = pnfsId;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runIt() throws Exception {
            ChecksumScanner.this.stopScrubber();
            try {
                this._fileCRC = null;
                this._infoCRC = null;
                ReplicaDescriptor handle = ChecksumScanner.this._repository.openEntry(this._pnfsId, EnumSet.of(Repository.OpenFlags.NOATIME));
                try {
                    this._fileCRC = ChecksumScanner.this.checkFile(handle.getFile(), Double.POSITIVE_INFINITY);
                    this._infoCRC = ChecksumScanner.this.readChecksum(handle.getEntry());
                    if (this._infoCRC != null && !this._infoCRC.equals((Object)this._fileCRC)) {
                        ChecksumScanner.this._bad.put(this._pnfsId, this._fileCRC);
                    }
                }
                finally {
                    handle.close();
                }
            }
            finally {
                ChecksumScanner.this.startScrubber();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this._pnfsId != null) {
                sb.append("  ").append(this._pnfsId).append(" ");
                if (this._fileCRC != null && this._infoCRC == null) {
                    sb.append("No StorageInfo, crc = ").append(this._fileCRC);
                } else if (this._fileCRC == null || this._infoCRC == null) {
                    sb.append("BUSY");
                } else if (this._fileCRC.equals((Object)this._infoCRC)) {
                    sb.append("OK ").append(this._fileCRC.toString());
                } else {
                    sb.append("BAD File = ").append(this._fileCRC).append(" Expected = ").append(this._infoCRC);
                }
            }
            return sb.toString();
        }
    }

    private class FullScan
    extends Singleton {
        private volatile int _totalCount;
        private volatile int _badCount;

        public FullScan() {
            super("FullScan");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runIt() throws Exception {
            ChecksumScanner.this.stopScrubber();
            try {
                this._badCount = 0;
                this._totalCount = 0;
                ChecksumScanner.this._bad.clear();
                for (PnfsId id : ChecksumScanner.this._repository) {
                    try {
                        ReplicaDescriptor handle = ChecksumScanner.this._repository.openEntry(id, EnumSet.of(Repository.OpenFlags.NOATIME));
                        try {
                            Checksum replica = ChecksumScanner.this.checkFile(handle.getFile(), Double.POSITIVE_INFINITY);
                            Checksum file = ChecksumScanner.this.readChecksum(handle.getEntry());
                            ++this._totalCount;
                            if (file == null || file.equals((Object)replica)) continue;
                            ChecksumScanner.this._bad.put(id, replica);
                            ++this._badCount;
                        }
                        finally {
                            handle.close();
                        }
                    }
                    catch (FileNotInCacheException e) {
                    }
                    catch (NotInTrashCacheException notInTrashCacheException) {}
                }
            }
            finally {
                ChecksumScanner.this.startScrubber();
            }
        }

        @Override
        public String toString() {
            return super.toString() + " " + this._totalCount + " checked; " + this._badCount + " errors detected";
        }
    }
}

